/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.PulseRelayParameter;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.util.Language;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class PulseRelayPanel
extends BlockParameterPanel {
    private JRadioButton fSetPreferredButton;
    private JRadioButton fResetPreferredButton;

    public PulseRelayPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        Box panel = new Box(1);
        this.addParameterPane(panel);
        this.fSetPreferredButton = new JRadioButton();
        this.fResetPreferredButton = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fSetPreferredButton);
        buttonGroup.add(this.fResetPreferredButton);
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.fResetPreferredButton);
        panel.add(this.fSetPreferredButton);
        Hardware hw = ((BlockParameter)parameterReference).getBlock().getWiringDiagram().getHardware();
        if (!hw.supports("pulseRelayWithSetInput")) {
            panel.setVisible(false);
        }
    }

    public boolean checkChanged() {
        PulseRelayParameter pulseRelayParameter = (PulseRelayParameter)this.getParameterReference();
        if (super.checkChanged()) {
            return true;
        }
        return this.fSetPreferredButton.isSelected() != (pulseRelayParameter.getPreference() == "SR");
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        PulseRelayParameter pulseRelayParameter = (PulseRelayParameter)this.getParameterReference();
        boolean setPreference = pulseRelayParameter.isSetPreferred();
        this.fSetPreferredButton.setSelected(setPreference);
        this.fResetPreferredButton.setSelected(!setPreference);
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        PulseRelayParameter pulseRelayParameter = (PulseRelayParameter)this.getParameterReference();
        boolean setPreferred = this.fSetPreferredButton.isSelected();
        if (setPreferred) {
            pulseRelayParameter.setPreference("SR");
        } else {
            pulseRelayParameter.setPreference("RS");
        }
    }

    public void setLabels() {
        super.setLabels();
        this.fSetPreferredButton.setText(Language.getString("pulseRelayPanel.setPreferred", "S-Input preferred"));
        this.fResetPreferredButton.setText(Language.getString("pulseRelayPanel.resetPreferred", "R-Input preferred"));
    }
}

