/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.DecimalPlacePanel;
import DE.siemens.ad.logo.dialog.comp.MeasurementPanel;
import DE.siemens.ad.logo.dialog.comp.TimeValueOrReferencePanel;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.PWMParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PWMPanel
extends AbstractProtectionPanel {
    private static final long serialVersionUID = -8630107789200439630L;
    private MeasurementPanel fMeasurementPanel;
    private DecimalPlacePanel fDecimalPlacesPanel;
    private TimeValueOrReferencePanel fPeriodTimePane;
    private JLabel fLblRangeMin;
    private EditableNumericSpinner fRangeMinSpinner;
    private JLabel fLblRangeMax;
    private EditableNumericSpinner fRangeMaxSpinner;

    public PWMPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.initComponents();
        Block block = ((BlockParameter)this.fParameterReference).getBlock();
        this.fPeriodTimePane.setReferenceList(block.getWiringDiagram().getBlocksForReference(block, true));
        this.fPeriodTimePane.setReferenceVisability(parameterReference.isValueOrReference());
        this.fPeriodTimePane.setLabels();
    }

    private void initComponents() {
        JPanel parameterPanel = new JPanel(new GridBagLayout());
        this.fMeasurementPanel = new MeasurementPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        parameterPanel.add((Component)this.fMeasurementPanel, gbc);
        JPanel triggerBorder = new JPanel();
        triggerBorder.setLayout(new GridBagLayout());
        this.fLblRangeMin = new JLabel("(default)Range Min:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 20, 5, 5);
        gbc.anchor = 17;
        triggerBorder.add((Component)this.fLblRangeMin, gbc);
        this.fRangeMinSpinner = new EditableNumericSpinner();
        this.fRangeMinSpinner.setColumns(6);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        triggerBorder.add((Component)this.fRangeMinSpinner, gbc);
        this.fLblRangeMax = new JLabel("(default)Range Max:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 20, 5, 5);
        gbc.anchor = 17;
        triggerBorder.add((Component)this.fLblRangeMax, gbc);
        this.fRangeMaxSpinner = new EditableNumericSpinner();
        this.fRangeMaxSpinner.setColumns(6);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        triggerBorder.add((Component)this.fRangeMaxSpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        parameterPanel.add((Component)triggerBorder, gbc);
        Timer timer = ((PWMParameter)this.fParameterReference).getTimer();
        Hardware hw = ((BlockParameter)this.fParameterReference).getBlock().getHardware();
        TimeUnit[] availableTimeUnits = (TimeUnit[])hw.getProperty("availableTimeUnits");
        timer.convertTimerTo(availableTimeUnits);
        this.fPeriodTimePane = new TimeValueOrReferencePanel(timer);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        triggerBorder.add((Component)this.fPeriodTimePane, gbc);
        this.fDecimalPlacesPanel = new DecimalPlacePanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 16;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        parameterPanel.add((Component)this.fDecimalPlacesPanel, gbc);
        this.addParameterPane(parameterPanel);
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        this.fPeriodTimePane.loadFieldContents();
        PWMParameter PWMParameter1 = (PWMParameter)this.fParameterReference;
        this.fMeasurementPanel.setModel(PWMParameter1.getMeasurement());
        try {
            this.fMeasurementPanel.loadFieldContents();
        }
        catch (ProgramException e) {
            e.printStackTrace();
        }
        this.fRangeMinSpinner.setProperties(PWMParameter1.getRangeMinProperties());
        this.fRangeMaxSpinner.setProperties(PWMParameter1.getRangeMaxProperties());
        this.fDecimalPlacesPanel.setAnalog((Analog)this.fParameterReference);
        this.fDecimalPlacesPanel.loadFieldContents();
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        this.fMeasurementPanel.storeFieldContents();
        this.fDecimalPlacesPanel.storeFieldContents();
        this.fPeriodTimePane.storeFieldContents();
        ((PWMParameter)this.fParameterReference).setRangeMin(this.fRangeMinSpinner.getValue());
        ((PWMParameter)this.fParameterReference).setRangeMax(this.fRangeMaxSpinner.getValue());
        ((PWMParameter)this.fParameterReference).notifyParamUpdated();
    }

    public void setLabels() {
        super.setLabels();
        this.fMeasurementPanel.setLabels();
        this.fDecimalPlacesPanel.setLabels();
        this.fLblRangeMin.setText(Language.getString("dialog.parameter.PWM.RangeMin", "Range Min:"));
        this.fLblRangeMax.setText(Language.getString("dialog.parameter.PWM.RangeMax", "Range Max:"));
    }

    public boolean checkChanged() {
        PWMParameter PWMParameter1 = (PWMParameter)this.fParameterReference;
        return super.checkChanged() || this.fRangeMinSpinner.getValue() != PWMParameter1.getRangeMin() || this.fRangeMaxSpinner.getValue() != PWMParameter1.getRangeMax() || this.fPeriodTimePane.checkChanged() || this.fMeasurementPanel.checkChanged() || this.fDecimalPlacesPanel.checkChanged();
    }

    public boolean checkFieldContents() {
        return super.checkFieldContents() && this.fPeriodTimePane.checkFieldContents() && this.fMeasurementPanel.checkFieldContents() && this.fDecimalPlacesPanel.checkFieldContents() && this.fRangeMinSpinner.checkValue(true) && this.fRangeMaxSpinner.checkValue(true);
    }
}

