/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.DoubleNumericSpinner;
import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.SimulationParameterPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class InputSimulationPanel
extends SimulationParameterPanel {
    protected JLabel fSwitchLabel;
    protected JRadioButton fSwitchButton;
    protected JRadioButton fKeyNormallyOpenedButton;
    protected JRadioButton fKeyNormallyClosedButton;
    protected JRadioButton fFrequencyButton;
    protected DoubleNumericSpinner fCurrentValue;
    protected DoubleNumericSpinner fMinValue;
    protected DoubleNumericSpinner fMaxValue;
    protected JLabel fCurrentLabel;
    protected JLabel fMinLabel;
    protected JLabel fMaxLabel;
    protected JCheckBox fAutoRangeCheckBox;

    public InputSimulationPanel() {
    }

    public InputSimulationPanel(Vector panels, Parameter parameterReference) {
        super(panels, parameterReference);
        this.initComponents();
    }

    public InputSimulationPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        this(panels, parameterReference);
    }

    public boolean checkChanged() {
        InputSimulationParameter inputSimulationParameter = (InputSimulationParameter)this.fParameterReference;
        return this.fSwitchButton.isSelected() != (inputSimulationParameter.getSwitchMode() == 0) || this.fKeyNormallyOpenedButton.isSelected() != (inputSimulationParameter.getSwitchMode() == 1) || this.fKeyNormallyClosedButton.isSelected() != (inputSimulationParameter.getSwitchMode() == 8) || this.fFrequencyButton.isSelected() != (inputSimulationParameter.getSwitchMode() == 2) || this.fAutoRangeCheckBox.isSelected() != inputSimulationParameter.isAutoMeasurementRange() || this.fCurrentValue.getValue() != inputSimulationParameter.getExternAnalogValue() || this.fMinValue.getValue() != inputSimulationParameter.getMinValue() || this.fMaxValue.getValue() != inputSimulationParameter.getMaxValue();
    }

    public boolean checkFieldContents() {
        if (!this.fCurrentValue.checkValue(true)) {
            this.fCurrentValue.requestFocus();
            return false;
        }
        if (!this.fMinValue.checkValue(true)) {
            this.fMinValue.requestFocus();
            return false;
        }
        if (!this.fMaxValue.checkValue(true)) {
            this.fMaxValue.requestFocus();
            return false;
        }
        return true;
    }

    private void enableDisableFrequencyInputFields() {
        boolean frequence = this.fFrequencyButton.isSelected();
        boolean autoRange = this.fAutoRangeCheckBox.isSelected();
        this.fCurrentLabel.setEnabled(frequence);
        this.fCurrentValue.setEnabled(frequence);
        this.fMinLabel.setEnabled(frequence && !autoRange);
        this.fMinValue.setEnabled(frequence && !autoRange);
        this.fMaxLabel.setEnabled(frequence && !autoRange);
        this.fMaxValue.setEnabled(frequence && !autoRange);
        this.fAutoRangeCheckBox.setEnabled(frequence);
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.fSwitchButton = new JRadioButton("Switch");
        this.fKeyNormallyOpenedButton = new JRadioButton("Momentary (normally opened)");
        this.fKeyNormallyClosedButton = new JRadioButton("Momentary (normally closed)");
        this.fFrequencyButton = new JRadioButton("Frequency");
        this.fCurrentValue = new DoubleNumericSpinner();
        this.fMinValue = new DoubleNumericSpinner();
        this.fMaxValue = new DoubleNumericSpinner();
        this.fAutoRangeCheckBox = new JCheckBox("Auto range");
        this.fCurrentLabel = new JLabel("Current value");
        this.fMinLabel = new JLabel("Minimal value");
        this.fMaxLabel = new JLabel("Maximal value");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.fSwitchButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.gridwidth = 3;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.fKeyNormallyOpenedButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = 3;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.fKeyNormallyClosedButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.fFrequencyButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 20, 5, 5);
        this.add((Component)this.fCurrentLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fAutoRangeCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fMinLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fMaxLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 20, 5, 5);
        this.add((Component)this.fCurrentValue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fMinValue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 6;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fMaxValue, gbc);
        JPanel placeholder = new JPanel(null);
        placeholder.setPreferredSize(new Dimension(20, 10));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)placeholder, gbc);
        JPanel fillerPanel = new JPanel();
        gbc.gridx = 10;
        gbc.gridy = 11;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)fillerPanel, gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.fSwitchButton);
        group.add(this.fKeyNormallyOpenedButton);
        group.add(this.fKeyNormallyClosedButton);
        group.add(this.fFrequencyButton);
        RadioButtonActionListener rbal = new RadioButtonActionListener();
        this.fFrequencyButton.addActionListener(rbal);
        this.fSwitchButton.addActionListener(rbal);
        this.fKeyNormallyOpenedButton.addActionListener(rbal);
        this.fKeyNormallyClosedButton.addActionListener(rbal);
        this.fAutoRangeCheckBox.addActionListener(rbal);
    }

    public void loadFieldContents() {
        InputSimulationParameter inputSimulationParameter = (InputSimulationParameter)this.fParameterReference;
        this.fSwitchButton.setSelected(inputSimulationParameter.getSwitchMode() == 0);
        this.fKeyNormallyOpenedButton.setSelected(inputSimulationParameter.getSwitchMode() == 1);
        this.fKeyNormallyClosedButton.setSelected(inputSimulationParameter.getSwitchMode() == 8);
        this.fFrequencyButton.setSelected(inputSimulationParameter.getSwitchMode() == 2);
        this.fAutoRangeCheckBox.setSelected(inputSimulationParameter.isAutoMeasurementRange());
        this.fCurrentValue.setProperties(inputSimulationParameter.getExternAnalogValueProperties());
        this.fMinValue.setProperties(inputSimulationParameter.getMinValueProperties());
        this.fMaxValue.setProperties(inputSimulationParameter.getMaxValueProperties());
        this.enableDisableFrequencyInputFields();
    }

    public void setLabels() {
        this.fSwitchButton.setText(Language.getString("dialog.switch.switch", "Switch"));
        this.fKeyNormallyOpenedButton.setText(Language.getString("dialog.switch.key.opened", "Momentary (normally opened)"));
        this.fKeyNormallyClosedButton.setText(Language.getString("dialog.switch.key.closed", "Momentary (normally closed)"));
        this.fFrequencyButton.setText(Language.getString("dialog.switch.frequency", "Frequency"));
        this.fAutoRangeCheckBox.setText(Language.getString("dialog.switch.autoRange", "Auto range"));
        this.fCurrentLabel.setText(Language.getString("dialog.switch.currentValue", "Current Value"));
        this.fMinLabel.setText(Language.getString("dialog.switch.minValue.long", "Minimaler Wert"));
        this.fMaxLabel.setText(Language.getString("dialog.switch.maxValue.long", "Maximaler Wert"));
    }

    public void storeFieldContents() {
        InputSimulationParameter inputSimulationParameter = (InputSimulationParameter)this.fParameterReference;
        if (this.fSwitchButton.isSelected()) {
            inputSimulationParameter.setSwitchMode(0);
        }
        if (this.fKeyNormallyOpenedButton.isSelected()) {
            inputSimulationParameter.setSwitchMode(1);
        }
        if (this.fKeyNormallyClosedButton.isSelected()) {
            inputSimulationParameter.setSwitchMode(8);
        }
        if (this.fFrequencyButton.isSelected()) {
            inputSimulationParameter.setSwitchMode(2);
        }
        inputSimulationParameter.setExternAnalogValue(this.fCurrentValue.getValue());
        inputSimulationParameter.setAutoMeasurementRange(this.fAutoRangeCheckBox.isSelected());
        inputSimulationParameter.setMinValue(this.fMinValue.getValue());
        inputSimulationParameter.setMaxValue(this.fMaxValue.getValue());
        inputSimulationParameter.fireParameterSetEvent();
    }

    private class RadioButtonActionListener
    implements ActionListener {
        private RadioButtonActionListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            InputSimulationPanel.this.enableDisableFrequencyInputFields();
        }
    }
}

