/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.DoubleNumericSpinner;
import DE.siemens.ad.logo.model.AnalogInputSimulationParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.SimulationParameterPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AnalogInputSimulationPanel
extends SimulationParameterPanel {
    protected JLabel fSwitchLabel;
    protected DoubleNumericSpinner fCurrentValue;
    protected DoubleNumericSpinner fMinValue;
    protected DoubleNumericSpinner fMaxValue;
    protected JLabel fCurrentLabel;
    protected JLabel fMinLabel;
    protected JLabel fMaxLabel;
    protected JCheckBox fAutoRangeCheckBox;

    public AnalogInputSimulationPanel() {
    }

    public AnalogInputSimulationPanel(Vector panels, Parameter parameterReference) {
        super(panels, parameterReference);
        this.initComponents();
    }

    public AnalogInputSimulationPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        this(panels, parameterReference);
    }

    public boolean checkFieldContents() {
        if (!this.fCurrentValue.checkValue(true)) {
            this.fCurrentValue.requestFocus();
            return false;
        }
        if (!this.fMinValue.checkValue(true)) {
            this.fMinValue.requestFocus();
            return false;
        }
        if (!this.fMaxValue.checkValue(true)) {
            this.fMaxValue.requestFocus();
            return false;
        }
        return true;
    }

    private void enableDisableMinMax() {
        boolean autoRange = this.fAutoRangeCheckBox.isSelected();
        this.fMinLabel.setEnabled(!autoRange);
        this.fMaxLabel.setEnabled(!autoRange);
        this.fMinValue.setEnabled(!autoRange);
        this.fMaxValue.setEnabled(!autoRange);
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.fCurrentValue = new DoubleNumericSpinner();
        this.fMinValue = new DoubleNumericSpinner();
        this.fMaxValue = new DoubleNumericSpinner();
        this.fAutoRangeCheckBox = new JCheckBox("Auto range");
        this.fCurrentLabel = new JLabel("Current value");
        this.fMinLabel = new JLabel("Minimal value");
        this.fMaxLabel = new JLabel("Maximal value");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fCurrentLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fAutoRangeCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fMinLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fMaxLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fCurrentValue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fMinValue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fMaxValue, gbc);
        JPanel fillerPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)fillerPanel, gbc);
        JPanel placeholder = new JPanel(null);
        placeholder.setPreferredSize(new Dimension(20, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)placeholder, gbc);
        this.fAutoRangeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AnalogInputSimulationPanel.this.enableDisableMinMax();
            }
        });
    }

    public void loadFieldContents() {
        AnalogInputSimulationParameter inputSimulationParameter = (AnalogInputSimulationParameter)this.fParameterReference;
        this.fAutoRangeCheckBox.setSelected(inputSimulationParameter.isAutoMeasurementRange());
        this.fCurrentValue.setProperties(inputSimulationParameter.getExternAnalogValueProperties());
        this.fMinValue.setProperties(inputSimulationParameter.getMinValueProperties());
        this.fMaxValue.setProperties(inputSimulationParameter.getMaxValueProperties());
        this.enableDisableMinMax();
    }

    public void setLabels() {
        this.fAutoRangeCheckBox.setText(Language.getString("dialog.switch.autoRange", "Auto range"));
        this.fCurrentLabel.setText(Language.getString("dialog.switch.currentValue", "Current Value"));
        this.fMinLabel.setText(Language.getString("dialog.switch.minValue.long", "Minimaler Wert"));
        this.fMaxLabel.setText(Language.getString("dialog.switch.maxValue.long", "Maximaler Wert"));
    }

    public void storeFieldContents() {
        AnalogInputSimulationParameter inputSimulationParameter = (AnalogInputSimulationParameter)this.fParameterReference;
        inputSimulationParameter.setExternAnalogValue(this.fCurrentValue.getValue());
        inputSimulationParameter.fireParameterSetEvent();
        inputSimulationParameter.setAutoMeasurementRange(this.fAutoRangeCheckBox.isSelected());
        inputSimulationParameter.setMinValue(this.fMinValue.getValue());
        inputSimulationParameter.setMaxValue(this.fMaxValue.getValue());
        inputSimulationParameter.fireParameterSetEvent();
    }
}

