/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.DecimalPlacePanel;
import DE.siemens.ad.logo.dialog.comp.IntegerOrReferencePanel;
import DE.siemens.ad.logo.dialog.comp.MeasurementPanel;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogComparatorParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AnalogComparatorPanel
extends AbstractProtectionPanel {
    private DecimalPlacePanel fDecimalPlacesPanel;
    private EditableNumericSpinner fTriggerSpinner;
    private IntegerOrReferencePanel fOnTrigger;
    private IntegerOrReferencePanel fOffTrigger;
    private JLabel fLblOn;
    private JLabel fLblOff;
    private TitledBorder fTriggerBorder;
    private JPanel fTriggerPanel;
    private JLabel fLblTrigger;
    private MeasurementPanel fMeasurementPanel;

    public AnalogComparatorPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.initComponents(parameterReference);
    }

    private void initComponents(Parameter parameterReference) {
        JPanel parameterPanel = new JPanel();
        parameterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.fMeasurementPanel = new MeasurementPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        parameterPanel.add((Component)this.fMeasurementPanel, gbc);
        this.fTriggerPanel = new JPanel();
        this.fTriggerBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        this.fTriggerPanel.setLayout(new GridBagLayout());
        this.fLblOn = new JLabel("On");
        this.fOnTrigger = new IntegerOrReferencePanel();
        this.fOnTrigger.setReferenceVisability(parameterReference.isValueOrReference());
        this.fLblOff = new JLabel("Off");
        this.fOffTrigger = new IntegerOrReferencePanel();
        this.fOffTrigger.setReferenceVisability(parameterReference.isValueOrReference());
        this.fTriggerSpinner = new EditableNumericSpinner();
        this.fLblTrigger = new JLabel("Schwellwert");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        parameterPanel.add((Component)this.fTriggerPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        parameterPanel.add((Component)new JPanel(), gbc);
        this.fDecimalPlacesPanel = new DecimalPlacePanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 16;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        parameterPanel.add((Component)this.fDecimalPlacesPanel, gbc);
        this.addParameterPane(parameterPanel);
    }

    public boolean checkChanged() {
        AnalogComparatorParameter analogComparatorParameter = (AnalogComparatorParameter)this.fParameterReference;
        if (this.fMeasurementPanel.checkChanged()) {
            return true;
        }
        if (analogComparatorParameter.isOnOffAvailable() ? this.fOnTrigger.checkChanged() || this.fOffTrigger.checkChanged() : this.fTriggerSpinner.checkChanged()) {
            return true;
        }
        if (this.fDecimalPlacesPanel.checkChanged()) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        AnalogComparatorParameter analogComparatorParameter = (AnalogComparatorParameter)this.fParameterReference;
        if (!this.fMeasurementPanel.checkValue(true)) {
            return false;
        }
        if (analogComparatorParameter.isOnOffAvailable() ? !this.fOnTrigger.checkValue(true) || !this.fOffTrigger.checkValue(true) : !this.fTriggerSpinner.checkValue(true)) {
            return false;
        }
        if (!this.fDecimalPlacesPanel.checkFieldContents()) {
            return false;
        }
        return super.checkFieldContents();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 350);
    }

    private void setOnOffTrigger() {
        this.fTriggerPanel.removeAll();
        this.fTriggerPanel.setBorder(this.fTriggerBorder);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.fTriggerPanel.add((Component)this.fLblOn, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.fTriggerPanel.add((Component)this.fOnTrigger, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.fTriggerPanel.add((Component)this.fLblOff, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.fTriggerPanel.add((Component)this.fOffTrigger, gbc);
    }

    private void setSingleTrigger() {
        this.fTriggerPanel.removeAll();
        GridBagConstraints gbc = null;
        this.fTriggerBorder.setBorder(null);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.fTriggerPanel.add((Component)this.fLblTrigger, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.fTriggerPanel.add((Component)this.fTriggerSpinner, gbc);
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        AnalogComparatorParameter analogComparatorParameter = (AnalogComparatorParameter)this.fParameterReference;
        this.fMeasurementPanel.setModel(analogComparatorParameter.getMeasurement());
        try {
            this.fMeasurementPanel.loadFieldContents();
        }
        catch (ProgramException e) {
            e.printStackTrace();
        }
        WiringDiagram wiringDiagram = ((BlockParameter)this.fParameterReference).getBlock().getWiringDiagram();
        Block notIncluded = ((BlockParameter)this.fParameterReference).getBlock();
        ArrayList blocksForReference = wiringDiagram.getBlocksForReference(notIncluded, true);
        this.fOnTrigger.setReferenceList(blocksForReference);
        this.fOffTrigger.setReferenceList(blocksForReference);
        this.fDecimalPlacesPanel.setAnalog((Analog)this.fParameterReference);
        this.fDecimalPlacesPanel.loadFieldContents();
        if (analogComparatorParameter.isOnOffAvailable()) {
            this.setOnOffTrigger();
            this.fOnTrigger.setProperties(analogComparatorParameter.getOnTrigger());
            this.fOffTrigger.setProperties(analogComparatorParameter.getOffTrigger());
        } else {
            this.setSingleTrigger();
            this.fTriggerSpinner.setProperties(analogComparatorParameter.getOnProperties());
        }
    }

    public void setLabels() {
        super.setLabels();
        this.fMeasurementPanel.setLabels();
        this.fTriggerBorder.setTitle(Language.getString("dialog.parameter.analogTrigger.triggerBorder", "Treshold"));
        this.fLblTrigger.setText(Language.getString("dialog.parameter.analogTrigger.triggerBorder", "Trigger"));
        this.fLblOn.setText(Language.getString("dialog.parameter.analog.on", "On"));
        this.fLblOff.setText(Language.getString("dialog.parameter.analog.off", "Off"));
        this.fDecimalPlacesPanel.setLabels();
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        AnalogComparatorParameter analogComparatorParameter = (AnalogComparatorParameter)this.fParameterReference;
        this.fMeasurementPanel.storeFieldContents();
        if (analogComparatorParameter.isOnOffAvailable()) {
            analogComparatorParameter.setOnProperties(this.fOnTrigger.getValue());
            analogComparatorParameter.setOffProperties(this.fOffTrigger.getValue());
        } else {
            analogComparatorParameter.setOn(this.fTriggerSpinner.getValue());
            analogComparatorParameter.setOff(this.fTriggerSpinner.getValue());
        }
        this.fDecimalPlacesPanel.setAnalog((Analog)this.fParameterReference);
        this.fDecimalPlacesPanel.storeFieldContents();
    }
}

