/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.LogoHardwareFactory;
import DE.siemens.ad.logo.model.lgoExImport.CBlock;
import DE.siemens.ad.logo.model.lgoExImport.ConvertWiringDiagram;
import DE.siemens.ad.logo.model.lgoExImport.PartsOfAnchor;
import DE.siemens.ad.logo.model.lgoExImport.PartsOfLgo;
import DE.siemens.ad.logo.model.lgoExImport.PartsOfParameter;
import DE.siemens.ad.logo.model.lgoExImport.PartsOfProgramm;
import java.util.Hashtable;
import java.util.Vector;

public class Transformer {
    private PartsOfLgo fPOL = null;
    private PartsOfProgramm fPOProgramm = null;
    private CBlock[] fPossibleCBlocks = null;
    private Hardware fHardware = null;
    private PartsOfParameter fPOParameter = null;
    private PartsOfAnchor fPOAnchor = null;
    private CBlock[] fdCBlocks = new CBlock[20];

    public Transformer(PartsOfLgo aktuell) {
        this.fPOL = aktuell;
        this.fPOAnchor = this.fPOL.getAnchorObject();
        this.fPOParameter = this.fPOL.getParameterObject();
        this.fPOProgramm = this.fPOL.getProgrammObject();
        this.fPossibleCBlocks = this.getPossibleCBlocks();
        this.fHardware = ((LogoHardwareFactory)HardwareFactory.getInstance()).getHardware(this.getHardwareIDComfort());
    }

    public int[] getAnchor() {
        int[] ankerSoft = this.fPOAnchor.getAnchor();
        int[] ankerComfort = new int[ankerSoft.length];
        for (int i = 0; i < ankerSoft.length; ++i) {
            ankerComfort[i] = this.getComfortOPCode(ankerSoft[i]);
        }
        return ankerComfort;
    }

    public int[] getAnchorsOpCodes() {
        int[] ankerSoft = this.fPOAnchor.getOpCodesOfAll();
        int[] ankerComfort = new int[ankerSoft.length];
        for (int i = 0; i < ankerSoft.length; ++i) {
            ankerComfort[i] = this.getComfortOPCode(ankerSoft[i]);
        }
        return ankerComfort;
    }

    public int getComfortOPCode(int softCode) {
        int comfortCode = 252;
        if (softCode > 64) {
            comfortCode = softCode + 1000;
        } else {
            try {
                Hardware hw = this.fHardware;
                CBlock[] blocks = this.fPossibleCBlocks;
                int blocknummer = this.getNumberOfSoftCode(softCode);
                boolean gefunden = false;
                for (int i = 0; !gefunden && i < blocks.length; ++i) {
                    if (!blocks[i].isRightSoftCode(softCode)) continue;
                    comfortCode = blocks[i].getComfortOPCode(hw, blocknummer);
                    gefunden = true;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return comfortCode;
    }

    public int getCountOfBlocks() {
        return this.fPOProgramm.getNumberOfProgLines();
    }

    public int getFirstParameterLineNumber() {
        if (this.whichInnovation() == 0) {
            return 1095;
        }
        return 1121;
    }

    public int getHardwareIDComfort() {
        int softHardwareID = this.fPOL.getHardwareID();
        if (softHardwareID == 1) {
            return 0;
        }
        if (softHardwareID == 2) {
            return 1;
        }
        if (softHardwareID == 6) {
            return 7;
        }
        return softHardwareID;
    }

    public Hashtable getIOPortComments() {
        return this.fPOL.getIOPortComments();
    }

    public int getLengthOfParameterLine() {
        return this.fPOParameter.getLengthOfParaLine();
    }

    protected int getNumberOfSoftCode(int softCode) {
        if (softCode > 1 && softCode < 8) {
            return softCode - 2;
        }
        if (softCode > 40 && softCode < 47) {
            return softCode - 41 + 6;
        }
        if (softCode > 46 && softCode < 51) {
            return softCode - 47;
        }
        if (softCode > 7 && softCode < 12) {
            return softCode - 8;
        }
        if (softCode > 50 && softCode < 55) {
            return softCode - 51 + 4;
        }
        if (softCode > 54 && softCode < 59) {
            return softCode - 55;
        }
        if (softCode > 13 && softCode < 18) {
            return softCode - 14;
        }
        return 0;
    }

    public int[] getParameter() {
        return this.fPOParameter.getPara();
    }

    public int[][] getParameter2() {
        return this.fPOParameter.getPara2();
    }

    protected CBlock[] getPossibleCBlocks() {
        Hardware hw = ((LogoHardwareFactory)HardwareFactory.getInstance()).getHardware(this.getHardwareIDComfort());
        Vector[] blocksAndType = hw.getAvailableBlocks();
        int anzahl = 0;
        for (int i = 0; i < blocksAndType.length; ++i) {
            anzahl += blocksAndType[i].size() - 1;
        }
        Vector blocks = new Vector(anzahl);
        for (int i = 0; i < blocksAndType.length; ++i) {
            Object useless = blocksAndType[i].get(0);
            for (int d = 1; d < blocksAndType[i].size(); ++d) {
                blocks.addElement(blocksAndType[i].get(d));
            }
        }
        ConvertWiringDiagram cwd = new ConvertWiringDiagram(blocks);
        return cwd.getAllCBlocks();
    }

    public int[] getProgOPCodes() {
        int[] progSoft = this.fPOProgramm.getOPCodes();
        int[] progComfort = new int[progSoft.length];
        for (int i = 0; i < progSoft.length; ++i) {
            progComfort[i] = this.getComfortOPCode(progSoft[i]);
        }
        return progComfort;
    }

    public int[] getProgramm() {
        int[] progSoft = this.fPOProgramm.getProgPart();
        int[] progComfort = new int[progSoft.length];
        for (int i = 0; i < progSoft.length; ++i) {
            progComfort[i] = this.getComfortOPCode(progSoft[i]);
        }
        return progComfort;
    }

    public int[][] getProgramm2() {
        int[][] progSoft = this.fPOProgramm.getProgPart2();
        int spalten = 0;
        if (progSoft.length != 0) {
            spalten = progSoft[0].length;
        }
        int[][] progComfort = new int[progSoft.length][spalten];
        for (int i = 0; i < progSoft.length; ++i) {
            for (int d = 0; d < progSoft[0].length; ++d) {
                progComfort[i][d] = this.getComfortOPCode(progSoft[i][d]);
            }
        }
        return progComfort;
    }

    public int[] getUsedAnchors() {
        int[] ankerSoft = this.fPOAnchor.getOpCodes();
        int[] ankerComfort = new int[ankerSoft.length];
        for (int i = 0; i < ankerSoft.length; ++i) {
            ankerComfort[i] = this.getComfortOPCode(ankerSoft[i]);
        }
        return ankerComfort;
    }

    public boolean isAnchor(int opcode) {
        if (opcode > 215 && opcode < 224) {
            return true;
        }
        return opcode > 235 && opcode < 239;
    }

    public boolean isAsi(int opcode) {
        if (opcode > 211 && opcode < 216) {
            return true;
        }
        return opcode >= 236 && opcode <= 239;
    }

    public boolean isInput(int opcode) {
        if (opcode > 191 && opcode < 204) {
            return true;
        }
        return opcode > 211 && opcode < 216;
    }

    public boolean isInputPosition(int zeile) {
        int hard = this.fPOL.getHardwareID();
        if (zeile > 1) {
            return true;
        }
        return hard == 0 && zeile == 1;
    }

    public boolean isIOPortCommentsAvailable() {
        return this.fPOL.isIOPortCommentsAvailable();
    }

    public boolean isMarker(int opcode) {
        return opcode >= 224 && opcode <= 227;
    }

    public boolean isOutput(int opcode) {
        if (opcode >= 216 && opcode <= 223) {
            return true;
        }
        return opcode >= 236 && opcode <= 239;
    }

    public boolean isPegel(int opcode) {
        return opcode == 253 || opcode == 254;
    }

    public boolean isVerweis(int opcode) {
        return opcode > 1064;
    }

    public int whichInnovation() {
        return this.fPOL.whichInnovation();
    }
}

