/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.InputNamesManager;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.lgoExImport.CAnker;
import DE.siemens.ad.logo.model.lgoExImport.CParameter;
import DE.siemens.ad.logo.model.lgoExImport.CProgramm;
import DE.siemens.ad.logo.model.lgoExImport.ConvertWiringDiagram;
import DE.siemens.ad.logo.model.lgoExImport.ResourceListener;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExportToSoft
implements ResourceListener {
    protected WiringDiagram fSourceWD = null;
    String fTargetFileName = "Noname.lgo";
    private static ExportToSoft fExport = null;
    private int[] fLogFile;
    private static LogoDrawing fDrawing = null;
    String fTargetPath = "";
    protected int fParaLine = -1;
    public static final int PROG_LINE_ELEMENTS = 6;
    public static final int PARA_LINE_ELEMENTS = 8;
    public static final int VERSION_NUMBER = 3029;
    public static final int HARDWARE_KENNUNG = 6;
    public static final int LAST_PARA_NUMBER = 168;
    public static final int FIRST_PARA_NUMBER = 121;
    public static final int ANZAHL_EINGANG = 16;
    public static final int ANZAHL_AUSGANG = 16;
    public static final int PROG_START_NUMBER = 65;
    private int fProgLine = -1;

    protected ExportToSoft(WiringDiagram wd) {
        this.fSourceWD = wd;
        this.fProgLine = 64;
        this.fParaLine = 120;
    }

    protected static void checkWD(WiringDiagram wd) throws ProgramException {
        int minHard;
        String s;
        boolean fehler = false;
        String f = s = Language.getString("error.export.failed", "Export failed");
        ProgramException pE = null;
        Hashtable errors = wd.getErrors();
        if (((Dictionary)errors).size() != 0) {
            fehler = true;
            pE = new ProgramException();
            Enumeration k = ((Dictionary)errors).keys();
            while (k.hasMoreElements()) {
                String key = (String)k.nextElement();
                pE.set(Language.getString(key, key), "logOutput");
                Vector list = (Vector)((Dictionary)errors).get(key);
                int size = list.size();
                if (size <= 0) continue;
                for (int i = 0; i < size; ++i) {
                    pE.set(((Block)list.get(i)).getLocalizedName(true), "logOutput");
                }
            }
            pE.set(f, "logOutput");
        }
        if ((minHard = wd.getSuitableHardware(new ArrayList())[0].getID()) == 0) {
            minHard = 1;
        }
        if (minHard > 7) {
            fehler = true;
            f = Language.getString("error.export.noSuitableHardware", "Hardware in LOGO!-Soft not available");
        }
        if (fehler) {
            if (pE == null) {
                pE = new ProgramException();
            }
            pE.setExpert("Value \t minHard=" + minHard);
            pE.setUser(f);
            throw pE;
        }
    }

    protected void createLgoData() {
        int position = 0;
        Log.println("msg.loadMessage", "...read Wiringdiagramm");
        ConvertWiringDiagram cWD = new ConvertWiringDiagram(this.fSourceWD);
        Log.println("log.convertData", "...convert Wiringdiagramm");
        CAnker anker = new CAnker(cWD);
        int[] ankerArray = anker.getCAnker();
        CProgramm prog = new CProgramm(cWD);
        int[] progArray = prog.getCProgramm();
        CParameter para = new CParameter(cWD);
        int[] paraArray = para.getCParameter();
        int kopf = 4;
        int marker = 4;
        int zusatz = 2;
        int laenge = kopf + this.getFirstAsiOutputIndex() + marker + zusatz + progArray.length + this.getParameterElements();
        this.fLogFile = new int[laenge];
        this.fLogFile[position] = 3029;
        this.fLogFile[++position] = 6;
        this.fLogFile[++position] = 16;
        this.fLogFile[++position] = 16;
        ++position;
        int i = 0;
        while (i < ankerArray.length) {
            this.fLogFile[position] = ankerArray[i];
            ++i;
            ++position;
        }
        this.fLogFile[position] = cWD.getLastBlockNumber() - 1 + 65;
        ++position;
        i = 0;
        while (i < progArray.length) {
            this.fLogFile[position] = progArray[i];
            ++i;
            ++position;
        }
        ExportToSoft.getReferences();
        this.fLogFile[position] = 168;
        ++position;
        i = 0;
        while (i < paraArray.length) {
            this.fLogFile[position] = paraArray[i];
            ++i;
            ++position;
        }
    }

    public static void createNewExport(WiringDiagram wd) throws ProgramException {
        if (fExport == null) {
            ExportToSoft.checkWD(wd);
            fExport = new ExportToSoft(wd);
        }
    }

    public static void createNewExport(LogoDrawing drawing) throws ProgramException {
        if (fExport == null) {
            fDrawing = drawing;
            WiringDiagram wd = drawing.getWiringDiagram().getFup();
            ExportToSoft.checkWD(wd);
            fExport = new ExportToSoft(wd);
        }
    }

    public static void delReferences() {
        fExport = null;
    }

    public synchronized int getAnkerElements() {
        return 16;
    }

    public synchronized int getFirstAsiOutputIndex() {
        return 12;
    }

    public synchronized int getFirstMarkerIndex() {
        return 8;
    }

    public synchronized int getFirstOutputIndex() {
        return 0;
    }

    public synchronized int getFreeParaNumber() {
        this.incParaLine();
        return this.fParaLine;
    }

    public synchronized int getFreeProgNumber() {
        this.incProgLine();
        return this.fProgLine;
    }

    public String[] getIOPortComments() {
        Vector<String> ioComments = new Vector<String>();
        if (fDrawing != null) {
            String value;
            int i;
            InputNamesManager iNM = fDrawing.getInputNamesManager();
            String[] keys = iNM.getInputNames();
            for (i = 0; i < keys.length; ++i) {
                value = iNM.getInputName(keys[i]);
                if (value == null) continue;
                ioComments.add(value);
            }
            keys = iNM.getOutputNames();
            for (i = 0; i < keys.length; ++i) {
                value = iNM.getInputName(keys[i]);
                if (value == null) continue;
                ioComments.add(value);
            }
        }
        Object[] retValue = new String[ioComments.size()];
        ioComments.copyInto(retValue);
        return retValue;
    }

    public int[] getLgoFile() {
        this.createLgoData();
        return this.fLogFile;
    }

    public String[] getMarkerComments() {
        try {
            int marker = 4;
            if (fDrawing != null) {
                String[] retValue = new String[4];
                WiringDiagram wd = fDrawing.getWiringDiagram().getFup();
                for (int i = 0; i < marker; ++i) {
                    Block block = wd.getBlock(224 + i, i + 1);
                    if (block != null) {
                        BlockFigure figure = fDrawing.getBlockFigure(block);
                        CommentParameter cP = figure.getCommentParameter();
                        if (cP != null) {
                            retValue[i] = this.getMarkerText(cP.getText());
                            continue;
                        }
                        retValue[i] = "";
                        continue;
                    }
                    retValue[i] = "";
                }
                return retValue;
            }
        }
        catch (Exception e) {
            Log.println("msg.export.noMarkerComments", "no Markercomments");
            String[] ret = new String[4];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = "";
            }
            return ret;
        }
        return null;
    }

    private String getMarkerText(String text) {
        int pos = text.indexOf("\n");
        if (pos == -1) {
            return text;
        }
        String retWert = text.substring(0, pos);
        return retWert;
    }

    public synchronized int getParameterElements() {
        return 384;
    }

    public synchronized int getProgLineLength() {
        return 6;
    }

    public synchronized int getProgrammElements() {
        return (this.fProgLine - 64) * 6;
    }

    public static ExportToSoft getReferences() {
        return fExport;
    }

    private final Vector getSourceBlocks() {
        return this.fSourceWD.getBlocks();
    }

    private void incParaLine() {
        ++this.fParaLine;
    }

    private void incProgLine() {
        ++this.fProgLine;
    }

    public void saveLgoFile(String fileName) throws ProgramException {
        this.createLgoData();
        BufferedWriter dataOutput = null;
        try {
            int i;
            dataOutput = new BufferedWriter(new FileWriter(fileName));
            for (int i2 = 0; i2 < this.fLogFile.length; ++i2) {
                dataOutput.write("" + this.fLogFile[i2]);
                dataOutput.newLine();
            }
            if (fDrawing != null) {
                String[] comments = this.getIOPortComments();
                for (i = 0; i < comments.length; ++i) {
                    if (comments[i] == null) continue;
                    dataOutput.write(comments[i]);
                    dataOutput.newLine();
                }
            }
            if (fDrawing != null) {
                String[] marker = this.getMarkerComments();
                for (i = 0; i < marker.length; ++i) {
                    dataOutput.write(marker[i]);
                    dataOutput.newLine();
                }
            }
            dataOutput.close();
        }
        catch (IOException e) {
            ProgramException pE = new ProgramException();
            pE.setUser(Language.getString("error.saveFile", "Error saving file: " + fileName, fileName));
            pE.setOriginalException(e);
            pE.setExpert(e.toString());
            throw pE;
        }
    }

    public void saveLgoFile(String fileName, String path) throws ProgramException {
        this.createLgoData();
        BufferedWriter dataOutput = null;
        this.fTargetPath = path;
        this.fTargetFileName = fileName;
        String file = path + "\\" + fileName;
        try {
            int i;
            dataOutput = new BufferedWriter(new FileWriter(file));
            for (int i2 = 0; i2 < this.fLogFile.length; ++i2) {
                dataOutput.write("" + this.fLogFile[i2]);
                dataOutput.newLine();
            }
            if (fDrawing != null) {
                String[] comments = this.getIOPortComments();
                for (i = 0; i < comments.length; ++i) {
                    dataOutput.write(comments[i]);
                    dataOutput.newLine();
                }
            }
            if (fDrawing != null) {
                String[] marker = this.getMarkerComments();
                for (i = 0; i < marker.length; ++i) {
                    dataOutput.write(marker[i]);
                    dataOutput.newLine();
                }
            }
            dataOutput.close();
        }
        catch (IOException e) {
            String s = Language.getString("error.import.wrongFileName", "FileName not Found");
            ProgramException pE = new ProgramException();
            pE.setOriginalException(e);
            pE.set(s, "u");
            throw pE;
        }
    }

    private void setFirstProgIndex() {
        this.fProgLine = 65;
    }
}

