/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.lgoExImport.CBlock;
import DE.siemens.ad.logo.model.lgoExImport.ConvertToLgo;
import DE.siemens.ad.logo.model.lgoExImport.ConvertWiringDiagram;
import DE.siemens.ad.logo.model.lgoExImport.ExportToSoft;

public class CProgramm
extends ConvertToLgo {
    private String fKennung = "Programm";
    private int fProgZeilen = 0;

    public CProgramm() {
    }

    public CProgramm(ConvertWiringDiagram cWD) {
        this.fCWD = cWD;
        this.fLgoArray = new int[ExportToSoft.getReferences().getProgrammElements()];
        this.fLgoArray = new int[this.fCWD.getLastBlockNumber() * 6];
    }

    protected void createLgoProgramm() {
        CBlock[] programBlocks = this.fCWD.getCBlocksForString(this.fKennung);
        boolean lgoArrayIndex = false;
        int zeilen = 0;
        this.fProgZeilen = zeilen = programBlocks.length;
        if (zeilen != 0) {
            int[][] progTeil2Dim = new int[this.fCWD.getLastBlockNumber()][this.getCompleteProgLine(programBlocks[0]).length];
            for (int i = 0; i < this.fProgZeilen; ++i) {
                int[] zwischenSpeicher = this.getCompleteProgLine(programBlocks[i]);
                progTeil2Dim[programBlocks[i].getBlockNumber() - 1] = zwischenSpeicher;
            }
            for (int d = 0; d < progTeil2Dim.length; ++d) {
                for (int i = 0; i < progTeil2Dim[0].length; ++i) {
                    this.fLgoArray[i + progTeil2Dim[0].length * d] = progTeil2Dim[d][i];
                }
            }
        }
    }

    private int[] getCompleteProgLine(CBlock sourceBlock) {
        int laenge = 6;
        int pos = 0;
        int[] back = new int[laenge];
        back[pos++] = sourceBlock.getSoftOPCode();
        BlockParameter pa = sourceBlock.getSourceBlock().getParameter();
        back[pos] = 0;
        back[pos] = sourceBlock.getRemanenceState();
        if (pa != null && pa.getRemanenceObject() != null) {
            boolean rem = pa.getRemanenceObject().getRemanence();
            back[pos] = rem ? 2 : 1;
        }
        ++pos;
        Block[] connectedBlocks = sourceBlock.getInConnectorBlocks();
        CBlock[] allBlocks = this.fCWD.getAllCBlocks();
        for (int i = 0; i < connectedBlocks.length; ++i) {
            if (connectedBlocks[i] != null) {
                for (int d = 0; d < allBlocks.length; ++d) {
                    if (!allBlocks[d].isCreatedWith(connectedBlocks[i])) continue;
                    back[pos++] = allBlocks[d].getProgLineNumber();
                }
                continue;
            }
            back[pos++] = 1;
        }
        int[] paraVerweise = sourceBlock.getParaLineNumber();
        if (paraVerweise != null) {
            for (int i = 0; i < paraVerweise.length; ++i) {
                if (paraVerweise[i] < 121) continue;
                back[pos++] = paraVerweise[i];
            }
        }
        return back;
    }

    public int[] getCProgramm() {
        this.createLgoProgramm();
        return this.fLgoArray;
    }

    public int[][] getCProgramm2() {
        this.createLgoProgramm();
        int[][] back = new int[this.fProgZeilen][6];
        for (int zeilen = 0; zeilen < this.fProgZeilen; ++zeilen) {
            for (int spalten = 0; spalten < 6; ++spalten) {
                back[zeilen][spalten] = this.fLgoArray[zeilen * 6 + spalten];
            }
        }
        return back;
    }

    public String getFilePartType() {
        return this.fKennung;
    }

    public String toString() {
        int[][] prog = this.getCProgramm2();
        String back = this.fKennung + "in 0x";
        for (int i = 0; i < prog.length; ++i) {
            back = back + "\n";
            for (int d = 0; d < prog[0].length; ++d) {
                back = back + "\t" + Integer.toHexString(prog[i][d]);
            }
        }
        return back;
    }
}

