/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.lgoExImport.CSpecialFunctions;

public class CCounterBlock
extends CSpecialFunctions {
    public CCounterBlock() {
    }

    public CCounterBlock(CounterBlock uebergabeBlock) {
        super(uebergabeBlock);
    }

    public CCounterBlock(Block uebergabeBlock) {
        super(uebergabeBlock);
    }

    public boolean canCreateCBlock(Block block) {
        if (block instanceof CounterBlock) {
            this.fNewBlock = block;
            return true;
        }
        return false;
    }

    public boolean canCreateParameters(Block block) {
        if (block instanceof CounterBlock) {
            this.fNewBlock = block;
            return true;
        }
        return false;
    }

    public int getComfortOPCode(Hardware hw, int blocknummer) {
        if (hw.supports("longCounter")) {
            return 43;
        }
        return 40;
    }

    public int[] getParameters() {
        CounterParameter countPara = (CounterParameter)this.fNewBlock.getParameter();
        this.fParaDataArray[0] = 0;
        int zaehlerStand = countPara.getLim().getCurrentValue();
        this.fParaDataArray[2] = zaehlerStand % 100;
        this.fParaDataArray[1] = zaehlerStand / 100 % 100;
        this.fParaDataArray[4] = zaehlerStand / 10000;
        CounterParameter pP = countPara;
        boolean[] state = new boolean[]{true, false};
        boolean protection = pP.getProtection();
        this.fParaDataArray[3] = protection ? 0 : 1;
        this.fParaDataArray[5] = 1;
        if (countPara.getRemanenceAvailable()) {
            this.fParaDataArray[5] = 1;
            if (countPara.getRemanenceObject().getRemanence()) {
                this.fParaDataArray[5] = 2;
            }
        }
        return this.fParaDataArray;
    }

    public int[][] getParameters2() {
        int[][] back = new int[1][this.fParaDataArray.length];
        CounterParameter countPara = (CounterParameter)this.fNewBlock.getParameter();
        back[0][0] = 0;
        int zaehlerStand = countPara.getLim().getCurrentValue();
        back[0][2] = zaehlerStand % 100;
        back[0][1] = zaehlerStand / 100 % 100;
        back[0][4] = zaehlerStand / 10000;
        CounterParameter pP = countPara;
        boolean[] state = new boolean[]{true, false};
        boolean protection = pP.getProtection();
        back[0][3] = protection ? 0 : 1;
        back[0][5] = 1;
        if (countPara.getRemanenceAvailable()) {
            back[0][5] = 1;
            if (countPara.getRemanenceObject().getRemanence()) {
                back[0][5] = 2;
            }
        }
        return back;
    }

    public int getRemanenceState() {
        Hardware hardware = this.getSourceBlock().getWiringDiagram().getHardware();
        if (hardware.getName().equals("Basic0")) {
            return 1;
        }
        return 0;
    }

    public int getSoftOPCode() {
        return 37;
    }

    public void setParameters(int startIndex, int[][] parameterArray) {
        int[] paraZeile = parameterArray[startIndex];
        if (paraZeile[0] == 0) {
            int valueMiddle = paraZeile[1];
            int valueLow = paraZeile[2];
            int protection = paraZeile[3];
            int valueHigh = paraZeile[4];
            int rem = paraZeile[5];
            CounterParameter countPara = (CounterParameter)this.fNewBlock.getParameter();
            if (countPara.isLongCounter()) {
                countPara.setLim(valueHigh * 10000 + valueMiddle * 100 + valueLow);
            } else {
                countPara.setLim(valueMiddle * 100 + valueLow);
            }
            CounterParameter pP = countPara;
            boolean[] stateBool = new boolean[]{true, false};
            pP.setProtection(stateBool[protection]);
            if (rem != 0) {
                if (rem == 1) {
                    countPara.setRemanenceAvailable(true);
                    countPara.getRemanenceObject().setRemanence(false);
                }
                if (rem == 2) {
                    countPara.setRemanenceAvailable(true);
                    countPara.getRemanenceObject().setRemanence(true);
                }
            }
        }
    }
}

