/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.lgoExImport.CAsiOutputBlock;
import DE.siemens.ad.logo.model.lgoExImport.CBlock;
import DE.siemens.ad.logo.model.lgoExImport.CMarkerBlock;
import DE.siemens.ad.logo.model.lgoExImport.COutputBlock;
import DE.siemens.ad.logo.model.lgoExImport.ConvertToLgo;
import DE.siemens.ad.logo.model.lgoExImport.ConvertWiringDiagram;
import DE.siemens.ad.logo.model.lgoExImport.ExportToSoft;

public class CAnker
extends ConvertToLgo {
    private String fKennung = "Anker";

    public CAnker() {
    }

    public CAnker(ConvertWiringDiagram cWD) {
        this.fCWD = cWD;
        this.fLgoArray = new int[ExportToSoft.getReferences().getAnkerElements()];
    }

    protected void createLgoAnker() {
        int start;
        int i;
        CBlock[] ankerBlocks = this.fCWD.getCBlocksForString(this.fKennung);
        int bereich = 0;
        int[] startIndex = new int[]{ExportToSoft.getReferences().getFirstOutputIndex(), ExportToSoft.getReferences().getFirstAsiOutputIndex(), ExportToSoft.getReferences().getFirstMarkerIndex()};
        bereich = 0;
        for (i = 0; i < ankerBlocks.length; ++i) {
            if (!(ankerBlocks[i] instanceof COutputBlock)) continue;
            start = ankerBlocks[i].getNumber();
            this.fLgoArray[start + startIndex[bereich] - 1] = this.getValueOfInConnector(ankerBlocks[i]);
        }
        bereich = 1;
        for (i = 0; i < ankerBlocks.length; ++i) {
            if (!(ankerBlocks[i] instanceof CAsiOutputBlock)) continue;
            start = ankerBlocks[i].getNumber();
            this.fLgoArray[start + startIndex[bereich] - 1] = this.getValueOfInConnector(ankerBlocks[i]);
        }
        bereich = 2;
        for (i = 0; i < ankerBlocks.length; ++i) {
            if (!(ankerBlocks[i] instanceof CMarkerBlock)) continue;
            start = ankerBlocks[i].getNumber();
            this.fLgoArray[start + startIndex[bereich] - 1] = this.getValueOfInConnector(ankerBlocks[i]);
        }
    }

    public int[] getCAnker() {
        this.createLgoAnker();
        return this.fLgoArray;
    }

    public String getFilePartType() {
        return this.fKennung;
    }

    private int getValueOfInConnector(CBlock cBlock) {
        int value = -1;
        CBlock[] allBlocks = this.fCWD.getAllCBlocks();
        Block[] inConnBlocks = cBlock.getInConnectorBlocks();
        Block inConnBlock = inConnBlocks[0];
        if (inConnBlock == null) {
            return 1;
        }
        for (int d = 0; d < allBlocks.length; ++d) {
            if (!allBlocks[d].isCreatedWith(inConnBlock)) continue;
            value = allBlocks[d].getProgLineNumber();
        }
        return value;
    }

    public String toString() {
        int[] prog = this.getCAnker();
        String back = this.fKennung + "in 0x";
        back = back + "\n";
        for (int d = 0; d < prog.length; ++d) {
            back = back + "\t" + Integer.toHexString(prog[d]) + "\n";
        }
        return back;
    }
}

