/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.hardware;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.dialog.comp.GetPasswordPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Logo2;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItemTableLogo3;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo3;
import DE.siemens.ad.logo.model.visitor.build.CompilerToHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo3;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo3;
import DE.siemens.ad.logo.util.AnchorMemory8;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.MessageMemory8;
import DE.siemens.ad.logo.util.ParameterMemory8;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgramMemory8;
import java.io.ByteArrayOutputStream;
import java.util.Dictionary;
import java.util.Hashtable;

public class Modular0
extends Logo2 {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected static int ADR_COMMUNICATION_BUFFER = 12288;
    protected static int ADR_READ_FUNCTION_PARAM = 12289;
    protected static final int ADR_READ_SWT_PARAM = 12290;
    protected static final int ADR_READ_SWT_SETTING = 12291;
    protected static final int ADR_WRITE_SWT_PARAM = 12292;
    protected static final int ADR_WRITE_SWT_SETTING = 12293;
    protected static int ADR_PASSWORD = 12294;
    protected static int ADR_PASSWORD_FLAG = 12296;
    protected static int ADR_SET_PASSWORD_ACTIVE = 12297;
    protected static int ADR_CLEAR_PASSWORD_ACTIVE = 12298;

    public int calculateBlockNumber(int opcode) throws IllegalArgumentException {
        if (opcode < 216) {
            return opcode - 192 + 1;
        }
        if (opcode < 224) {
            return opcode - 216 + 1;
        }
        if (opcode < 232) {
            return opcode - 224 + 1;
        }
        if (opcode < 240) {
            return opcode - 232 + 9;
        }
        if (opcode < 248) {
            return opcode - 240 + 1;
        }
        if (opcode < 252) {
            throw new IllegalArgumentException();
        }
        if (opcode < 255) {
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public void clearPasswordOnLogo(DataTransfer dt) throws TransmissionFailedException {
        dt.writeByte(this.getAdress(ADR_CLEAR_PASSWORD_ACTIVE), 0);
    }

    protected int getAdress(int name) {
        if (name == ADR_COMMUNICATION_BUFFER) {
            return 64256;
        }
        if (name == ADR_READ_FUNCTION_PARAM) {
            return 17411;
        }
        if (name == 12290) {
            return 17409;
        }
        if (name == 12291) {
            return 17410;
        }
        if (name == 12292) {
            return 17153;
        }
        if (name == 12293) {
            return 17154;
        }
        if (name == ADR_PASSWORD) {
            return 1;
        }
        if (name == ADR_PASSWORD_FLAG) {
            return 18687;
        }
        if (name == ADR_SET_PASSWORD_ACTIVE) {
            return 18433;
        }
        if (name == ADR_CLEAR_PASSWORD_ACTIVE) {
            return 18432;
        }
        return super.getAdress(name);
    }

    public void setPasswordOnLogo(DataTransfer dt) throws TransmissionFailedException {
        dt.writeByte(this.getAdress(ADR_SET_PASSWORD_ACTIVE), 0);
    }

    public void downloadPassword(DataTransfer dt) throws TransmissionFailedException {
        int i;
        String password = this.fDownloadedWiringDiagram.getDrawingProperties().getPassword();
        byte[] byteArr = password.getBytes();
        int[] arr = new int[10];
        for (i = 0; i < byteArr.length; ++i) {
            arr[i] = byteArr[i];
        }
        for (i = byteArr.length; i < 10; ++i) {
            arr[i] = 0;
        }
        dt.writeByteArray(this.getAdress(ADR_PASSWORD), arr);
    }

    public void downloadSummerWintertime(DataTransfer dt, int[] param) throws UnsupportedOperationException, TransmissionFailedException {
        dt.setBlockMode(false);
        dt.writeByteArray(this.getAdress(ADR_COMMUNICATION_BUFFER), param);
        dt.setBlockMode(true);
        dt.writeByte(this.getAdress(12292), 0);
    }

    public void downloadSummerWintertime(DataTransfer dt, int setting, int[] param) throws UnsupportedOperationException, TransmissionFailedException {
        dt.writeByte(this.getAdress(12293), setting);
        if (param != null) {
            dt.setBlockMode(false);
            dt.writeByteArray(this.getAdress(ADR_COMMUNICATION_BUFFER), param);
            dt.setBlockMode(true);
            dt.writeByte(this.getAdress(12292), 0);
        }
    }

    public CompilerFromHardware getCompilerFromHardware() {
        return new CompilerFromLogo3();
    }

    public CompilerToHardware getCompilerToHardware() {
        return new CompilerToLogo3();
    }

    public LinkerToLogo getLinkerToHardware() {
        return new LinkerToLogo3(this);
    }

    public int getFirmwareID() {
        return 21199;
    }

    public int getID() {
        return 32;
    }

    public Memory[] getMemories() {
        if (this.fMemories == null) {
            this.fMemories = new Memory[7];
            this.fMemories[0] = new ProgramMemory8(64312, this.getMaxResource(0));
            this.fMemories[1] = new ParameterMemory8(64592, this.getMaxResource(3));
            this.fMemories[2] = new AnchorMemory8(64272, 2, 216);
            this.fMemories[3] = new AnchorMemory8("Anker Q9...Qi", 64292, 2, 232);
            this.fMemories[4] = new AnchorMemory8("Merker", 64282, 2, 224);
            this.fMemories[5] = new AnchorMemory8("Reserviert", 64302, 2, 240);
            this.fMemories[6] = new MessageMemory8(256, 20);
        }
        return this.fMemories;
    }

    protected int getOpcodeCO(String name, int blockNr) throws IllegalArgumentException {
        --blockNr;
        if (name.equals("Input")) {
            return 192 + blockNr;
        }
        if (name.equals("AnalogInput")) {
            return 240 + blockNr;
        }
        if (name.equals("AsiInput")) {
            return 212 + blockNr;
        }
        if (name.equals("Output")) {
            if (blockNr < 8) {
                return 216 + blockNr;
            }
            return 232 + blockNr - 8;
        }
        if (name.equals("Marker")) {
            return 224 + blockNr;
        }
        if (name.equals("AsiOutput")) {
            return 232 + blockNr;
        }
        if (name.equals("High")) {
            return 253;
        }
        if (name.equals("Low")) {
            return 254;
        }
        throw new IllegalArgumentException();
    }

    public int getOrder() {
        return 1000;
    }

    public Block getSubstitutionBlock(Block orgBlock) throws IllegalArgumentException {
        if (orgBlock.getName().equals("AsiInput")) {
            InputBlock newBlock = new InputBlock();
            newBlock.setNumber(orgBlock.getNumber() + 12);
            return newBlock;
        }
        if (orgBlock.getName().equals("AsiOutput")) {
            OutputBlock newBlock = new OutputBlock();
            newBlock.setNumber(orgBlock.getNumber() + 8);
            return newBlock;
        }
        return orgBlock;
    }

    protected static Dictionary getSystemInfo() {
        Hashtable<String, Object> dict = new Hashtable<String, Object>(20);
        String[][] sArr = new String[][]{{"Constant", "Input", "Output", "Marker", "High", "Low", "AnalogInput"}, {"Base", "And", "Or", "Not", "Xor", "Nand", "Nor", "PecAnd", "PecNand"}, {"Special", "OnDelay", "OffDelay", "PulseRelay", "Clock", "LatchingRelay", "SymPulseGenerator", "RetentiveOnDelay", "Counter", "HoursCounter", "WipingRelay", "Trigger", "AsymPulseGenerator", "YearClock", "OnOffDelay", "Random", "StairsSwitch", "ComfortSwitch", "WipingRelayPEC", "Message", "AnalogTrigger", "AnalogComparator", "Softkey"}};
        dict.put("knownBlocks", sArr);
        int[] iArr = new int[]{56, 27, 15, 48, 16, 58, 24, 16, 0, 0, 8, 8, 5};
        dict.put("maxValues", iArr);
        TimeUnit[] availableTimeUnits = new TimeUnit[]{new Hours(), new Minutes(), new Seconds()};
        dict.put("availableTimeUnits", availableTimeUnits);
        dict.put("longCounter", Boolean.TRUE);
        dict.put("blockmode", Boolean.TRUE);
        dict.put("asymPulseWithDifferentTimeUnits", Boolean.TRUE);
        dict.put("anyDayClock", Boolean.TRUE);
        dict.put("readFunctionParameter", Boolean.TRUE);
        dict.put("messageBlockWithReceipt", Boolean.TRUE);
        dict.put("parameterItemTable", new ParameterItemTableLogo3());
        dict.put("displayWidth", new Integer(10));
        dict.put("msgPrioCount", new Integer(10));
        dict.put("prgName", Boolean.TRUE);
        dict.put("password", Boolean.TRUE);
        return dict;
    }

    public void prepareUpload(DataTransfer dt) throws ProgramException, ExceptionAlreadyHandledException {
        super.prepareUpload(dt);
        this.checkPassword(dt);
    }

    public Hardware prepareDownload(DataTransfer dt, WiringDiagram wd) throws ProgramException, ExceptionAlreadyHandledException {
        Hardware result = super.prepareDownload(dt, wd);
        this.checkPassword(dt);
        return result;
    }

    private void checkPassword(DataTransfer dt) throws ProgramException, ExceptionAlreadyHandledException {
        int locked = 255;
        boolean tryAgain = false;
        do {
            tryAgain = false;
            try {
                locked = dt.readByte(this.getAdress(ADR_PASSWORD_FLAG));
                if (locked <= 0) continue;
                String s = this.uploadPassword(dt);
                GetPasswordPanel pwPanel = new GetPasswordPanel();
                SplittedDlg dlg = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), pwPanel, 11);
                dlg.show();
                if (dlg.getControlPanel().getResult() == 2) {
                    ProgramException e = new ProgramException().setLog(Language.getString("error.wrongPassword", "Upload denied. Wrong Password"));
                    e.setDialog(false);
                    throw e;
                }
                if (!pwPanel.getPassword().equals(s)) {
                    throw new ProgramException(Language.getString("error.wrongPassword", "Upload denied. Wrong Password"));
                }
                this.downloadTransferScreenOn(dt);
                this.clearPasswordOnLogo(dt);
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
    }

    public String uploadFunctionParameter(DataTransfer dt, int prgLine, int opcode, int parameterNr) throws UnsupportedOperationException, TransmissionFailedException {
        int[] arr = this.uploadFunctionParameter1(dt, prgLine, opcode, parameterNr, 6);
        int length = 0;
        while (arr[length] != 0) {
            ++length;
        }
        byte[] bArr = new byte[length];
        for (int i = 0; i < length; ++i) {
            bArr[i] = (byte)arr[i];
        }
        return new String(bArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] uploadFunctionParameter1(DataTransfer dt, int prgLine, int opcode, int parameterNr, int paramLen) throws UnsupportedOperationException, TransmissionFailedException {
        int[] arr = new int[]{prgLine, opcode, parameterNr};
        try {
            dt.setBlockMode(false);
            dt.writeByteArray(this.getAdress(ADR_COMMUNICATION_BUFFER), arr);
            dt.writeByte(this.getAdress(ADR_READ_FUNCTION_PARAM), 0);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            arr = dt.readByteArray(this.getAdress(ADR_COMMUNICATION_BUFFER), paramLen);
        }
        finally {
            dt.setBlockMode(true);
        }
        return arr;
    }

    protected String uploadPassword(DataTransfer dt) throws TransmissionFailedException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16);
        int[] intArray = dt.readByteArray(this.getAdress(ADR_PASSWORD), 10);
        for (int i = 0; i < intArray.length && intArray[i] != 0; ++i) {
            buffer.write(intArray[i]);
        }
        String password = buffer.toString();
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] uploadSummerWintertime(DataTransfer dt) throws UnsupportedOperationException, TransmissionFailedException {
        int[] values;
        try {
            dt.setBlockMode(false);
            dt.writeByte(this.getAdress(12290), 0);
            values = dt.readByteArray(this.getAdress(ADR_COMMUNICATION_BUFFER), 6);
        }
        finally {
            dt.setBlockMode(true);
        }
        return values;
    }

    static {
        cSystemInfoDict.put("Modular0", Modular0.getSystemInfo());
    }
}

