/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.IOParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutputParameter;
import DE.siemens.ad.logo.model.WiringDiagram;

public class OutputBlock
extends ConstantBlock {
    static final long serialVersionUID = 6018934117547604998L;
    private int outputBlockSerializedDataVersion = 1;
    protected transient boolean fValue;
    protected IOParameter fOutputParameter = null;
    public static final int FIRST_OPCODE = 216;
    public static final int LAST_OPCODE = 223;
    protected transient boolean fProcessImageValue;

    public OutputBlock() {
    }

    public OutputBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public boolean calculateBinaryValue() {
        return this.fProcessImageValue;
    }

    public void endCalculation() {
        this.fProcessImageValue = this.fValue = ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
    }

    public boolean getBinaryValue() {
        return this.fValue;
    }

    protected int getDefaultOrder() {
        return 10300;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = new int[HardwareFactory.getInstance().getResourceNames().length];
        result[this.getNumberType()] = 1;
        return result;
    }

    public String getNumberPrefix() {
        return "Q";
    }

    public int getNumberType() {
        return 7;
    }

    public BlockParameter getParameter() {
        if (this.fOutputParameter == null) {
            this.fOutputParameter = new OutputParameter(this);
        }
        return this.fOutputParameter;
    }

    public int getResourceIndex() {
        return 7;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "1");
    }

    public boolean isLeftTerminal() {
        return false;
    }

    public void reset() {
        this.fValue = false;
        this.fProcessImageValue = false;
    }

    public void setBinaryValue(boolean binaryValue) {
        this.fValue = binaryValue;
        this.fProcessImageValue = binaryValue;
    }

    public void setAnalogValue(double analogValue) {
        throw new UnsupportedOperationException("setAnalogValue not defined in " + this.getClassName());
    }
}

