/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.PseudoParameter;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.MessageLine;
import java.util.ArrayList;

public class MessageBlock
extends SpecialBlock {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;

    public MessageBlock() {
    }

    public MessageBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public Block deepCopy() {
        Block clonedBlock = super.deepCopy();
        MessageParameter srcParam = (MessageParameter)this.getParameter();
        MessageParameter cloneParam = (MessageParameter)clonedBlock.getParameter();
        if (srcParam.isRTF()) {
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText srcText = srcParam.getMessageRTF(j);
                if (srcText == null) continue;
                cloneParam.getMessageRTFs()[j] = new MessageParameter.MessageText();
                cloneParam.getMessageRTF(j).copyFrom(srcText, cloneParam);
            }
            cloneParam.setMessage(null);
        } else {
            int i;
            MessageLine[] srcLines = srcParam.getMessage();
            MessageLine[] cloneLines = cloneParam.getMessage();
            for (i = 0; i < cloneLines.length; ++i) {
                cloneLines[i].copyFrom(srcLines[i], false);
            }
            for (i = 0; i < cloneParam.getMessageRTFs().length; ++i) {
                cloneParam.getMessageRTFs()[i] = null;
            }
        }
        return clonedBlock;
    }

    protected boolean calculateBinaryValue() {
        return this.getParameter().getValue(((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue());
    }

    protected int getDefaultOrder() {
        return 2100;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = super.getMemoryResources(hardware);
        result[12] = 1;
        return result;
    }

    public int getResourceIndex() {
        return 12;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[3];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "En");
        MessageParameter paraObj = new MessageParameter(this);
        this.fInConnectors[1] = new ParameterInBlockConnector((Block)this, paraObj, "P");
        this.fInConnectors[2] = new ParameterInBlockConnector((Block)this, new PseudoParameter(this), "Par");
    }

    public boolean postDelete(WiringDiagram wd) {
        MessageParameter messageParameter = (MessageParameter)this.getParameter();
        MessageLine[] messageLines = messageParameter.getMessage();
        for (int i = 0; i < messageLines.length; ++i) {
            messageLines[i].removeAsParameterListener();
        }
        return true;
    }

    public void setWiringDiagram(WiringDiagram wd) {
        super.setWiringDiagram(wd);
        MessageParameter msgParam = (MessageParameter)this.getParameter();
        if (wd != null && wd.getMessageManager().isRTFMessage() && !msgParam.isRTF() && !msgParam.enableTextRTF(wd.getMessageGlobalInfo().getCurCharSetID())) {
            System.out.println("error in reset message");
        }
    }

    public String preInsert(WiringDiagram wd) {
        super.preInsert(wd);
        MessageParameter msgParam = (MessageParameter)this.getParameter();
        MessageManager msgManager = wd.getMessageManager();
        if (wd.getHardware().supports("NeedMessageNumber")) {
            Integer oldNumber = msgParam.getMsgNumber();
            if (!msgManager.isMsgNumberValid(oldNumber)) {
                int newNumber = msgManager.getFreeMessageNumber();
                msgParam.setMsgNumber(newNumber);
                if (newNumber == -1) {
                    System.err.println(this.getLocalizedName(true) + ": Can not find valid MessageNumber");
                }
            }
        } else {
            msgParam.setMsgNumber(-1);
        }
        Integer oldPrio = msgParam.getPriority();
        if (msgManager.isPriorityUsed(oldPrio)) {
            msgParam.setPriority(msgManager.getFreePriority());
            return this.getLocalizedName(true) + ": " + Language.getString("dialog.parameter.message.priority", "Priotity:") + oldPrio + " --> " + msgParam.getPriority() + " | " + Language.getString("msg.textDeleted", "Text deleted");
        }
        if (!msgParam.isRTF() && this.isEmpty(msgParam)) {
            return this.getLocalizedName(true) + ": " + Language.getString("msg.textDeleted", "Text deleted");
        }
        return null;
    }

    private boolean isEmpty(MessageParameter msgParam) {
        MessageLine[] messageLines = msgParam.getMessage();
        boolean empty = true;
        for (int i = 0; i < messageLines.length; ++i) {
            empty &= messageLines[i].isEmpty();
            messageLines[i].addAsParameterListener();
        }
        return empty;
    }

    public void hardwareChangeFinished(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChangeFinished(hardwareChangedEvent);
        ((MessageParameter)this.getParameter()).hardwareChangeFinished(hardwareChangedEvent);
    }

    public boolean isResourceAvailable(WiringDiagram wd) {
        boolean result = super.isResourceAvailable(wd);
        if (wd.getMessageManager().isRTFMessage() && wd.getMessageManager().getFreeMessageTextID() == -1) {
            result = false;
        }
        return result;
    }

    public boolean isResourceAvailable(WiringDiagram wd, ArrayList errorList) {
        boolean result = super.isResourceAvailable(wd, errorList);
        if (wd.getMessageManager().isRTFMessage() && wd.getMessageManager().getFreeMessageTextID() == -1) {
            result = false;
            String s = Language.getString("hardware.MessageText", "Resource");
            s = Language.getString("error.notAvailable", "% not available", s);
            errorList.add(new ErrorInfo(this, s, wd.getHardware()));
        }
        return result;
    }
}

