/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.HardwareChangedListener;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.LatchingRelayParameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.RamRemSpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import java.io.IOException;

public class LatchingRelayBlock
extends RamRemSpecialBlock
implements HardwareChangedListener {
    static final long serialVersionUID = 4850175885661162429L;
    private int latchingRelayBlockSerializedDataVersion = 1;
    protected LatchingRelayParameter fParameter;
    protected InBlockConnector[] fAlternativeInConnectors;

    public LatchingRelayBlock() {
    }

    public LatchingRelayBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected boolean calculateBinaryValue() {
        boolean input = ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
        boolean input1 = ((BinaryInBlockConnector)this.fInConnectors[1]).calculateBinaryValue();
        return this.fParameter.getValue(input, input1);
    }

    protected int getDefaultOrder() {
        return 500;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = super.getMemoryResources(hardware);
        BlockParameter param = this.getParameter();
        if (param == null) {
            result[1] = 1;
        }
        return result;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        int oldConnectorCount = this.getInConnectorCount();
        this.setCorrectInConnectors();
        if (oldConnectorCount != this.getInConnectorCount()) {
            this.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "inConnector"));
        }
        this.setHardware((Hardware)hardwareChangedEvent.getNewValue());
    }

    protected void initInConnectors() {
        this.fAlternativeInConnectors = new InBlockConnector[2];
        this.fAlternativeInConnectors[0] = new BinaryInBlockConnector(this, false, "S");
        this.fAlternativeInConnectors[1] = new BinaryInBlockConnector(this, false, "R");
        String name = "DE.siemens.ad.logo.model.LatchingRelayParameter";
        ParameterInBlockConnector parameterConnector = new ParameterInBlockConnector((Block)this, name, "Par");
        this.fParameter = (LatchingRelayParameter)parameterConnector.getLinkedParameter();
        this.fParameter.setRemanenceAvailable(true);
        this.fInConnectors = new InBlockConnector[3];
        this.fInConnectors[0] = this.fAlternativeInConnectors[0];
        this.fInConnectors[1] = this.fAlternativeInConnectors[1];
        this.fInConnectors[2] = parameterConnector;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fParameter = (LatchingRelayParameter)dr.readStorable();
        int count = dr.readInt();
        if (count > 0) {
            this.fAlternativeInConnectors = new InBlockConnector[count];
            for (int i = 0; i < count; ++i) {
                this.fAlternativeInConnectors[i] = (InBlockConnector)dr.readStorable();
            }
        }
    }

    protected void setCorrectInConnectors() {
        boolean rem = false;
        if (this.fWiringDiagram != null) {
            boolean bl = rem = this.fWiringDiagram.getHardware().getMaxResource(2) > 0;
        }
        if (rem) {
            if (this.fInConnectors.length == 3) {
                return;
            }
            InBlockConnector[] tempInConnectors = this.fInConnectors;
            this.fInConnectors = this.fAlternativeInConnectors;
            this.fAlternativeInConnectors = tempInConnectors;
            this.fParameter.setRemanenceAvailable(true);
        } else {
            if (this.fInConnectors.length == 2) {
                return;
            }
            InBlockConnector[] tempInConnectors = this.fInConnectors;
            this.fInConnectors = this.fAlternativeInConnectors;
            this.fAlternativeInConnectors = tempInConnectors;
            this.fParameter.setRemanenceAvailable(false);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fParameter);
        if (this.fAlternativeInConnectors != null) {
            dw.writeInt(this.fAlternativeInConnectors.length);
            for (int i = 0; i < this.fAlternativeInConnectors.length; ++i) {
                dw.writeStorable(this.fAlternativeInConnectors[i]);
            }
        } else {
            dw.writeInt(0);
        }
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fParameter.init(interpreter, forceReset);
    }

    public boolean compareTo(Block otherBlock, DifferenceTableModel differences) {
        boolean equal = super.compareTo(otherBlock, differences);
        if (this.fParameter != null) {
            equal = equal && this.fParameter.compareTo(otherBlock.getParameter(), differences);
        }
        return equal;
    }
}

