/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.HardwareChangedListener;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.RamRemSpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;

public class CounterBlock
extends RamRemSpecialBlock
implements HardwareChangedListener {
    static final long serialVersionUID = 9028788599903627015L;
    private int counterBlockSerializedDataVersion = 1;

    public CounterBlock() {
    }

    public CounterBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
        if (wiringDiagram != null) {
            this.setWiringDiagram(wiringDiagram);
        }
    }

    public boolean canCreateInstance(int opcode, int blockNumber) {
        return opcode == 43 || opcode == 40;
    }

    protected boolean calculateBinaryValue() {
        boolean input = ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
        boolean input1 = ((BinaryInBlockConnector)this.fInConnectors[1]).calculateBinaryValue();
        boolean input2 = ((BinaryInBlockConnector)this.fInConnectors[2]).calculateBinaryValue();
        boolean result = ((CounterParameter)this.getParameter()).getValue(input, input1, input2);
        return result;
    }

    protected int getDefaultOrder() {
        return 1100;
    }

    public final void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        boolean hwCounter;
        boolean propertyChanged = false;
        CounterParameter param = (CounterParameter)this.getParameter();
        boolean paramCounter = param.isLongCounter();
        if (paramCounter != (hwCounter = this.fWiringDiagram.getHardware().supports("longCounter"))) {
            param.setLongCounter(hwCounter);
            propertyChanged = true;
        }
        super.hardwareChanged(hardwareChangedEvent);
        if (propertyChanged) {
            this.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "param;"));
        }
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[4];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "R");
        this.fInConnectors[1] = new BinaryInBlockConnector(this, false, "Cnt");
        this.fInConnectors[2] = new BinaryInBlockConnector(this, false, "Dir");
        String name = "DE.siemens.ad.logo.model.CounterParameter";
        this.fInConnectors[3] = new ParameterInBlockConnector((Block)this, name, "Par");
    }
}

