/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.util.BlockEnumeration;
import java.util.List;

public class AnalogMarkerBlock
extends MarkerBlock
implements AnalogBlock {
    private static final long serialVersionUID = -4945247434703766087L;
    private transient double fAnalogValue;
    private transient double fAnalogProcessImageValue;

    public AnalogMarkerBlock() {
    }

    public AnalogMarkerBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public double calculateAnalogValue() {
        this.fAnalogValue = this.fInConnectors[0].calculateAnalogValue();
        return this.fAnalogProcessImageValue;
    }

    public String getNumberPrefix() {
        return "AM";
    }

    public int getNumberType() {
        return 16;
    }

    public int getResourceIndex() {
        return 16;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        this.fInConnectors[0] = new AnalogInBlockConnector(this, 0.0, "1");
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
        this.fOutConnectors[0] = new AnalogOutBlockConnector(this);
    }

    public void setBinaryValue(boolean binaryValue) {
        throw new IllegalArgumentException("setBinaryValue darf bei Analogausg\u00e4ngen nicht gerufen werden!");
    }

    public void collectSensors(List sensorContainer) {
        BlockEnumeration nextAnalogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (nextAnalogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)nextAnalogBlocks.nextBlock());
            analogBlock.collectSensors(sensorContainer);
        }
    }

    public void addMeasurementBoundsChangedListener(ParameterSetListener listener) {
        BlockEnumeration analogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (analogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)analogBlocks.nextBlock());
            analogBlock.addMeasurementBoundsChangedListener(listener);
        }
    }

    public void removeMeasurementBoundsChangedListener(ParameterSetListener listener) {
        BlockEnumeration analogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (analogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)analogBlocks.nextBlock());
            analogBlock.removeMeasurementBoundsChangedListener(listener);
        }
    }

    public void endCalculation() {
        this.fAnalogProcessImageValue = this.fAnalogValue;
    }

    public double getAnalogValue() {
        return this.fAnalogValue;
    }

    public void setAnalogValue(double analogValue) {
        this.fAnalogValue = analogValue;
    }

    public void reset() {
        this.fAnalogValue = 0.0;
        this.fAnalogProcessImageValue = 0.0;
    }
}

