/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.BlockSubstituteListener;
import DE.siemens.ad.logo.model.ComparatorWiringDiagram;
import DE.siemens.ad.logo.model.DrawingHistoryEntry;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.FupProgrammingLanguage;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.HardwareChangedListener;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterItemTable;
import DE.siemens.ad.logo.model.ProgrammingLanguage;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.VirtualOutputBlock;
import DE.siemens.ad.logo.model.hardware.Unknown;
import DE.siemens.ad.logo.util.BlockEnumerator;
import DE.siemens.ad.logo.util.BlockEnumeratorFullPath;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import DE.siemens.ad.pdraw.standard.UsedResourcesChangedListener;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class WiringDiagram
implements Serializable,
Cloneable {
    static final long serialVersionUID = 3608697780697216579L;
    private int blockSerializedDataVersion = 1;
    public static final String ERROR = "err";
    public static final String ERR_NO_RESOURCE = "noResource";
    public static final String SUBSTITUTE = "substitute";
    public static final String PROPERTY_CHANGED = "propChanged";
    public static final String PROPERTY_CHANGED_STRING = "propChangedString";
    public static final String ERR_DESCRIPTION = "errDescription";
    private static final int DEFAULT_RESOURCETYPE_COUNT = 5;
    protected static final int RES_FREE = 0;
    protected static final int RES_RESERVED = 1;
    protected static final int RES_ALLOCATED = 2;
    protected Vector fBlockResource = new Vector();
    protected Vector fBlockVector = new Vector();
    protected transient ProgrammingLanguage fProgrammingLanguage;
    protected Hardware fHardware;
    protected transient Vector fHardwareChangedListeners;
    protected transient MessageManager fMessageManager;
    protected transient Vector usedResourcesListeners = new Vector();
    protected transient HashSet fBlockSubstituteListener;
    private transient boolean modified = false;
    protected String fPassword = null;
    protected DrawingProperties fDrawingProperties;
    protected MessageGlobalInfo fMessageGlobalInfo;
    public transient boolean isUserProgramFromBM = false;

    public WiringDiagram() {
        this(HardwareFactory.getInstance().createInstance());
    }

    public WiringDiagram(Hardware hardware) {
        if (hardware == null) {
            hardware = HardwareFactory.getInstance().createInstance();
        }
        this.setHardware(hardware);
    }

    protected String addBlock(Block block) {
        String result = block.preInsert(this);
        this.fBlockVector.addElement(block);
        block.setWiringDiagram(this);
        block.setNumberPrefix(this.getProgrammingLanguage().getBlockNumberPrefix(block));
        this.setModified(true);
        this.usedResourcesChanged();
        return result;
    }

    public synchronized void addBlockSubstituteListener(BlockSubstituteListener l) {
        this.getBlockSubstituteListeners().add(l);
    }

    public synchronized void addHardwareChangedListener(HardwareChangedListener l) {
        if (!this.getHardwareChangedListeners().contains(l)) {
            this.getHardwareChangedListeners().addElement(l);
        }
    }

    public void addUsedResourcesChangedListener(UsedResourcesChangedListener urcl) {
        if (this.usedResourcesListeners.contains(urcl)) {
            return;
        }
        this.usedResourcesListeners.add(urcl);
    }

    public boolean canConnectWithoutRecursion(OutBlockConnector outConnector, InBlockConnector inConnector) {
        boolean retValue = true;
        Block inputBlock = inConnector.getOwner();
        Block outputBlock = outConnector.getOwner();
        if (!(outputBlock instanceof OutputBlock) && !(inputBlock instanceof OutputBlock)) {
            BlockEnumerator enumeration = new BlockEnumerator(outputBlock, false);
            while (retValue && enumeration.hasMoreElements()) {
                if (inputBlock != enumeration.nextBlock()) continue;
                retValue = false;
            }
        }
        return retValue;
    }

    void changeNumber(int numberType, int oldNumber, int newNumber) throws IllegalArgumentException {
        if (numberType != -1) {
            int[] resourceArr = this.getNumberResource(numberType);
            if (resourceArr[newNumber - 1] == 2) {
                throw new IllegalArgumentException("New blocknumber is already allocated.");
            }
            resourceArr[oldNumber - 1] = 0;
            resourceArr[newNumber - 1] = 2;
        }
    }

    public void compile() {
        Hardware hw = this.getHardware();
        hw.getCompilerToHardware().compile(this, hw);
    }

    public boolean contains(Block block) {
        Enumeration blocks = this.getBlocks().elements();
        while (blocks.hasMoreElements()) {
            if (blocks.nextElement() != block) continue;
            return true;
        }
        return false;
    }

    public Block[] getCopyOfBlocks() {
        Vector orgBlocks = this.getBlocks();
        int nrOfBlocks = orgBlocks.size();
        Block[] newBlocks = new Block[nrOfBlocks];
        for (int i = 0; i < nrOfBlocks; ++i) {
            newBlocks[i] = ((Block)orgBlocks.elementAt(i)).deepCopy();
        }
        ArrayList<String> blockNames = new ArrayList<String>(nrOfBlocks);
        for (int i = 0; i < nrOfBlocks; ++i) {
            blockNames.add(i, ((Block)orgBlocks.elementAt(i)).getNumberString());
        }
        for (int blockIdx = 0; blockIdx < nrOfBlocks; ++blockIdx) {
            Block block;
            String orgName;
            Object enumeration;
            int i;
            Block orgBlock = (Block)orgBlocks.elementAt(blockIdx);
            int size = orgBlock.getInConnectorCount();
            for (i = 0; i < size; ++i) {
                enumeration = orgBlock.getInConnector(i).getLinkedConnectors();
                while (enumeration.hasMoreElements()) {
                    OutBlockConnector orgPrevConnector = enumeration.nextElement();
                    orgName = orgPrevConnector.getOwner().getNumberString();
                    block = newBlocks[blockNames.indexOf(orgName)];
                    OutBlockConnector newPrevConnector = block.getOutConnector(orgPrevConnector.getOwner().getOutConnectorPosition(orgPrevConnector));
                    newBlocks[blockIdx].getInConnector(i).connect(newPrevConnector);
                }
            }
            size = orgBlock.getOutConnectorCount();
            for (i = 0; i < size; ++i) {
                enumeration = orgBlock.getOutConnector(i).getLinkedConnectors();
                while (enumeration.hasMoreElements()) {
                    InBlockConnector orgConnector = enumeration.nextElement();
                    orgName = orgConnector.getOwner().getNumberString();
                    block = newBlocks[blockNames.indexOf(orgName)];
                    try {
                        InBlockConnector newConnector = block.getInConnector(orgConnector.getOwner().getInConnectorPosition(orgConnector));
                        newBlocks[blockIdx].getOutConnector(i).connect(newConnector);
                    }
                    catch (NullPointerException e) {
                        System.err.println("wd.getCopyOfBlocks(): Connector" + orgName + "/" + orgConnector.getName() + "not found");
                    }
                }
            }
            HardwareChangedEvent hardwareChangedEvent = new HardwareChangedEvent(this, orgBlock.getHardware(), newBlocks[0].getHardware());
            if (!(orgBlock instanceof MessageBlock)) continue;
            MessageParameter messageParameter = null;
            BlockParameter blockParameter = null;
            Block newBlock = newBlocks[blockNames.indexOf(orgBlock.getNumberString())];
            messageParameter = (MessageParameter)newBlock.getParameter();
            MessageLine[] messageLines = messageParameter.getMessage();
            for (int j = 0; j < messageLines.length; ++j) {
                blockParameter = messageLines[j].getBlockParameter();
                if (blockParameter == null) continue;
                Block newReferencedBlock = newBlocks[blockNames.indexOf(blockParameter.getBlock().getNumberString())];
                messageLines[j].setBlockParameter(newReferencedBlock.getParameter());
            }
        }
        for (int n = 0; n < newBlocks.length; ++n) {
            newBlocks[n].removeAllListener();
        }
        return newBlocks;
    }

    public Block createBlock(int opcode, int blockNumber) throws IllegalArgumentException {
        Block result = null;
        Block blockTypeClass = null;
        Vector[] allBlocks = this.getAvailableBlocks();
        boolean found = false;
        block2: for (int i = 0; i < allBlocks.length; ++i) {
            Enumeration enumeration = allBlocks[i].elements();
            blockTypeClass = (Block)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                result = (Block)enumeration.nextElement();
                if (result.getOpcode(this.getHardware(), blockNumber) != opcode) continue;
                found = true;
                break block2;
            }
        }
        if (found) {
            try {
                result = Block.createInstanceForName(result.getClassName(), this);
                this.addBlock(result);
            }
            catch (IOException e) {
                throw new RuntimeException("Creating class from opcode failed");
            }
        } else {
            String s = Language.getString("error.model.WiringDia", "ERROR: No class found for Blocknumber/Opcode:") + blockNumber + "/0x" + Integer.toHexString(opcode);
            Log.println("log.err.noClassForOpcode", s);
            throw new IllegalArgumentException(s);
        }
        result.changeNumber(blockNumber);
        return result;
    }

    protected int[] createNumberResource(int resourceType) {
        if (this.fBlockResource.size() <= resourceType) {
            this.fBlockResource.setSize(resourceType + 1);
        }
        int[] resourceArr = new int[this.fHardware.getMaxResource(resourceType)];
        this.fBlockResource.setElementAt(resourceArr, resourceType);
        return resourceArr;
    }

    public static WiringDiagram createWiringDiagram() {
        return WiringDiagram.createWiringDiagram(null);
    }

    public static WiringDiagram createWiringDiagram(Hardware hardware) {
        WiringDiagram wiringDiagram = null;
        wiringDiagram = new WiringDiagram(hardware);
        return wiringDiagram;
    }

    public void deleteBlock(Block block) {
        if (this.fBlockVector.contains(block)) {
            this.fBlockVector.removeElement(block);
            block.setWiringDiagram(null);
            int[] resourceArr = this.getNumberResource(block);
            if (resourceArr != null) {
                int blockNumber = block.getNumber();
                if (blockNumber != 0) {
                    int idx = blockNumber - 1;
                    try {
                        if (resourceArr[idx] == 2) {
                            resourceArr[idx] = 0;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {}
                } else {
                    System.out.println("Block mit Nummer 0 gel\u00f6scht!");
                }
            }
            this.setModified(true);
            this.usedResourcesChanged();
            block.postDelete(this);
        }
        this.verifyMessageLineParameterReferences();
        this.verifyParameterReferences(block);
        this.verifyBlockReference(block);
    }

    protected void verifyParameterReferences(Block deletedBlock) {
        ParameterItemList itemList = ((ParameterItemTable)this.getHardware().getProperty("parameterItemTable")).getParameterItems(deletedBlock.getParameter());
        if (itemList.size() > 0) {
            for (Block block : this.getBlocks()) {
                BlockParameter param = block.getParameter();
                if (param == null) continue;
                Iterator items = param.getParameterItems().getValueOrReferenceItems().iterator();
                while (items.hasNext()) {
                    ParameterItem parItem = ((ParameterItem)items.next()).getInstanceForParameter(param);
                    ValueOrItemReference valueOrRef = (ValueOrItemReference)parItem.getValue();
                    if (!valueOrRef.isReference() || valueOrRef.getReference().getParameter().getBlock() != deletedBlock) continue;
                    parItem.setValue(valueOrRef.setDefaultDirectValue());
                    block.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "param;"));
                }
            }
        }
    }

    protected void verifyBlockReference(Block deletedBlock) {
        if (deletedBlock instanceof AnalogMathsBlock && this.getHardware().isBlockNameAvailable("MathDetection")) {
            for (Block block : this.getBlocks()) {
                if (!(block instanceof MathDetectionBlock)) continue;
                MathDetectionParameter param = (MathDetectionParameter)block.getParameter();
                if (deletedBlock.getNumber() != param.getReferencedBlockNumber()) continue;
                param.setReferencedBlockNumber(-1);
                block.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "param;"));
            }
        }
    }

    public void download(DataTransfer dt) throws ProgramException {
        ApplicationSurface applicationWindow = Application.getInstance().getActiveApplicationSurface();
        try {
            int answer;
            Hardware remoteHardware = dt.getHardware();
            Log.println(remoteHardware.getLocalizedPath() + remoteHardware.getLocalizedName());
            remoteHardware = ((Logo)remoteHardware).prepareDownload(dt, this);
            ArrayList errorList = new ArrayList();
            if (!this.isSuitable(remoteHardware, errorList)) {
                Hardware minHardware = this.getSuitableHardware(new ArrayList())[0];
                String s = minHardware.getLocalizedPath() + minHardware.getLocalizedName();
                s = Language.getString("error.com.remoteHardwareToSmall", "Remote device not usable.", s);
                ProgramException programException = new ProgramException(s);
                if (errorList != null) {
                    for (ErrorInfo entry : errorList) {
                        ArrayList list = entry.getAdditionalInfo();
                        String leading = "";
                        if (list.size() > 0) {
                            if (list.get(0) instanceof Hardware) {
                                leading = ((Hardware)list.get(0)).getLocalizedName(true);
                            } else {
                                System.err.println("wiringDiagram.isBlockAvailable(Block,Hardware): Unknown additional Parameter");
                            }
                        }
                        programException.setLog(leading + ":\t" + entry.getSource().getLocalizedName(true) + "\t" + entry.getMessage());
                    }
                }
                throw programException;
            }
            if (remoteHardware.getName().equals("Unknown") && 3 == (answer = new LogoError((Component)applicationWindow, "error.com.downloadToUnknown", "Hardware unknown! \nDo you want to transfer data?", 3, 2).display())) {
                ProgramException e = new ProgramException();
                e.setLog(Language.getString("error.com.remoteHardwareUnknown", "Remote Hardware unknown"));
                e.setLog(Language.getString("error.com.userAbort", "Transmission aborted by user"));
                throw e;
            }
            WiringDiagram wdToDownload = null;
            if (remoteHardware.getName().equals(this.getHardware().getName())) {
                wdToDownload = this;
            } else {
                HardwareChangedEvent hwChangedEvent;
                Hashtable substDict;
                wdToDownload = new WiringDiagram(this.getHardware());
                wdToDownload.setDrawingProperties(this.getDrawingProperties());
                wdToDownload.setMessageGlobalInfo(this.getMessageGlobalInfo());
                HashMap dict = new HashMap();
                boolean insertError = wdToDownload.insert(this, dict);
                if (dict.get(ERROR) != null) {
                    String error = (String)dict.get(ERROR);
                    System.out.println("FATAL ERROR in HardwarePanel.storeFieldContents():" + error);
                }
                if ((substDict = (hwChangedEvent = wdToDownload.setHardware(remoteHardware)).getSubstitutedBlocksDictionary()).size() > 0) {
                    for (Map.Entry entry : substDict.entrySet()) {
                        Block oldBlock = (Block)entry.getKey();
                        Block newBlock = (Block)entry.getValue();
                        wdToDownload.replace(oldBlock, newBlock);
                    }
                }
            }
            wdToDownload.compile();
            for (int i = 0; i < LogoProperties.instance().getIntProperty("downloadCount", 1); ++i) {
                wdToDownload.getHardware().downloadProgram(dt, wdToDownload);
            }
        }
        catch (ExceptionAlreadyHandledException e) {
            throw new ProgramException();
        }
        finally {
            if (dt != null) {
                dt.closePort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBlockSubstituteEvent(Block oldBlock, Block newBlock) {
        HashSet set;
        WiringDiagram wiringDiagram = this;
        synchronized (wiringDiagram) {
            set = (HashSet)this.getBlockSubstituteListeners().clone();
        }
        Iterator e = set.iterator();
        while (e.hasNext()) {
            ((BlockSubstituteListener)e.next()).substituteBlock(oldBlock, newBlock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHardwareChangedEvent(HardwareChangedEvent hardwareChangedEvent) {
        Vector l;
        WiringDiagram wiringDiagram = this;
        synchronized (wiringDiagram) {
            l = (Vector)this.getHardwareChangedListeners().clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            HardwareChangedListener hl = (HardwareChangedListener)l.elementAt(i);
            hl.hardwareChanged(hardwareChangedEvent);
        }
    }

    public Vector getAllOutConnectors() {
        Vector<OutBlockConnector> outConnectors = new Vector<OutBlockConnector>();
        Enumeration blockEnum = this.getBlocks().elements();
        Block block = null;
        while (blockEnum.hasMoreElements()) {
            block = (Block)blockEnum.nextElement();
            for (int i = 0; i < block.getOutConnectorCount(); ++i) {
                outConnectors.add(block.getOutConnector(i));
            }
        }
        return outConnectors;
    }

    public Vector getAnchorsHardware() {
        Vector<Block> anchors = new Vector<Block>();
        Vector blocks = this.getBlocks();
        if (blocks.size() > 0) {
            Enumeration allBlocks = blocks.elements();
            while (allBlocks.hasMoreElements()) {
                Block block = (Block)allBlocks.nextElement();
                if (!block.isRightTerminal()) continue;
                anchors.addElement(block);
            }
        }
        return anchors;
    }

    protected Vector[] getAvailableBlocks() {
        Vector[] availableBlocks = this.fHardware.getAvailableBlocks();
        return availableBlocks;
    }

    public ArrayList getBlocksForReference(Block notIncluded, boolean refToOwner) {
        ArrayList referenceList = new ArrayList(30);
        Enumeration enumeration = this.getBlocks().elements();
        while (enumeration.hasMoreElements()) {
            BlockParameter param;
            Block block = (Block)enumeration.nextElement();
            if (block == notIncluded || (param = block.getParameter()) == null) continue;
            ParameterItemList list = param.getParameterItems().getParameterSourceItems();
            if (refToOwner) {
                list = list.instance(param);
            }
            referenceList.addAll(list);
        }
        return referenceList;
    }

    public Block getBlock(int opcode, int blockNumber) {
        Block result = null;
        Block block = null;
        Enumeration enumeration = this.fBlockVector.elements();
        while (enumeration.hasMoreElements()) {
            block = (Block)enumeration.nextElement();
            if (block.getOpcode() != opcode || block.getNumber() != blockNumber) continue;
            result = block;
            break;
        }
        return result;
    }

    public Vector getBlocks() {
        return this.fBlockVector;
    }

    protected HashSet getBlockSubstituteListeners() {
        if (this.fBlockSubstituteListener == null) {
            this.fBlockSubstituteListener = new HashSet(5);
        }
        return this.fBlockSubstituteListener;
    }

    public Vector getBlocksWithOpenOutConnectors() {
        Vector<Block> result = new Vector<Block>();
        Enumeration outConnectors = this.getAllOutConnectors().elements();
        while (outConnectors.hasMoreElements()) {
            OutBlockConnector connector = (OutBlockConnector)outConnectors.nextElement();
            if (connector.getLinkedConnectorsCount() != 0) continue;
            result.add(connector.getOwner());
        }
        return result;
    }

    public DrawingProperties getDrawingProperties() {
        if (this.fDrawingProperties == null) {
            this.fDrawingProperties = new DrawingProperties();
            this.fDrawingProperties.addHistoryEntry(new DrawingHistoryEntry());
        }
        return this.fDrawingProperties;
    }

    public MessageGlobalInfo getMessageGlobalInfo() {
        if (this.fMessageGlobalInfo == null) {
            this.fMessageGlobalInfo = new MessageGlobalInfo();
            if (this.getHardware() == null || !this.getHardware().supports("supportAsiaLanguage")) {
                this.fMessageGlobalInfo.setFUseNewFeature(false);
            }
        }
        this.fMessageGlobalInfo.setSupportJapaneseSJIS(this.getHardware().supports("SupportJapaneseLanguage"));
        return this.fMessageGlobalInfo;
    }

    public void setMessageGlobalInfo(MessageGlobalInfo msgInfo) {
        this.fMessageGlobalInfo = msgInfo;
    }

    public Hashtable getErrors() {
        Vector blockVector = null;
        Hashtable dict = new Hashtable();
        blockVector = this.getOpenBlocks();
        if (blockVector.size() > 0) {
            Vector<Block> openBlocksResult = new Vector<Block>();
            for (Block block : blockVector) {
                if (block.getOutConnectorCount() <= 0 || block.getOutConnector(0).getLinkedConnectors().hasMoreElements()) continue;
                openBlocksResult.add(block);
            }
            dict.put("msg.notReachableBlocks", openBlocksResult);
        }
        return dict;
    }

    public int getFreeNumber(int resourceType) {
        int result = this.searchFreeNumber(resourceType, true);
        return result;
    }

    public int[] getFreeNumbers(int type) {
        int[] resourceArr = this.getNumberResource(type);
        if (resourceArr == null) {
            return new int[0];
        }
        int[] freeArr = new int[resourceArr.length];
        int freeBlockCount = 0;
        for (int i = 0; i < resourceArr.length; ++i) {
            if (resourceArr[i] != 0 && resourceArr[i] != 1) continue;
            freeArr[freeBlockCount++] = i + 1;
        }
        int[] returnArr = new int[freeBlockCount];
        System.arraycopy(freeArr, 0, returnArr, 0, freeBlockCount);
        return returnArr;
    }

    public int[] getFreeResources() {
        int[] result = this.fHardware.getMaxResources();
        int[] usedRes = this.getUsedResources(this.getBlocks());
        for (int j = 0; j < usedRes.length; ++j) {
            int n = j;
            result[n] = result[n] - usedRes[j];
        }
        return result;
    }

    public WiringDiagram getFup() {
        return this;
    }

    public Hardware getHardware() {
        return this.fHardware;
    }

    public Vector getHardwareChangedListeners() {
        if (this.fHardwareChangedListeners == null) {
            this.fHardwareChangedListeners = new Vector();
        }
        return this.fHardwareChangedListeners;
    }

    public Vector getInputBlocks() {
        Vector<Block> inputBlocks = new Vector<Block>();
        Enumeration blockEnum = this.getBlocks().elements();
        Block block = null;
        while (blockEnum.hasMoreElements()) {
            block = (Block)blockEnum.nextElement();
            if (!(block instanceof InputBlock)) continue;
            inputBlocks.add(block);
        }
        return inputBlocks;
    }

    private final int getMaxBlockNumber() {
        int result = 0;
        Enumeration enumeration = this.getBlocks().elements();
        while (enumeration.hasMoreElements()) {
            result = Math.max(((Block)enumeration.nextElement()).getNumber(), result);
        }
        return result;
    }

    public Block[] getMaxStackDepthBlocks() {
        Vector maxPath = new Vector();
        try {
            Hashtable visitedBlocks = new Hashtable();
            Enumeration anchors = this.getAnchorsHardware().elements();
            while (anchors.hasMoreElements()) {
                Block anchor = (Block)anchors.nextElement();
                Vector path = anchor.getMaxPath(visitedBlocks);
                if (path.size() <= maxPath.size()) continue;
                maxPath = path;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Block[] result = new Block[maxPath.size()];
        maxPath.toArray(result);
        return result;
    }

    public MessageManager getMessageManager() {
        if (this.fMessageManager == null) {
            this.fMessageManager = new MessageManager(this);
        }
        return this.fMessageManager;
    }

    public int[] getNumberResource(int resourceType) {
        int[] resourceArr = null;
        if (this.fBlockResource.size() <= resourceType) {
            resourceArr = this.createNumberResource(resourceType);
        } else {
            resourceArr = (int[])this.fBlockResource.elementAt(resourceType);
            if (resourceArr == null) {
                resourceArr = this.createNumberResource(resourceType);
            }
        }
        if (resourceArr != null && resourceArr.length < 1) {
            resourceArr = null;
        }
        return resourceArr;
    }

    protected int[] getNumberResource(Block block) {
        int[] result = null;
        int resourceType = block.getNumberType();
        if (resourceType >= 0) {
            result = this.getNumberResource(resourceType);
        }
        return result;
    }

    public Vector getOpenBlocks() {
        Block block;
        int i;
        Vector<Block> wrongBlocks = new Vector<Block>();
        Hashtable<String, Block> hashtable = new Hashtable<String, Block>();
        Vector outputBlocks = this.getAnchorsHardware();
        int size = outputBlocks.size();
        for (i = 0; i < size; ++i) {
            BlockEnumeratorFullPath bEnum = new BlockEnumeratorFullPath((Block)outputBlocks.elementAt(i), false);
            while (bEnum.hasMoreElements()) {
                block = bEnum.nextBlock();
                hashtable.put(block.getNumberString(), block);
            }
        }
        size = this.fBlockVector.size();
        for (i = 0; i < size; ++i) {
            block = (Block)this.fBlockVector.elementAt(i);
            if (hashtable.get(block.getNumberString()) != null) continue;
            wrongBlocks.addElement(block);
        }
        return wrongBlocks;
    }

    protected Vector getOpenOutputs() {
        Vector<Block> wrongBlocks = new Vector<Block>();
        Hashtable hashtable = new Hashtable();
        Vector outputBlocks = this.getAnchorsHardware();
        int size = outputBlocks.size();
        for (int i = 0; i < size; ++i) {
            boolean found = false;
            Block anchor = (Block)outputBlocks.elementAt(i);
            if (anchor instanceof MarkerBlock && anchor.getNumber() == 8) break;
            BlockEnumeratorFullPath blockEnum = new BlockEnumeratorFullPath(anchor, false);
            Block block = blockEnum.nextBlock();
            while (blockEnum.hasMoreElements()) {
                block = blockEnum.nextBlock();
                if (!block.isTerminal()) continue;
                found = true;
                break;
            }
            if (found) continue;
            wrongBlocks.addElement(anchor);
        }
        return wrongBlocks;
    }

    public Vector getOutputBlocks() {
        Vector<Block> outputBlocks = new Vector<Block>();
        Enumeration blockEnum = this.getBlocks().elements();
        Block block = null;
        while (blockEnum.hasMoreElements()) {
            block = (Block)blockEnum.nextElement();
            if (!(block instanceof OutputBlock) || block instanceof VirtualOutputBlock) continue;
            outputBlocks.add(block);
        }
        return outputBlocks;
    }

    public String getResourceInfo() {
        int[] used = this.getUsedResources(this.getBlocks());
        int[] max = this.getHardware().getMaxResources();
        StringBuffer result = new StringBuffer();
        for (int idx = 0; idx < used.length; ++idx) {
            String[] resNames = HardwareFactory.getInstance().getResourceNames();
            if (max[idx] == 0 || max[idx] == Integer.MAX_VALUE) continue;
            String resName = resNames[idx];
            StringBuffer s = this.getResourceLine(resName, used[idx], max[idx]);
            result.append(s);
            if (idx != 12 || !this.getHardware().supports("supportAsiaLanguage")) continue;
            StringBuffer s1 = this.getResourceLine("CharacterContents", this.getMessageManager().getUsedTextIDCount(), 50);
            result.append(s1);
        }
        return result.toString();
    }

    private StringBuffer getResourceLine(String resName, int cur, int max) {
        StringBuffer s = new StringBuffer(600);
        s.append(Language.getString("hardware." + resName, resName));
        if (s.length() > 24) {
            s.setLength(22);
            s.append(". ");
        } else {
            s.append("                       ").setLength(24);
        }
        s.append(cur).append("/").append(max).append("\n");
        return s;
    }

    public Hardware[] getSuitableHardware(ArrayList errorList) {
        Vector blockVector = this.getBlocks();
        Hardware[] knownHardware = HardwareFactory.getInstance().getAvailableHardware();
        Hardware[] result = null;
        if (blockVector.size() > 0) {
            Hardware[] suitableHardware = new Hardware[knownHardware.length];
            int j = 0;
            for (int i = 0; i < knownHardware.length; ++i) {
                if (!this.isSuitable(knownHardware[i], errorList)) continue;
                suitableHardware[j++] = knownHardware[i];
            }
            if (j > 0) {
                result = new Hardware[j];
                System.arraycopy(suitableHardware, 0, result, 0, j);
            }
        } else {
            result = knownHardware;
        }
        return result;
    }

    public String[] getSuitableHardwareString(Hardware[] hw) {
        String[] result = null;
        int resLength = 0;
        Object[] obj = new Object[2];
        String s = null;
        if (hw != null) {
            resLength = hw[hw.length - 1].getName().equals("Unknown") ? hw.length - 1 : hw.length;
            result = new String[resLength];
            for (int i = 0; i < resLength; ++i) {
                int hwMaxNumber;
                int wdMaxNumber = this.getMaxBlockNumber();
                if (wdMaxNumber > (hwMaxNumber = hw[i].getMaxResource(0))) {
                    obj[0] = new Integer(wdMaxNumber);
                    obj[1] = new Integer(hwMaxNumber);
                    s = Language.getString("msg.blocknumberToBig", "Blocknumber(s) must not greater than " + hwMaxNumber, obj);
                    result[i] = hw[i].getLocalizedPath() + hw[i].getLocalizedName() + " - " + s;
                    continue;
                }
                result[i] = hw[i].getLocalizedPath() + hw[i].getLocalizedName();
            }
        } else {
            result = new String[]{Language.getString("log.msg.noSuitableHardware", "No suitable Hardware found!")};
        }
        return result;
    }

    public int[] getUsedResources(Block[] blocks) {
        int[] resourceConsumptionBlock = null;
        int[] resourceConsumption = new int[HardwareFactory.getInstance().getResourceNames().length];
        for (int i = 0; i < blocks.length; ++i) {
            resourceConsumptionBlock = blocks[i].getMemoryResources(this.getHardware());
            for (int j = 0; j < resourceConsumptionBlock.length; ++j) {
                int n = j;
                resourceConsumption[n] = resourceConsumption[n] + resourceConsumptionBlock[j];
            }
        }
        resourceConsumption[5] = this.getMaxStackDepthBlocks().length;
        return resourceConsumption;
    }

    public int[] getUsedResources(Vector usedBlocks) {
        Object[] arr = new Block[usedBlocks.size()];
        usedBlocks.copyInto(arr);
        return this.getUsedResources((Block[])arr);
    }

    public String getUsedResourceString() {
        int[] arr = this.getUsedResources(this.getBlocks());
        String result = "";
        String[] resNames = HardwareFactory.getInstance().getResourceNames();
        for (int idx = 0; idx < arr.length; ++idx) {
            String s = Language.getString("hardware." + resNames[idx], resNames[idx]);
            s = (s + "                       ").substring(0, 20);
            s = s + "=\t" + arr[idx] + "\n";
            result = result + s;
        }
        return result;
    }

    public Hashtable getWarnings() {
        Vector blockVector = null;
        Hashtable<String, Vector> dict = new Hashtable<String, Vector>();
        blockVector = this.getOpenOutputs();
        if (blockVector.size() > 0) {
            dict.put("msg.deadOutputs", blockVector);
        }
        return dict;
    }

    public void initParameter(Interpreter interpreter, boolean forceReset) {
        for (int i = 0; i < this.fBlockVector.size(); ++i) {
            ((Block)this.fBlockVector.elementAt(i)).init(interpreter, forceReset);
        }
    }

    public boolean insert(Block[] blocks, HashMap resultDict) {
        boolean resourceOk = true;
        boolean numberChanged = false;
        Hardware hw = this.getHardware();
        ArrayList<Block> addedBlocks = new ArrayList<Block>(blocks.length);
        ArrayList<Block> substitute = (ArrayList<Block>)resultDict.get(SUBSTITUTE);
        ArrayList<Block> propChanged = (ArrayList<Block>)resultDict.get(PROPERTY_CHANGED);
        ArrayList<String> propChangedStr = (ArrayList<String>)resultDict.get(PROPERTY_CHANGED_STRING);
        ArrayList errorList = new ArrayList();
        for (int i = 0; i < blocks.length; ++i) {
            if (this.isBlockAvailable(blocks[i], hw, errorList) && blocks[i].isResourceAvailable(this, errorList)) {
                String changes;
                Block block = ((Logo)hw).getSubstitutionBlock(blocks[i]);
                String oldBlockNrString = block.getNumberString();
                int numberType = block.getNumberType();
                int blockNumber = block.getNumber();
                if (numberType > -1) {
                    int[] resourceArr = this.getNumberResource(block);
                    if (resourceArr[blockNumber - 1] == 2) {
                        block.setNumber(this.getFreeNumber(numberType));
                        numberChanged = true;
                    } else {
                        resourceArr[blockNumber - 1] = 2;
                        numberChanged = false;
                    }
                }
                if (((changes = this.addBlock(block)) != null || numberChanged) && block == blocks[i]) {
                    if (propChanged == null) {
                        propChanged = new ArrayList<Block>(blocks.length);
                        propChangedStr = new ArrayList<String>(blocks.length);
                        resultDict.put(PROPERTY_CHANGED, propChanged);
                        resultDict.put(PROPERTY_CHANGED_STRING, propChangedStr);
                    }
                    propChanged.add(block);
                    String s = "";
                    if (numberChanged) {
                        if (changes == null) {
                            changes = "";
                        }
                        if (changes.length() > 0) {
                            changes = changes + " | ";
                        }
                        changes = changes + oldBlockNrString + " --> " + block.getNumberString();
                    }
                    propChangedStr.add(changes);
                }
                addedBlocks.add(block);
                if (block == blocks[i]) continue;
                if (substitute == null) {
                    substitute = new ArrayList<Block>(blocks.length * 2);
                    resultDict.put(SUBSTITUTE, substitute);
                }
                substitute.add(blocks[i]);
                substitute.add(block);
                numberChanged = false;
                continue;
            }
            if (i > 0) {
                int size = addedBlocks.size();
                for (int j = 0; j < size; ++j) {
                    this.deleteBlock((Block)addedBlocks.get(j));
                }
            }
            resourceOk = false;
            break;
        }
        if (!resourceOk) {
            resultDict.put(ERROR, ERR_NO_RESOURCE);
            if (errorList.size() > 0) {
                resultDict.put(ERR_DESCRIPTION, errorList);
            }
        }
        return resourceOk;
    }

    public String insert(Block block) {
        String result = null;
        if (!this.contains(block)) {
            int[] resourceArr;
            block.setWiringDiagram(this);
            int blockNumber = block.getNumber();
            if (blockNumber > 0 && (resourceArr = this.getNumberResource(block)) != null) {
                try {
                    resourceArr[blockNumber - 1] = 2;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("WiringDiagram.insert(Block): NoResource in ResourceArray for " + block);
                }
            }
            result = this.addBlock(block);
        }
        return result;
    }

    protected boolean insert(WiringDiagram wd, HashMap result) {
        this.insert(wd.getCopyOfBlocks(), result);
        if (result.get(ERROR) != null) {
            return false;
        }
        ArrayList list = (ArrayList)result.get(PROPERTY_CHANGED);
        if (list != null) {
            return true;
        }
        list = (ArrayList)result.get(SUBSTITUTE);
        if (list != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                Object enumeration;
                int i;
                Block oldBlock = (Block)itr.next();
                Block newBlock = (Block)itr.next();
                int count = oldBlock.getInConnectorCount();
                for (i = 0; i < count; ++i) {
                    InBlockConnector newInConnector = newBlock.getInConnector(i);
                    InBlockConnector oldInConnector = oldBlock.getInConnector(i);
                    enumeration = oldInConnector.getLinkedConnectors();
                    while (enumeration.hasMoreElements()) {
                        OutBlockConnector oldPrevConnector = enumeration.nextElement();
                        oldPrevConnector.disconnect(oldInConnector);
                        newInConnector.connect(oldPrevConnector);
                    }
                }
                count = oldBlock.getOutConnectorCount();
                for (i = 0; i < count; ++i) {
                    OutBlockConnector oldOutConnector = oldBlock.getOutConnector(i);
                    OutBlockConnector newOutConnector = newBlock.getOutConnector(i);
                    enumeration = oldOutConnector.getLinkedConnectors();
                    while (enumeration.hasMoreElements()) {
                        InBlockConnector oldNextConnector = enumeration.nextElement();
                        oldNextConnector.disconnect(oldOutConnector);
                        newOutConnector.connect(oldNextConnector);
                    }
                }
            }
        }
        return true;
    }

    public void invalidateOutConnectors() {
        OutBlockConnector[] outConnectors = null;
        int size = this.fBlockVector.size();
        for (int i = 0; i < size; ++i) {
            outConnectors = ((Block)this.fBlockVector.elementAt(i)).getOutConnectors();
            for (int j = 0; j < outConnectors.length; ++j) {
                outConnectors[j].setDataInvalid();
            }
        }
    }

    public boolean isCorrect() {
        return true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isNumberAvailable(int resourceType) {
        boolean result = false;
        int nr = this.searchFreeNumber(resourceType, false);
        if (nr > 0) {
            result = true;
        }
        return result;
    }

    public boolean isRightTerminal(Block block) {
        return block instanceof VirtualOutputBlock;
    }

    protected boolean isBlockAvailable(Block block, Hardware hardware, ArrayList errorList) {
        boolean result = block.isAvailable(hardware, errorList);
        return result;
    }

    public boolean isStackDepthOk() {
        return this.getMaxStackDepthBlocks().length <= this.fHardware.getMaxResource(5);
    }

    public boolean isSuitable(Hardware hw, ArrayList errorList) {
        if (hw.getClass() == this.getHardware().getClass()) {
            return true;
        }
        if (hw.getClass() == Unknown.class) {
            return true;
        }
        if (this.getUsedResources(this.getBlocks())[0] > hw.getMaxResource(0)) {
            Enumeration enumeration = this.getBlocks().elements();
            boolean loop = true;
            Block wrongBlock = null;
            while (loop && enumeration.hasMoreElements()) {
                Block element = (Block)enumeration.nextElement();
                loop = element.isAvailable(hw, errorList);
                if (loop || element.getNumber() >= 1) continue;
                wrongBlock = element;
                loop = true;
            }
            if (loop) {
                if (errorList == null) {
                    errorList = new ArrayList<ErrorInfo>();
                }
                errorList.add(new ErrorInfo(wrongBlock, "error.convert.block.numberTooBig", hw));
            }
            return false;
        }
        WiringDiagram wd = WiringDiagram.createWiringDiagram(hw);
        Block[] usedBlocks = this.getCopyOfBlocks();
        boolean result = true;
        HashMap dict = new HashMap();
        boolean error = wd.insert(usedBlocks, dict);
        if (dict.get(ERROR) != null || !wd.isStackDepthOk()) {
            result = false;
            ArrayList list = (ArrayList)dict.get(ERR_DESCRIPTION);
            if (list != null) {
                errorList.addAll(list);
            }
        } else if (dict.get(PROPERTY_CHANGED) != null) {
            Object[] arr = ((ArrayList)dict.get(PROPERTY_CHANGED)).toArray();
            Object[] changeMsgArr = ((ArrayList)dict.get(PROPERTY_CHANGED_STRING)).toArray();
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] instanceof MessageBlock) continue;
                result = false;
                errorList.add(new ErrorInfo((Block)arr[i], (String)changeMsgArr[i], hw));
            }
        }
        return result;
    }

    public void netOn(Interpreter interpreter, boolean forceReset) {
        this.resetOutputs();
        this.invalidateOutConnectors();
        this.initParameter(interpreter, forceReset);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.usedResourcesListeners = new Vector();
        in.defaultReadObject();
    }

    public void releaseBlock(Block[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            int idx;
            int[] resourceArr = this.getNumberResource(blocks[i]);
            if (resourceArr == null || resourceArr[idx = blocks[i].getNumber() - 1] != 1) continue;
            resourceArr[idx] = 0;
        }
    }

    public void removeBlockSubstituteListener(BlockSubstituteListener l) {
        this.getBlockSubstituteListeners().remove(l);
    }

    public synchronized void removeHardwareChangedListener(HardwareChangedListener l) {
        this.getHardwareChangedListeners().removeElement(l);
    }

    public void removeUsedResourcesChangedListener(UsedResourcesChangedListener urcl) {
        this.usedResourcesListeners.remove(urcl);
    }

    public void reserveBlock(Block[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            int[] resourceArr = this.getNumberResource(blocks[i]);
            if (resourceArr == null) continue;
            resourceArr[blocks[i].getNumber() - 1] = 1;
        }
    }

    protected void resetOutputs() {
        for (int i = 0; i < this.fBlockVector.size(); ++i) {
            if (!(this.fBlockVector.elementAt(i) instanceof OutputBlock)) continue;
            ((OutputBlock)this.fBlockVector.elementAt(i)).reset();
        }
    }

    protected int searchFreeNumber(int resourceType, boolean lock) {
        int i;
        int result = 0;
        int[] resourceArr = this.getNumberResource(resourceType);
        for (i = 0; i < resourceArr.length; ++i) {
            if (resourceArr[i] != 0) continue;
            if (lock) {
                resourceArr[i] = 2;
            }
            result = i + 1;
            break;
        }
        if (result == 0) {
            for (i = 0; i < resourceArr.length; ++i) {
                if (resourceArr[i] != 1) continue;
                if (lock) {
                    resourceArr[i] = 2;
                }
                result = i + 1;
                break;
            }
        }
        return result;
    }

    public void setDrawingProperties(DrawingProperties newDrawingProperties) {
        this.fDrawingProperties = newDrawingProperties;
    }

    public HardwareChangedEvent setHardware(Hardware hw) {
        Hardware oldHardware = this.fHardware;
        if (oldHardware != null && hw != null && oldHardware.getName().equals(hw.getName())) {
            return null;
        }
        this.setModified(true);
        HardwareChangedEvent hwChangedEvent = this.hardwareChanged(hw);
        Hashtable substitutionDict = hwChangedEvent.getSubstitutedBlocksDictionary();
        if (substitutionDict.size() > 0) {
            Log.println("msg.blockSubstitute", "Blocks substituted");
            for (Map.Entry entry : substitutionDict.entrySet()) {
                Block oldBlock = (Block)entry.getKey();
                Block newBlock = (Block)entry.getValue();
                Log.print(oldBlock.getLocalizedName(true));
                Log.print("\t-->\t");
                Log.println(newBlock.getLocalizedName(true));
            }
        }
        return hwChangedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwareChangedEvent hardwareChanged(Hardware hw) {
        Hardware oldHardware = this.fHardware;
        boolean hardwareDifferent = true;
        if (oldHardware != null && hw != null && oldHardware.getName().equals(hw.getName())) {
            hardwareDifferent = false;
        }
        this.fHardware = hw;
        if (this.getHardware() == null || !this.getHardware().supports("supportAsiaLanguage")) {
            this.getMessageGlobalInfo().setFUseNewFeature(false);
        }
        if (oldHardware != null && hw != null) {
            if (hw.supports("NeedMessageNumber")) {
                this.getMessageManager().setFreeMessageNumber();
            } else {
                this.getMessageManager().clearMessageNumber();
            }
        }
        if (oldHardware != null && hardwareDifferent) {
            this.fHardware = hw;
            Enumeration oldValues = this.fBlockResource.elements();
            int size = this.fBlockResource.size();
            this.fBlockResource = new Vector();
            this.fBlockResource.setSize(size);
            int resourceType = 0;
            while (oldValues.hasMoreElements()) {
                int[] oldResourceArr = (int[])oldValues.nextElement();
                if (oldResourceArr != null) {
                    int[] resourceArr = new int[this.fHardware.getMaxResource(resourceType)];
                    size = Math.min(oldResourceArr.length, resourceArr.length);
                    for (int i = 0; i < size; ++i) {
                        resourceArr[i] = oldResourceArr[i];
                    }
                    this.fBlockResource.setElementAt(resourceArr, resourceType);
                }
                ++resourceType;
            }
        }
        HardwareChangedEvent hardwareChangedEvent = new HardwareChangedEvent(this, oldHardware, this.fHardware);
        Vector blocks = null;
        WiringDiagram resourceType = this;
        synchronized (resourceType) {
            blocks = (Vector)this.getBlocks().clone();
        }
        for (Block block : blocks) {
            block.hardwareChanged(hardwareChangedEvent);
        }
        for (Block block : blocks) {
            block.hardwareChangeFinished(hardwareChangedEvent);
        }
        this.fireHardwareChangedEvent(hardwareChangedEvent);
        return hardwareChangedEvent;
    }

    public void setModified(boolean newModified) {
        this.modified = newModified;
    }

    public void substituteBlock(Block oldBlock, Block newBlock) {
        newBlock.setWiringDiagram(this);
        this.fireBlockSubstituteEvent(oldBlock, newBlock);
    }

    public void replace(Block oldBlock, Block newBlock) {
        OutBlockConnector[] srcOutConnectors;
        InBlockConnector[] srcConnectors = oldBlock.getInConnectors();
        if (srcConnectors != null) {
            InBlockConnector[] dstConnectors = newBlock.getInConnectors();
            for (int i = 0; i < srcConnectors.length; ++i) {
                OutBlockConnectorEnumeration linkedConnectors = srcConnectors[i].getLinkedConnectors();
                while (linkedConnectors.hasMoreElements()) {
                    dstConnectors[i].connect(linkedConnectors.nextElement());
                }
                srcConnectors[i].disconnectAll();
            }
        }
        if ((srcOutConnectors = oldBlock.getOutConnectors()) != null) {
            OutBlockConnector[] dstOutConnectors = newBlock.getOutConnectors();
            for (int i = 0; i < srcOutConnectors.length; ++i) {
                InBlockConnectorEnumeration enumeration = srcOutConnectors[i].getLinkedConnectors();
                while (enumeration.hasMoreElements()) {
                    dstOutConnectors[i].connect(enumeration.nextElement());
                }
                srcOutConnectors[i].disconnectAll();
            }
        }
        this.deleteBlock(oldBlock);
        this.insert(newBlock);
    }

    public String toString() {
        return super.toString() + " for:" + this.fHardware.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void usedResourcesChanged() {
        Vector copy = null;
        WiringDiagram wiringDiagram = this;
        synchronized (wiringDiagram) {
            copy = (Vector)this.usedResourcesListeners.clone();
        }
        Enumeration e = copy.elements();
        while (e.hasMoreElements()) {
            ((UsedResourcesChangedListener)e.nextElement()).usedResourcesChanged(this);
        }
    }

    public ProgrammingLanguage getProgrammingLanguage() {
        if (this.fProgrammingLanguage == null) {
            this.fProgrammingLanguage = FupProgrammingLanguage.getInstance();
        }
        return this.fProgrammingLanguage;
    }

    public void verifyMessageLineParameterReferences() {
        this.getMessageManager().verifyMessageLineParameterReferences();
    }

    public DifferenceTableModel compareTo(WiringDiagram other) {
        Block block;
        int i;
        int otherSize;
        DifferenceTableModel differences = new DifferenceTableModel("compare.description", this.toString(), other.toString());
        Vector thisBlocks = this.getBlocks();
        Vector otherBlocks = other.getBlocks();
        int size = thisBlocks.size();
        if (size != (otherSize = otherBlocks.size())) {
            differences.add(Language.getString("compare.blockCount", "Number of used Blocks"), Integer.toString(size), Integer.toString(otherSize));
        }
        HashMap<String, Block> dict = new HashMap<String, Block>();
        for (i = 0; i < otherSize; ++i) {
            block = (Block)otherBlocks.elementAt(i);
            dict.put(block.getNumberString(), block);
        }
        for (i = 0; i < thisBlocks.size(); ++i) {
            block = (Block)thisBlocks.elementAt(i);
            Block otherBlock = (Block)dict.get(block.getNumberString());
            if (otherBlock != null) {
                block.compareTo(otherBlock, differences);
                dict.remove(block.getNumberString());
                continue;
            }
            String[] str = new String[]{block.getNumberString(), "", Language.getString("compare.notFound", "not found")};
            Object[] o = new Object[]{block, null};
            differences.add(str, o);
        }
        Iterator iter = dict.entrySet().iterator();
        while (iter.hasNext()) {
            block = (Block)iter.next().getValue();
            String[] str = new String[]{block.getNumberString(), Language.getString("compare.notFound", "not found"), ""};
            Object[] o = new Object[]{null, block};
            differences.add(str, o);
        }
        return differences;
    }

    public DifferenceTableModel compareLogicalTo(WiringDiagram other) {
        DifferenceTableModel differences = new DifferenceTableModel("compare.description", this.toString(), other.toString());
        ArrayList thisBlocks = this.getEndBlocks();
        ArrayList otherBlocks = other.getEndBlocks();
        if (this.getHardware().getClass() != other.getHardware().getClass()) {
            differences.add(Language.getString("compare.differentHardware", "Device"), this.getHardware().getLocalizedName(true), other.getHardware().getLocalizedName(true));
        }
        new ComparatorWiringDiagram().compareTo(thisBlocks, otherBlocks, differences);
        return differences;
    }

    public ArrayList getEndBlocks() {
        Enumeration blockEnum = this.getBlocks().elements();
        ArrayList<Block> retValue = new ArrayList<Block>();
        while (blockEnum.hasMoreElements()) {
            Block block = (Block)blockEnum.nextElement();
            if (block.isRightTerminal()) {
                retValue.add(block);
                continue;
            }
            OutBlockConnector[] outConnectors = block.getOutConnectors();
            for (int i = 0; i < outConnectors.length; ++i) {
                if (outConnectors[i].getLinkedConnectorsCount() != 0) continue;
                retValue.add(block);
            }
        }
        return retValue;
    }

    public Block getBlockByNumber(int numberType, int blockNumber) {
        for (Block block : this.fBlockVector) {
            if (block.getNumberType() != numberType || block.getNumber() != blockNumber) continue;
            return block;
        }
        return null;
    }

    public Block getBlockByNumberExt(int numberType, int blockNumber) {
        return this.getBlockByNumber(numberType, blockNumber);
    }

    public Object[] getBlockNumberList(int blockType) {
        Vector<String> ret = new Vector<String>();
        String typePrefix = blockType == 6 ? "I" : (blockType == 7 ? "Q" : (blockType == 11 ? "AI" : "?"));
        for (int i = 1; i <= this.getHardware().getMaxResource(blockType); ++i) {
            if (this.getBlockByNumberExt(blockType, i) == null) continue;
            ret.addElement(typePrefix + i);
        }
        return ret.toArray();
    }
}

