/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import java.io.IOException;
import java.io.Serializable;

public abstract class TimeUnit
implements Serializable,
Storable,
Cloneable {
    static final long serialVersionUID = 0L;
    private int timeUnitSerializedDataVersion = 1;
    public static String UNIT_KEY = "";
    protected long fTime = 0L;
    protected int fHighMin = 0;
    protected int fHighMax = 99;
    protected int fHighInc = 1;
    protected int fLowMin = 0;
    protected int fLowMax = 59;
    protected int fLowInc = 1;

    public String getUnitString() {
        return UNIT_KEY;
    }

    public abstract String getDefaultUnitString();

    public abstract IntValueProperties getHigh();

    public abstract int getHighValue();

    public static TimeUnit timeUnitSub(TimeUnit t1, TimeUnit t2) {
        if (t1 == null || t2 == null || !t1.getUnitKey().equals(t2.getUnitKey())) {
            throw new UnsupportedOperationException();
        }
        TimeUnit ret = TimeUnit.getNewTimeObject(t1.getUnitKey());
        if (t1.getMilliseconds() > t2.getMilliseconds()) {
            int high = t1.getHighValue() - t2.getHighValue();
            int low = t1.getLowValue() - t2.getLowValue();
            if (low < 0) {
                --high;
                low += t1.getLow().getMax() + 1;
            }
            ret.setTime(high, low);
        }
        return ret;
    }

    public boolean isNoLossConvertibleTo(TimeUnit timeUnit) {
        return this.getClass().equals(timeUnit.getClass());
    }

    public abstract int[] getLogoTime();

    public abstract IntValueProperties getLow();

    public abstract int getLowValue();

    public long getMilliseconds() {
        return this.fTime;
    }

    public static TimeUnit getNewTimeObject(String key) {
        if (key.equals("dialog.timeParameter.seconds")) {
            return new Seconds();
        }
        if (key.equals("dialog.timeParameter.minutes")) {
            return new Minutes();
        }
        if (key.equals("dialog.timeParameter.hours")) {
            return new Hours();
        }
        if (key.equals("dialog.timeParameter.months")) {
            return new Months();
        }
        if (key.equals("dialog.timeParameter.highResolutionSeconds")) {
            return new HighResolutionSeconds();
        }
        if (key.startsWith("dialog.timeParameter.unlimitedHours")) {
            try {
                int highMax = new Integer(key.substring("dialog.timeParameter.unlimitedHours".length() + 1));
                return new UnlimitedHours(highMax);
            }
            catch (Exception e) {
                System.out.println("failed to create unlimited hours object.");
                return null;
            }
        }
        return null;
    }

    public String getTimeAsString() {
        if (this.getHighValue() < 0 || this.getLowValue() < 0) {
            return "Error ";
        }
        String high = String.valueOf(this.getHighValue());
        String low = String.valueOf(this.getLowValue());
        if (high.length() < 2) {
            high = "0" + high;
        }
        if (low.length() < 2) {
            low = "0" + low;
        }
        return high + ":" + low + this.getUnitAbbreviation();
    }

    public String getTimeAsStringLong() {
        String high = String.valueOf(this.getHighValue());
        String low = String.valueOf(this.getLowValue());
        if (high.length() < 2) {
            high = "0" + high;
        }
        if (low.length() < 2) {
            low = "0" + low;
        }
        return high + ":" + low + " " + Language.getString(this.getUnitKey(), this.getDefaultUnitString());
    }

    public abstract String getUnitAbbreviation();

    public abstract String getUnitKey();

    public abstract String getLowValueUnitKey();

    public abstract String getLowValueUnitAbbreviation();

    public void read(StorableInput dr) throws IOException {
        this.fTime = dr.readLong();
        this.fHighMin = dr.readInt();
        this.fHighMax = dr.readInt();
        this.fHighInc = dr.readInt();
        this.fLowMin = dr.readInt();
        this.fLowMax = dr.readInt();
        this.fLowInc = dr.readInt();
    }

    public void setHighMax(int max) {
        this.fHighMax = max;
    }

    public void setHighMin(int min) {
        this.fHighMin = min;
    }

    public void setLowMax(int max) {
        this.fLowMax = max;
    }

    public void setLowMin(int min) {
        this.fLowMin = min;
        if (this.getMilliseconds() < (long)(min * 60 * 1000)) {
            this.setMilliseconds(this.fLowMin * 60 * 1000);
        }
    }

    public void setMilliseconds(long ms) {
        this.fTime = ms;
    }

    public TimeUnit convertTo(TimeUnit timeUnit) {
        TimeUnit newUnit = TimeUnit.getNewTimeObject(timeUnit.getUnitKey());
        newUnit.setMilliseconds(this.getMilliseconds());
        return newUnit;
    }

    public abstract void setTime(int var1, int var2);

    public abstract TimeUnit setTime(int var1);

    public String toString() {
        return this.getParameterText();
    }

    public void write(StorableOutput dw) {
        dw.writeLong(this.fTime);
        dw.writeInt(this.fHighMin);
        dw.writeInt(this.fHighMax);
        dw.writeInt(this.fHighInc);
        dw.writeInt(this.fLowMin);
        dw.writeInt(this.fLowMax);
        dw.writeInt(this.fLowInc);
    }

    public String getParameterText() {
        return this.getTimeAsString();
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

