/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.io.IOException;
import java.util.List;

public class StairsSwitchParameter
extends TimeProtectionParameter {
    static final long serialVersionUID = 6541934361505654473L;
    private int serializedDataVersion = 1;
    private transient Timer fHelpTimer;
    private Timer fWarningTimer;
    private Timer fTimerToWarning;
    private transient String fExtension;
    private static final String EXTENSION_DEFAULT = "default";
    private static final String EXTENSION_UDF_WARNING = "0BA4";
    private static final int RUNNING_WARNING = 100;
    private static final int RUNNING_END = 200;

    public StairsSwitchParameter() {
    }

    public StairsSwitchParameter(Block block) {
        super(block);
        this.fParameter = 1;
        this.fData = 1;
        this.fAllocatedTimer = 1;
        this.getTimer().setParamTime(0, 0, "dialog.timeParameter.minutes");
        this.setParameterNameKeys();
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (this.getExtension() == EXTENSION_UDF_WARNING) {
            buffer.append("\n").append(this.getTimeToWarning().getParameterText()).append("\n").append(this.getWarningTime().getParameterText());
        }
        return buffer.toString();
    }

    private String getExtension() {
        if (this.fExtension == null) {
            try {
                this.fExtension = this.getBlock().getWiringDiagram().getHardware().supports("stairsSwitchWarning") ? EXTENSION_UDF_WARNING : EXTENSION_DEFAULT;
            }
            catch (NullPointerException e) {
                this.fExtension = EXTENSION_DEFAULT;
            }
        }
        return this.fExtension;
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if ((this.getParamTime().isReference() || this.fWarningTimer != null && this.getWarningTimeParam().isReference() || this.fTimerToWarning != null && this.getTimeParamToWarning().isReference()) && !hw.supports("StairsSwitch_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hw.getLocalizedPath() + hw.getLocalizedName()), hw));
            result &= false;
        }
        if (this.fTimerToWarning != null && !this.isDefaultWarningUsed() && !hw.supports("stairsSwitchWarning")) {
            errorList.add(new ErrorInfo(this, "error.convert.stairsSwitch.warning", hw));
            result &= false;
        }
        return result;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        this.fExtension = newHardware.supports("stairsSwitchWarning") ? EXTENSION_UDF_WARNING : EXTENSION_DEFAULT;
    }

    public boolean isDefaultWarningUsed() {
        TimeUnit paramTime = this.getTimer().getParamTime();
        boolean warningTimeIsDefault = this.getWarningTime().getMilliseconds() == this.getDefaultWarningTime(paramTime).getMilliseconds();
        boolean timeToWarningIsDefault = this.getTimeToWarning().getMilliseconds() == this.getDefaultTimeToWarning(paramTime).getMilliseconds();
        return warningTimeIsDefault && timeToWarningIsDefault;
    }

    public TimeUnit getWarningTimeRest() {
        if (this.fState == 100) {
            return this.getHelpTimer().getRemainingTimeForShowing();
        }
        TimeUnit ret = this.getWarningTimer().getRemainingTime();
        ret.setMilliseconds(0L);
        return ret;
    }

    public TimeUnit getTimeParamToWarningRest() {
        if (this.fState == 200 || this.fState == 100) {
            return this.getTimer().getRemainingTimeForShowing();
        }
        TimeUnit ret = this.getTimerToWarning().getRemainingTime();
        ret.setMilliseconds(0L);
        return ret;
    }

    public TimeUnit getRestTime() {
        if (this.fState == 1 || this.fState == 2 || this.fState == 100 || this.fState == 200) {
            return this.getTimer().getRemainingTimeForShowing();
        }
        return TimeUnit.getNewTimeObject(this.getTimer().getParamTime().getUnitKey());
    }

    private Timer getHelpTimer() {
        if (this.fHelpTimer == null) {
            this.fHelpTimer = new Timer();
        }
        return this.fHelpTimer;
    }

    public TimeUnit getTimeToWarning() {
        return this.getTimerToWarning().getParamTime();
    }

    public TimeValueProperties getTimeParamToWarning() {
        return this.getTimerToWarning().getParamTimeProperties();
    }

    public void setTimeParamToWarning(TimeValueProperties newTimer) {
        this.getTimerToWarning().setParamTimeProperties(newTimer);
    }

    public Timer getTimerToWarning() {
        if (this.fTimerToWarning == null) {
            TimeUnit[] timeUnits = (TimeUnit[])this.getBlock().getWiringDiagram().getHardware().getProperty("availableTimeUnits");
            this.fTimerToWarning = new Timer(timeUnits[timeUnits.length - 1]);
            this.fTimerToWarning.setParamTime(this.getDefaultTimeToWarning(this.getTimer().getParamTime()));
        }
        return this.fTimerToWarning;
    }

    public TimeUnit getDefaultTimeToWarning(TimeUnit basis) {
        TimeUnit result = this.getDefaultWarningTime(basis);
        result.setMilliseconds(result.getMilliseconds() * 15L);
        return result;
    }

    private TimeUnit getTimeToWarningFromStart() {
        TimeUnit result = TimeUnit.getNewTimeObject(this.getTimeToWarning().getUnitKey());
        long offTime = this.getTimer().getParamTime().getMilliseconds();
        long time = offTime - this.getTimeToWarning().getMilliseconds();
        if (time < 0L) {
            result.setMilliseconds(0L);
        } else {
            result.setMilliseconds(time);
        }
        return result;
    }

    public void setTimeToWarning(TimeUnit timeToWarning) {
        this.getTimerToWarning().setParamTime(timeToWarning);
    }

    public boolean getValue(boolean trg) {
        boolean result = false;
        switch (this.fState) {
            case 0: {
                if (!trg) break;
                this.getHelpTimer().setParamTime(this.getTimeToWarningFromStart());
                this.fState = 1;
                result = true;
                break;
            }
            case 1: {
                if (!trg) {
                    this.getTimer().start();
                    this.getHelpTimer().start();
                    this.fState = 2;
                }
                result = true;
                break;
            }
            case 2: {
                if (!trg) {
                    if (this.getHelpTimer().isFinished()) {
                        this.getHelpTimer().setParamTime(this.getWarningTime());
                        this.getHelpTimer().start();
                        this.fState = 100;
                        break;
                    }
                    if (this.getTimer().isFinished()) {
                        this.fState = 0;
                    }
                    result = true;
                    break;
                }
                this.fState = 1;
                result = true;
                break;
            }
            case 100: {
                if (!trg) {
                    if (!this.getHelpTimer().isFinished()) break;
                    result = true;
                    this.fState = 200;
                    break;
                }
                this.fState = 0;
                result = true;
                break;
            }
            case 200: {
                if (!trg) {
                    if (this.getTimer().isFinished()) {
                        this.fState = 0;
                        break;
                    }
                    result = true;
                    break;
                }
                this.fState = 0;
                result = true;
            }
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public TimeUnit getWarningTime() {
        return this.getWarningTimer().getParamTime();
    }

    public TimeValueProperties getWarningTimeParam() {
        return this.getWarningTimer().getParamTimeProperties();
    }

    public void setWarningTimeParam(TimeValueProperties newTimer) {
        this.getWarningTimer().setParamTimeProperties(newTimer);
    }

    public Timer getWarningTimer() {
        if (this.fWarningTimer == null) {
            this.fWarningTimer = new Timer();
            this.fWarningTimer.setParamTime(this.getDefaultWarningTime(this.getTimer().getParamTime()));
        }
        return this.fWarningTimer;
    }

    public TimeUnit getDefaultWarningTime(TimeUnit basis) {
        int lowValue = 1;
        if (basis.getClass() == Seconds.class || basis.getClass() == HighResolutionSeconds.class) {
            lowValue = 5;
        }
        TimeUnit result = TimeUnit.getNewTimeObject(basis.getUnitKey());
        result.setTime(0, lowValue);
        return result;
    }

    public void setWarningTime(TimeUnit warningTime) {
        this.getWarningTimer().setParamTime(warningTime);
    }

    protected void setParameterNameKeys() {
        this.getTimer().setNameKey("block.OffDelay");
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.getHelpTimer().init(interpreter);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fTimerToWarning);
        dw.writeStorable(this.fWarningTimer);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fTimerToWarning = (Timer)dr.readStorable();
        this.fWarningTimer = (Timer)dr.readStorable();
    }
}

