/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Interpreter;
import java.io.IOException;

public class ShiftRegisterParameter
extends BlockParameter {
    static final long serialVersionUID = 5275992679348271799L;
    private int blockSerializedDataVersion = 1;
    private int fOutputBit;
    private transient boolean fTrgInputLastCycle;

    public ShiftRegisterParameter() {
    }

    public ShiftRegisterParameter(Block block) {
        super(block);
        this.setRemanenceAvailable(true);
    }

    protected boolean calculateValue(boolean in, boolean trg, boolean dir) {
        byte shiftRegister = this.fInterpreter.getShiftRegisterValue();
        if (!this.fTrgInputLastCycle && trg) {
            this.fTrgInputLastCycle = true;
            if (dir) {
                shiftRegister = (byte)(shiftRegister >> 1);
                shiftRegister = in ? (byte)(shiftRegister | 0x80) : (byte)(shiftRegister & 0xFFFFFF7F);
            } else {
                shiftRegister = (byte)(shiftRegister << 1);
                shiftRegister = in ? (byte)(shiftRegister | 1) : (byte)(shiftRegister & 0xFFFFFFFE);
            }
            this.fInterpreter.setShiftRegisterValue(shiftRegister);
        } else if (this.fTrgInputLastCycle && !trg) {
            this.fTrgInputLastCycle = false;
        }
        return (shiftRegister & 1 << this.fOutputBit) != 0;
    }

    public boolean getValue(boolean in, boolean trg, boolean dir) {
        boolean rw = this.calculateValue(in, trg, dir);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return rw;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOutputBit = dr.readInt();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fOutputBit);
    }

    public int getOutputBit() {
        return this.fOutputBit;
    }

    public void setOutputBit(int outputBit) {
        this.fOutputBit = outputBit;
    }

    public String getParameterText() {
        String text = super.getParameterText();
        return "Q=S" + (this.getOutputBit() + 1) + "\n" + text;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.fTrgInputLastCycle = false;
            interpreter.setShiftRegisterValue((byte)0);
        }
    }
}

