/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.Logo2;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItemTableLogo3;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;

public class LogoProm
extends Logo2 {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected int fFirmwareIDAdress;

    public void downloadFirmwareID(DataTransfer dt, int firmwareID) throws ExceptionAlreadyHandledException {
        boolean tryAgain = false;
        do {
            tryAgain = false;
            try {
                dt.writeByte(this.fFirmwareIDAdress, (firmwareID & 0xFF00) >> 8);
                dt.writeNextByte(firmwareID & 0xFF);
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
    }

    public int getID() {
        return 2;
    }

    public int getOrder() {
        return 9990;
    }

    protected static Dictionary getSystemInfo() {
        Hashtable<String, Object> dict = new Hashtable<String, Object>(20);
        String[][] sArr = new String[][]{{"Constant", "Input", "Output", "Marker", "High", "Low", "AnalogInput"}, {"Base", "And", "Or", "Not", "Xor", "Nand", "Nor", "PecAnd", "PecNand"}, {"Special", "OnDelay", "OffDelay", "PulseRelay", "Clock", "LatchingRelay", "SymPulseGenerator", "RetentiveOnDelay", "Counter", "HoursCounter", "WipingRelay", "Trigger", "AsymPulseGenerator", "YearClock", "OnOffDelay", "Random", "StairsSwitch", "ComfortSwitch", "WipingRelayPEC", "Message", "AnalogTrigger", "AnalogComparator", "Softkey"}};
        dict.put("knownBlocks", sArr);
        int[] iArr = new int[]{56, 27, 15, 48, 16, 58, 24, 16, 0, 0, 8, 8, 5};
        dict.put("maxValues", iArr);
        TimeUnit[] availableTimeUnits = new TimeUnit[]{new Hours(), new Minutes(), new Seconds()};
        dict.put("availableTimeUnits", availableTimeUnits);
        dict.put("longCounter", Boolean.TRUE);
        dict.put("asymPulseWithDifferentTimeUnits", Boolean.TRUE);
        dict.put("anyDayClock", Boolean.TRUE);
        dict.put("readFunctionParameter", Boolean.TRUE);
        dict.put("messageBlockWithReceipt", Boolean.TRUE);
        dict.put("parameterItemTable", new ParameterItemTableLogo3());
        dict.put("displayWidth", new Integer(10));
        dict.put("msgPrioCount", new Integer(10));
        dict.put("prgName", Boolean.TRUE);
        return dict;
    }

    public Hardware prepareDownload(DataTransfer dt, WiringDiagram wd) throws ProgramException, ExceptionAlreadyHandledException {
        String s;
        Logo targetHardware = (Logo)wd.getHardware();
        int firmwareID = 255;
        int minOrder = this.getMinHardware().getOrder();
        int maxOrder = this.getMaxHardware().getOrder();
        int targetOrder = targetHardware.getOrder();
        if (targetOrder > maxOrder || targetHardware.getName().equals("Unknown")) {
            Hardware[] suitableHW = wd.getSuitableHardware(new ArrayList());
            int i = 0;
            do {
                targetHardware = (Logo)suitableHW[i++];
                targetOrder = targetHardware.getOrder();
            } while (i < suitableHW.length && (targetOrder < minOrder || targetOrder > maxOrder));
        }
        if (targetOrder < minOrder || targetOrder > maxOrder) {
            targetHardware = (Logo)wd.getHardware();
            s = targetHardware.getLocalizedPath() + targetHardware.getLocalizedName();
            throw new ProgramException(Language.getString("error.prom.deviceNotSupported", "Prommer doesn't handle %", s));
        }
        firmwareID = targetHardware.getFirmwareID();
        targetHardware.prepareDownload(dt, wd);
        this.fFirmwareIDAdress = targetHardware.getAdress(Logo.ADR_FIRMWARE_ID);
        this.downloadFirmwareID(dt, firmwareID);
        s = targetHardware.getLocalizedPath() + targetHardware.getLocalizedName();
        Log.println(Language.getString("msg.moduleForHardware", "Module for %", s));
        return targetHardware;
    }

    protected Hardware getMinHardware() throws ProgramException {
        try {
            return (Hardware)Class.forName("DE.siemens.ad.logo.model.hardware.Basic1").newInstance();
        }
        catch (Exception e) {
            throw new ProgramException("LogoProm.getMinHardware();  No Basic1-class available.");
        }
    }

    protected Hardware getMaxHardware() throws ProgramException {
        try {
            return (Hardware)Class.forName("DE.siemens.ad.logo.model.hardware.Modular0").newInstance();
        }
        catch (Exception e) {
            throw new ProgramException("LogoProm.getMaxHardware(); No Modular0-class available.");
        }
    }

    static {
        cSystemInfoDict.put("LogoProm", LogoProm.getSystemInfo());
    }
}

