/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.LogoProm;
import DE.siemens.ad.logo.model.LogoProm1;
import DE.siemens.ad.logo.util.CodeBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.Version;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class LogoHardwareFactory
extends HardwareFactory {
    private final String[] fResourceNames = new String[]{"ProgramLines", "RAM", "REM", "Parameter", "Timer", "Stack", "DigitalInput", "DigitalOutput", "DigitalInputASi", "DigitalOutputASi", "Marker", "AnalogInput", "MessageBox", "AnalogOutput", "ProgramMemory", "Blocknames", "AnalogMarker", "KeyInput", "ShiftRegister", "ShiftRegisterInput", "VirtualOutput", "TDFunctionKeyInput"};
    private static transient Hardware[] fHardwareClasses;
    private static transient Hashtable fHardwarePool;
    private static final String TEST_CLASS_SUFFIX = "Test.class";

    public Hardware createInstance() {
        Hardware result = null;
        String defaultHardware = LogoProperties.instance().getProperty("hardware", "");
        if (defaultHardware.equals("")) {
            result = this.getMaxHardware();
        } else {
            try {
                result = this.createInstance(defaultHardware);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                result = this.getMaxHardware();
            }
        }
        return result;
    }

    public Hardware createInstance(String hardwareName) throws IllegalArgumentException {
        if (hardwareName.equals("")) {
            return this.createInstance();
        }
        if (fHardwarePool.containsKey(hardwareName)) {
            return (Hardware)fHardwarePool.get(hardwareName);
        }
        String className = "DE.siemens.ad.logo.model.hardware." + hardwareName;
        try {
            Class<?> cl = Class.forName(className);
            Hardware hardware = (Hardware)cl.newInstance();
            fHardwarePool.put(hardwareName, hardware);
            return hardware;
        }
        catch (NoSuchMethodError e) {
            throw new IllegalArgumentException("Class " + className + " does not seem to have a no-arg constructor");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No class: " + className);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate: " + className);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class (" + className + ") not accessible");
        }
    }

    public Hardware[] getAvailableHardware() {
        if (fHardwareClasses == null) {
            Collection hwNames = this.getNames();
            Version v = Version.getCurrentVersion();
            if (!v.getApplicationFileName().equalsIgnoreCase("LOGOComfort")) {
                hwNames.remove("Logo6");
            }
            Hardware[] result = new Hardware[hwNames.size()];
            HardwareFactory hwFactory = HardwareFactory.getInstance();
            Iterator hardwareIterator = hwNames.iterator();
            int i = 0;
            while (hardwareIterator.hasNext()) {
                String hwName = (String)hardwareIterator.next();
                try {
                    result[i++] = hwFactory.createInstance(hwName);
                }
                catch (IOException e) {
                    Log.println(Language.getString("error.model.hardware.create", "Cannot create Hardware ") + hwName);
                }
            }
            fHardwareClasses = this.sort(result);
        }
        return fHardwareClasses;
    }

    public Collection getNames() {
        HashSet hardware = new HashSet();
        hardware.addAll(LogoHardwareFactory.getNamesFromJar());
        hardware.addAll(LogoHardwareFactory.getNamesFromDirectory());
        return hardware;
    }

    public String[] getResourceNames() {
        return this.fResourceNames;
    }

    private static Vector getNamesFromDirectory() {
        Vector<String> result = new Vector<String>();
        try {
            String hwPath = Class.class.getResource("/" + "DE.siemens.ad.logo.model.hardware.".replace('.', '/')).getFile();
            int index = hwPath.indexOf("%20");
            while (index > -1) {
                hwPath = hwPath.replace('%', ' ');
                hwPath = hwPath.substring(0, index + 1) + hwPath.substring(index + 3);
                index = hwPath.indexOf("%20");
            }
            File directory = new File(hwPath);
            String[] classNames = directory.list();
            if (classNames != null) {
                for (int i = 0; i < classNames.length; ++i) {
                    if (!classNames[i].endsWith(".class") || classNames[i].indexOf(36) >= 0 || classNames[i].endsWith(TEST_CLASS_SUFFIX)) continue;
                    StringTokenizer strTok = new StringTokenizer(classNames[i], ".");
                    String className = strTok.nextToken();
                    result.addElement(className);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Fehler beim lesen der Blocknamen aus dem Directory: " + e);
        }
        return result;
    }

    private static Vector getNamesFromJar() {
        Vector<String> result = new Vector<String>();
        try {
            String hardwarePath = "DE.siemens.ad.logo.model.hardware.".replace('.', '/');
            URL jarFileUrl = Class.class.getResource("/classes.jar");
            if (jarFileUrl == null) {
                jarFileUrl = Class.class.getResource("/comfort.jar");
            }
            if (jarFileUrl != null) {
                JarEntry jarEntry;
                JarInputStream classesInputStream = new JarInputStream(new BufferedInputStream(jarFileUrl.openStream()));
                String entryName = null;
                while ((jarEntry = classesInputStream.getNextJarEntry()) != null) {
                    entryName = jarEntry.getName();
                    if (!entryName.startsWith(hardwarePath) || !entryName.endsWith(".class") || entryName.indexOf(36) >= 0 || entryName.endsWith(TEST_CLASS_SUFFIX)) continue;
                    String className = entryName.substring(entryName.lastIndexOf("/") + 1, entryName.lastIndexOf("."));
                    result.addElement(className);
                }
            }
        }
        catch (Exception ioe) {
            System.out.println("Warning: Lesen der Hardware aus .jar-File nicht m\u00f6glich: " + ioe);
        }
        return result;
    }

    public Hardware getHardware(int hardwareID) {
        Hardware retValue = null;
        LogoProm prommer = new LogoProm();
        LogoProm1 prommer1 = new LogoProm1();
        if (hardwareID == prommer.getID()) {
            retValue = prommer;
        } else if (hardwareID == prommer1.getID()) {
            retValue = prommer1;
        } else {
            Hardware[] knownHardware = this.getAvailableHardware();
            int foundHardwareID = 0;
            for (int i = 0; i < knownHardware.length; ++i) {
                foundHardwareID = knownHardware[i].getID();
                if (hardwareID != foundHardwareID) continue;
                try {
                    retValue = this.createInstance(knownHardware[i].getName());
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Internal Error! Hardware.getHardware(int)");
                }
                break;
            }
            if (retValue == null) {
                try {
                    retValue = (Hardware)new CodeBlock("DE.siemens.ad.logo.model.hardware.Unknown").execConstructor();
                }
                catch (NoSuchMethodException e) {
                    Log.error(e, "Wrong classdescription or no Constructor in class: Unknown");
                }
            }
        }
        return retValue;
    }

    public static final Hardware getHardwareFromFirmwareID(int firmwareID) {
        Hardware retValue = null;
        Hardware[] knownHardware = HardwareFactory.getInstance().getAvailableHardware();
        int foundFirmwareID = 0;
        for (int i = 0; i < knownHardware.length; ++i) {
            Logo hw = (Logo)knownHardware[i];
            try {
                foundFirmwareID = hw.getFirmwareID();
            }
            catch (UnsupportedOperationException e) {
                Log.error(e, "Missing class or method getFirmwareID() in class: " + hw);
                e.printStackTrace();
            }
            if (firmwareID != foundFirmwareID) continue;
            retValue = hw;
            break;
        }
        if (retValue == null) {
            try {
                retValue = (Hardware)new CodeBlock("DE.siemens.ad.logo.model.hardware.Unknown").execConstructor();
            }
            catch (NoSuchMethodException e) {
                Log.error(e, "Wrong classdescription or no Constructor in class: Unknown");
            }
        }
        return retValue;
    }

    static {
        fHardwarePool = new Hashtable();
    }
}

