/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.InterpreterListener;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.StateMachine;
import java.util.ArrayList;
import java.util.List;

public abstract class Interpreter {
    private byte fShiftRegisterValue;
    protected List fInterpreterListeners = null;
    protected WiringDiagram fWiringDiagram;
    protected int fCommand;
    protected StateMachine fStateMachine;

    public void addInterpreterListener(InterpreterListener listener) {
        if (!this.getInterpreterListeners().contains(listener)) {
            this.getInterpreterListeners().add(listener);
        }
    }

    public void removeInterpreterListener(InterpreterListener listener) {
        this.fInterpreterListeners.remove(listener);
    }

    protected void fireCycleFinishedEvent(boolean somethingChanged) {
        for (InterpreterListener interpreterListener : new ArrayList(this.getInterpreterListeners())) {
            interpreterListener.interpreterCycleFinished(somethingChanged);
        }
    }

    public List getInterpreterListeners() {
        if (this.fInterpreterListeners == null) {
            this.fInterpreterListeners = new ArrayList();
        }
        return this.fInterpreterListeners;
    }

    public abstract void prepareInterpreter();

    public abstract void start();

    public abstract long getCurrentSimulationClockTime();

    public abstract long getCurrentSimulationTimerTime();

    public StateMachine getStateMachine() {
        return this.fStateMachine;
    }

    public byte getShiftRegisterValue() {
        return this.fShiftRegisterValue;
    }

    public void setShiftRegisterValue(byte newValue) {
        this.fShiftRegisterValue = newValue;
    }
}

