/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InputNamesIfc;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class InputNamesManager
implements Serializable,
InputNamesIfc {
    static final long serialVersionUID = 6650271726113012551L;
    private int inputNamesManagerSerializedDataVersion = 1;
    protected Hashtable fHashtable;
    protected LogoDrawing drawing;

    public InputNamesManager(LogoDrawing drawing) {
        this.drawing = drawing;
        this.fHashtable = new Hashtable();
    }

    public InputNamesManager(LogoDrawing drawing, InputNamesManager source) {
        this(drawing);
        this.copyInputOutputNamesFrom(source);
    }

    public void copyInputOutputNamesFrom(InputNamesManager source) {
        Iterator iterator = source.getDefinedInputOutputNames();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.setInputName(key, source.getInputName(key));
        }
    }

    public LogoDrawing getDrawing() {
        return this.drawing;
    }

    public String getInputName(String ioPort) {
        String comment = (String)this.fHashtable.get(ioPort);
        if (comment == null) {
            return "";
        }
        return comment;
    }

    public Iterator getDefinedInputOutputNames() {
        return this.fHashtable.keySet().iterator();
    }

    public final String[] getInputNames() {
        Hardware currentHardware = this.getDrawing().getWiringDiagram().getHardware();
        Vector[] blockTypes = currentHardware.getAvailableBlocks();
        Vector<String> inputNames = new Vector<String>();
        for (int i = 0; i < blockTypes.length; ++i) {
            Enumeration e = blockTypes[i].elements();
            Block block = null;
            while (e.hasMoreElements()) {
                block = (Block)e.nextElement();
                if (!(block instanceof InputBlock)) continue;
                int resourceCount = currentHardware.getMaxResource(block.getNumberType());
                for (int j = 0; j < resourceCount; ++j) {
                    inputNames.add(block.getNumberString(j + 1));
                }
            }
        }
        Object[] inputNameArray = new String[inputNames.size()];
        inputNames.copyInto(inputNameArray);
        return inputNameArray;
    }

    public final String[] getMarkerNames() {
        Hardware currentHardware = this.getDrawing().getWiringDiagram().getHardware();
        Vector[] blockTypes = currentHardware.getAvailableBlocks();
        Vector<String> markerNames = new Vector<String>();
        for (int i = 0; i < blockTypes.length; ++i) {
            Enumeration e = blockTypes[i].elements();
            Block block = null;
            while (e.hasMoreElements()) {
                block = (Block)e.nextElement();
                if (!(block instanceof MarkerBlock)) continue;
                int resourceCount = currentHardware.getMaxResource(block.getNumberType());
                for (int j = 0; j < resourceCount; ++j) {
                    markerNames.add(new String(block.getNumberPrefix() + (j + 1)));
                }
            }
        }
        Object[] markerNameArray = new String[markerNames.size()];
        markerNames.copyInto(markerNameArray);
        return markerNameArray;
    }

    public final String[] getOutputNames() {
        Hardware currentHardware = this.getDrawing().getWiringDiagram().getHardware();
        Vector[] blockTypes = currentHardware.getAvailableBlocks();
        Vector<String> outputNames = new Vector<String>();
        for (int i = 0; i < blockTypes.length; ++i) {
            Enumeration e = blockTypes[i].elements();
            Block block = null;
            while (e.hasMoreElements()) {
                block = (Block)e.nextElement();
                if (!(block instanceof OutputBlock) || block instanceof MarkerBlock) continue;
                int resourceCount = currentHardware.getMaxResource(block.getNumberType());
                for (int j = 0; j < resourceCount; ++j) {
                    outputNames.add(new String(block.getNumberPrefix() + (j + 1)));
                }
            }
        }
        Object[] outputNameArray = new String[outputNames.size()];
        outputNames.copyInto(outputNameArray);
        return outputNameArray;
    }

    public void setDrawing(LogoDrawing newDrawing) {
        this.drawing = newDrawing;
    }

    public String setInputName(String ioPort, String inputName) {
        return this.fHashtable.put(ioPort, inputName);
    }
}

