/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.util.Calendar;

public class Hours
extends TimeUnit {
    static final long serialVersionUID = 0L;
    private int hoursSerializedDataVersion = 1;
    public static final String UNIT_KEY = "dialog.timeParameter.hours";
    public static final String DEFAULT_UNIT_STRING = "hours";
    public static final String UNIT_ABBREVIATION = "h";

    public Hours() {
    }

    public Hours(TimeUnit timeUnit) {
        this.setMilliseconds(timeUnit.getMilliseconds());
    }

    public String getDefaultUnitString() {
        return DEFAULT_UNIT_STRING;
    }

    public IntValueProperties getHigh() {
        return new IntValueProperties(this.fHighMin, this.fHighMax, this.fHighInc, this.getHighValue(), "error.dialog.invalidValue", "Invalid Value for hours.");
    }

    public int getHighValue() {
        int v = (int)(this.fTime / 3600000L);
        return v > this.fHighMax ? this.fHighMax : v;
    }

    public int[] getLogoTime() {
        int time = this.getHighValue() * 60 + this.getLowValue();
        int[] lTime = new int[]{time / 256 | 0xC0, time % 256};
        return lTime;
    }

    public IntValueProperties getLow() {
        return new IntValueProperties(this.fLowMin, this.fLowMax, this.fLowInc, this.getLowValue(), "error.dialog.invalidValue", "Invalid Value for minutes.");
    }

    public int getLowValue() {
        return (int)(this.fTime / 60000L % 60L);
    }

    public String getUnitAbbreviation() {
        return UNIT_ABBREVIATION;
    }

    public String getUnitKey() {
        return UNIT_KEY;
    }

    public Calendar overlay(Calendar currentTime) {
        Calendar overlayedTime = Calendar.getInstance(Language.getLocale());
        overlayedTime.setTime(currentTime.getTime());
        overlayedTime.set(11, this.getHighValue());
        overlayedTime.set(12, this.getLowValue());
        return overlayedTime;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
    }

    public void setTime(int high, int low) {
        this.fTime = (long)high * 1000L * 60L * 60L + (long)(low * 1000 * 60);
    }

    public TimeUnit setTime(int value) {
        int rangedValue = Util.getValueInRange(0, 5999, value);
        this.setTime(0, rangedValue);
        return this;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
    }

    public String getLowValueUnitKey() {
        return "dialog.timeParameter.minutes";
    }

    public String getLowValueUnitAbbreviation() {
        return "m";
    }
}

