/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.util.BlockEnumerator;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Link;
import DE.siemens.ad.logo.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ComparatorWiringDiagram {
    protected ArrayList fComparedBlocks = new ArrayList();

    public void compareTo(List sourceAnchor, List otherAnchor, DifferenceTableModel differences) {
        int size = sourceAnchor.size();
        int otherSize = otherAnchor.size();
        otherAnchor = new ArrayList(otherAnchor);
        for (int i = 0; i < size; ++i) {
            Block block = (Block)sourceAnchor.get(i);
            int index = Util.indexOf(otherAnchor, block);
            if (index > -1) {
                this.comparePath(block, (Block)otherAnchor.get(index), differences);
                otherAnchor.remove(index);
                continue;
            }
            String[] str = new String[]{block.getNumberString(), "", Language.getString("compare.notFound", "not found")};
            Object[] o = new Object[]{block, null};
            differences.add(str, o);
        }
        for (Block block : otherAnchor) {
            String[] str = new String[]{block.getNumberString(), Language.getString("compare.notFoundOrNoAnchor", "not found or no anchor"), ""};
            Object[] o = new Object[]{null, block};
            differences.add(str, o);
        }
    }

    private void comparePath(Block block, Block otherBlock, DifferenceTableModel differences) {
        if (!this.fComparedBlocks.contains(block)) {
            this.fComparedBlocks.add(block);
            boolean equal = block.compareTo(otherBlock, differences);
            if (equal || block.isCompatibel(otherBlock)) {
                this.compareConnections(block, otherBlock, differences);
            }
        }
    }

    private boolean compareConnections(Block block, Block otherBlock, DifferenceTableModel differences) {
        boolean result = true;
        InBlockConnector[] con1 = block.getInConnectors();
        if (con1 != null) {
            InBlockConnector[] con2 = otherBlock.getInConnectors();
            int min = con1.length;
            String diffMsg1 = "";
            String diffMsg2 = "";
            if (con1.length != con2.length) {
                InBlockConnector[] maxArr;
                int max;
                if (con1.length < con2.length) {
                    min = con1.length;
                    max = con2.length;
                    maxArr = con2;
                    diffMsg1 = Language.getString("compare.notFound", "not found");
                } else {
                    min = con2.length;
                    max = con1.length;
                    maxArr = con1;
                    diffMsg2 = Language.getString("compare.notFound", "not found");
                }
                StringBuffer buff = new StringBuffer();
                buff.append(block.getLocalizedName(true)).append(" - ").append(Language.getString("block.Input", "Input")).append(" ");
                for (int i = min; i < max; ++i) {
                    if (i > min) {
                        buff.append(", ");
                    }
                    buff.append(maxArr[i].getName());
                }
                String[] str = new String[]{buff.toString(), diffMsg1, diffMsg2};
                Object[] o = new Object[]{this, otherBlock};
                differences.add(str, o);
                result = false;
            }
            for (int i = 0; i < min; ++i) {
                ArrayList resultList = this.compareConnector(con1[i], con2[i], differences);
                ArrayList equal1 = (ArrayList)resultList.get(2);
                ArrayList equal2 = (ArrayList)resultList.get(3);
                if (otherBlock.getOutConnectorCount() > 0) {
                    this.compareDifferentPath1((ArrayList)resultList.get(0), otherBlock.getOutConnector(0), false, differences);
                }
                if (block.getOutConnectorCount() > 0) {
                    this.compareDifferentPath1((ArrayList)resultList.get(1), block.getOutConnector(0), true, differences);
                }
                int size = equal1.size() < equal2.size() ? equal1.size() : equal2.size();
                for (int j = 0; j < size; ++j) {
                    Block sourceBlock = ((OutBlockConnector)equal1.get(j)).getOwner();
                    this.comparePath(sourceBlock, ((OutBlockConnector)equal2.get(j)).getOwner(), differences);
                }
            }
        }
        return result;
    }

    private ArrayList compareConnector(InBlockConnector connector, InBlockConnector otherConnector, DifferenceTableModel differences) {
        ArrayList diffResult = new ArrayList();
        if (connector.isNegated() != otherConnector.isNegated()) {
            BlockConnector[] connectorArray = new BlockConnector[]{connector};
            BlockConnector[] otherConnectorArray = new BlockConnector[]{otherConnector};
            String[] str = new String[]{connector.getLocalizedName(true), this.translateNegated(connector.isNegated()), this.translateNegated(otherConnector.isNegated())};
            Object[] o = new Object[]{new Link(connectorArray, BlockConnector.class), new Link(otherConnectorArray, BlockConnector.class)};
            differences.add(str, o);
        }
        if (Util.getDifferences(connector.getLinkedConnectorsList(), otherConnector.getLinkedConnectorsList(), diffResult)) {
            BlockConnector[] connectorArray;
            BlockConnector[] line;
            Block block;
            BlockConnector linkedConnnector;
            String[] diffDescription = new String[3];
            Object[] diffLink = new Object[2];
            StringBuffer buffer = new StringBuffer();
            ArrayList<Link> linkList = new ArrayList<Link>();
            ArrayList<Link> otherLinkList = new ArrayList<Link>();
            buffer.append(connector.getOwner().getNumberString()).append(" ").append(Language.getString("compare.input", "Input")).append(" ").append(connector.getName() != null ? connector.getName() : Integer.toString(connector.getOwner().getInConnectorPosition(connector))).append(" - ").append(Language.getString("compare.connectionTo", "Connection to"));
            diffDescription[0] = buffer.toString();
            Iterator iter = ((ArrayList)diffResult.get(0)).iterator();
            buffer = new StringBuffer();
            while (iter.hasNext()) {
                linkedConnnector = (BlockConnector)iter.next();
                block = linkedConnnector.getOwner();
                buffer.append(",");
                buffer.append(block.getNumberString()).append(" [").append(Language.getString("block." + block.getName(), "")).append("]");
                line = new BlockConnector[]{connector, linkedConnnector};
                linkList.add(new Link(line, BlockConnector.class));
                connectorArray = new BlockConnector[]{otherConnector};
                otherLinkList.add(new Link(connectorArray, BlockConnector.class));
            }
            if (buffer.length() > 0) {
                diffDescription[1] = buffer.substring(1);
            }
            iter = ((ArrayList)diffResult.get(1)).iterator();
            buffer = new StringBuffer();
            while (iter.hasNext()) {
                linkedConnnector = (BlockConnector)iter.next();
                block = linkedConnnector.getOwner();
                buffer.append(",");
                buffer.append(block.getNumberString()).append(" [").append(Language.getString("block." + block.getName(), "")).append("]");
                line = new BlockConnector[]{otherConnector, linkedConnnector};
                otherLinkList.add(new Link(line, BlockConnector.class));
                connectorArray = new BlockConnector[]{connector};
                linkList.add(new Link(connectorArray, BlockConnector.class));
            }
            if (buffer.length() > 0) {
                diffDescription[2] = buffer.substring(1);
            }
            diffLink[0] = linkList;
            diffLink[1] = otherLinkList;
            differences.add(diffDescription, diffLink);
        }
        return diffResult;
    }

    private void compareDifferentPath(ArrayList outConnectorList1, ArrayList outConnectorList2, DifferenceTableModel differences) {
        Block block2;
        Block block1;
        OutBlockConnector result;
        Iterator outConnectors1 = outConnectorList1.iterator();
        Iterator outConnectors2 = outConnectorList2.iterator();
        ArrayList additionalBlocks = new ArrayList();
        while (outConnectors1.hasNext()) {
            OutBlockConnector connector1 = (OutBlockConnector)outConnectors1.next();
            while (outConnectors2.hasNext()) {
                OutBlockConnector connector2 = (OutBlockConnector)outConnectors2.next();
                result = this.find(connector1, connector2.getOwner().getOutConnector(0));
                if (result == null) continue;
                block1 = connector1.getOwner();
                block2 = result.getOwner();
                additionalBlocks = this.synchronisationPointFound(block1, block2, connector2, differences);
            }
        }
        this.putAdditionalBlocks(additionalBlocks, false, differences);
        outConnectors1 = outConnectorList1.iterator();
        outConnectors2 = outConnectorList2.iterator();
        additionalBlocks.clear();
        while (outConnectors2.hasNext()) {
            OutBlockConnector connector2 = (OutBlockConnector)outConnectors2.next();
            while (outConnectors1.hasNext()) {
                OutBlockConnector connector1 = (OutBlockConnector)outConnectors1.next();
                result = this.find(connector2, connector1.getOwner().getOutConnector(0));
                if (result == null) continue;
                block1 = result.getOwner();
                block2 = connector2.getOwner();
                additionalBlocks = this.synchronisationPointFound(block1, block2, connector1, differences);
            }
        }
        this.putAdditionalBlocks(additionalBlocks, true, differences);
    }

    private void compareDifferentPath1(ArrayList outConnectorList, OutBlockConnector startConnector, boolean startConnectorInSource, DifferenceTableModel differences) {
        Iterator outConnectors = outConnectorList.iterator();
        ArrayList additionalBlocks = new ArrayList();
        while (outConnectors.hasNext()) {
            Block block2;
            Block block1;
            OutBlockConnector connector = (OutBlockConnector)outConnectors.next();
            OutBlockConnector result = this.find(connector, startConnector);
            if (result == null) continue;
            if (startConnectorInSource) {
                block1 = result.getOwner();
                block2 = connector.getOwner();
            } else {
                block1 = connector.getOwner();
                block2 = result.getOwner();
            }
            additionalBlocks = this.synchronisationPointFound(block1, block2, startConnector, differences);
            this.putAdditionalBlocks(additionalBlocks, startConnectorInSource, differences);
        }
    }

    private ArrayList synchronisationPointFound(Block sourceBlock, Block otherBlock, OutBlockConnector startPoint, DifferenceTableModel differences) {
        ArrayList<Block> additionalBlocks = new ArrayList<Block>();
        this.comparePath(sourceBlock, otherBlock, differences);
        BlockEnumerator enumeration = new BlockEnumerator(startPoint.getOwner(), true);
        while (enumeration.hasMoreElements()) {
            Block element = (Block)enumeration.nextElement();
            if (!Util.containsEqual(this.fComparedBlocks, element)) {
                additionalBlocks.add(element);
            }
            this.fComparedBlocks.add(element);
        }
        return additionalBlocks;
    }

    private void putAdditionalBlocks(List additionalBlocks, boolean inSourceDiagram, DifferenceTableModel differences) {
        if (additionalBlocks.size() > 0) {
            String[] text = new String[3];
            text[0] = Language.getString("compare.additionalBlocks", "additional block(s)");
            Object[] links = new Object[2];
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = additionalBlocks.iterator();
            while (iterator.hasNext()) {
                buffer.append(((Block)iterator.next()).getNumberString());
                buffer.append(",");
            }
            if (inSourceDiagram) {
                text[1] = buffer.substring(0, buffer.length() - 1);
                text[2] = "";
                links[0] = additionalBlocks;
            } else {
                text[1] = "";
                text[2] = buffer.substring(0, buffer.length() - 1);
                links[1] = additionalBlocks;
            }
            differences.add(text, links);
        }
    }

    private OutBlockConnector find(OutBlockConnector searchConnector, OutBlockConnector startConnector) {
        InBlockConnector[] inConnectors = startConnector.getOwner().getInConnectors();
        if (inConnectors != null) {
            for (int i = 0; i < inConnectors.length; ++i) {
                OutBlockConnectorEnumeration enumeration = inConnectors[i].getLinkedConnectors();
                while (enumeration.hasMoreElements()) {
                    OutBlockConnector outConnector = enumeration.nextElement();
                    if (outConnector.isEqual(searchConnector)) {
                        return outConnector;
                    }
                    if (outConnector.getOwner().isRightTerminal()) {
                        return null;
                    }
                    if ((outConnector = this.find(searchConnector, outConnector)) == null) continue;
                    return outConnector;
                }
            }
        }
        return null;
    }

    private String translateNegated(boolean negated) {
        String key = negated ? "global.negated" : "global.notNegated";
        return Language.getString(key, key);
    }
}

