/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Time2ProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.io.IOException;
import java.util.List;

public class ComfortSwitchParameter
extends Time2ProtectionParameter {
    static final long serialVersionUID = 0L;
    private int serializedDataVersion = 1;
    private Timer fWarningTimer;
    private Timer fTimerToWarning;
    private transient Timer fHelpTimer;
    private transient String fExtension;
    private static final String EXTENSION_R_WARNING = "0BA4";
    private static final String EXTENSION_DEFAULT = "default";
    private static final int WAITING_RUN = 100;
    private static final int WAITING_READY = 200;
    private static final int RUN_WARNING = 300;

    public ComfortSwitchParameter() {
    }

    public ComfortSwitchParameter(Block block) {
        super(block);
        this.fParameter = 2;
        this.fData = 1;
        this.fAllocatedTimer = 1;
        this.setParameterNameKeys();
    }

    public TimeUnit getTimeParamToWarningRest() {
        if (this.fState == 300) {
            return this.fTimer.getRemainingTimeForShowing();
        }
        TimeUnit ret = this.getTimerToWarning().getRemainingTime();
        ret.setMilliseconds(0L);
        return ret;
    }

    public TimeUnit getWarningTimeRest() {
        if (this.fState == 300 && !this.fWarningTimer.isFinished()) {
            return this.fWarningTimer.getRemainingTimeForShowing();
        }
        TimeUnit ret = this.getWarningTimer().getRemainingTime();
        ret.setMilliseconds(0L);
        return ret;
    }

    public TimeUnit getRestTimeH() {
        if (this.fState == 1 || this.fState == 300) {
            return this.getHTimer().getRemainingTimeForShowing();
        }
        return TimeUnit.getNewTimeObject(this.getHTimer().getParamTime().getUnitKey());
    }

    public boolean calculateValue(boolean trg, boolean reset) {
        boolean result = false;
        if (reset) {
            this.fTimer.reset();
            this.fWarningTimer.reset();
            this.fHelpTimer.reset();
            this.fState = 0;
            return false;
        }
        switch (this.fState) {
            case 0: {
                if (!trg) break;
                this.fTimer = this.getLTimer();
                this.fTimer.start();
                this.fState = 2;
                result = true;
                break;
            }
            case 2: {
                if (!trg) {
                    this.fTimer = this.getHTimer();
                    this.fTimer.start();
                    this.fHelpTimer.setParamTime(this.getTimeToWarningFromStart());
                    this.fHelpTimer.start();
                    this.fState = 1;
                } else if (this.fTimer.isFinished()) {
                    this.fState = 100;
                    this.fTimer = this.getLTimer();
                    this.fTimer.finish();
                }
                result = true;
                break;
            }
            case 100: {
                if (!trg) {
                    this.fState = 3;
                }
                result = true;
                break;
            }
            case 3: {
                if (trg) {
                    this.fState = 200;
                }
                result = true;
                break;
            }
            case 200: {
                if (!trg) {
                    this.fState = 0;
                    this.fTimer.reset();
                }
                if (this.getExtension() == EXTENSION_R_WARNING) {
                    result = false;
                    break;
                }
                result = true;
                break;
            }
            case 1: {
                if (!trg) {
                    if (this.fTimer.isFinished()) {
                        this.fState = 0;
                        break;
                    }
                    if (this.fHelpTimer.isFinished()) {
                        this.fWarningTimer.start();
                        result = false;
                        this.fState = 300;
                        break;
                    }
                    result = true;
                    break;
                }
                this.fState = 200;
                this.fTimer.reset();
                break;
            }
            case 300: {
                if (!trg) {
                    if (this.fTimer.isFinished()) {
                        this.getHelpTimer().reset();
                        this.fWarningTimer.reset();
                        this.fState = 0;
                        break;
                    }
                    if (this.fWarningTimer.isFinished()) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                this.fState = 200;
                result = true;
                this.fTimer.reset();
                this.getHelpTimer().reset();
                this.fWarningTimer.reset();
            }
        }
        return result;
    }

    protected void setParameterNameKeys() {
        this.getHTimer().setNameKey("dialog.parameter.comfortSwitch.offTime");
        this.getLTimer().setNameKey("dialog.parameter.comfortSwitch.lightOn");
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (this.getExtension() == EXTENSION_R_WARNING) {
            buffer.append("\n").append(this.getTimerToWarning().getParamTime().getParameterText()).append("\n").append(this.getWarningTimer().getParamTime().getParameterText());
        }
        return buffer.toString();
    }

    private String getExtension() {
        if (this.fExtension == null) {
            try {
                if (this.getBlock().getWiringDiagram().getHardware().supports("comfortSwitchResetWarning")) {
                    this.fExtension = EXTENSION_R_WARNING;
                }
            }
            catch (NullPointerException e) {
                this.fExtension = EXTENSION_DEFAULT;
            }
        }
        return this.fExtension;
    }

    public Timer getTimerToWarning() {
        if (this.fTimerToWarning == null) {
            this.fTimerToWarning = new Timer();
        }
        return this.fTimerToWarning;
    }

    public TimeValueProperties getTimeToWarning() {
        return this.getTimerToWarning().getParamTimeProperties();
    }

    private TimeUnit getTimeToWarningFromStart() {
        TimeUnit timeToWarning = this.getTimerToWarning().getParamTime();
        TimeUnit result = TimeUnit.getNewTimeObject(timeToWarning.getUnitKey());
        long offTime = this.getHTimer().getParamTime().getMilliseconds();
        long time = offTime - timeToWarning.getMilliseconds();
        if (time < 0L) {
            result.setMilliseconds(0L);
        } else {
            result.setMilliseconds(time);
        }
        return result;
    }

    public TimeValueProperties getWarningTime() {
        return this.getWarningTimer().getParamTimeProperties();
    }

    public Timer getWarningTimer() {
        if (this.fWarningTimer == null) {
            this.fWarningTimer = new Timer();
        }
        return this.fWarningTimer;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getHelpTimer().init(interpreter);
        this.getWarningTimer().init(interpreter);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.getWarningTimer().reset();
            this.getHelpTimer().reset();
        }
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if (!this.isDefaultWarningUsed() && !hw.supports("stairsSwitchWarning")) {
            errorList.add(new ErrorInfo(this, "error.convert.comfortSwitch.warning", hw));
            result &= false;
        }
        if ((this.getTimerToWarning().getParamTimeProperties().isReference() || this.getWarningTimer().getParamTimeProperties().isReference()) && !hw.supports("Time2Protection_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hw.getLocalizedPath() + hw.getLocalizedName()), hw));
            result &= false;
        }
        return result;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        if (newHardware.supports("comfortSwitchResetWarning")) {
            this.fExtension = EXTENSION_R_WARNING;
            TimeUnit[] availableTimeUnits = (TimeUnit[])newHardware.getProperty("availableTimeUnits");
            this.getTimerToWarning().convertTimerTo(availableTimeUnits);
            this.getWarningTimer().convertTimerTo(availableTimeUnits);
        } else {
            this.fExtension = EXTENSION_DEFAULT;
            this.fWarningTimer = null;
            this.fTimerToWarning = null;
        }
    }

    public boolean isDefaultWarningUsed() {
        boolean warningTimeIsDefault = !this.getWarningTimer().getParamTimeProperties().isReference() && this.getWarningTimer().getParamTime().getMilliseconds() == 0L;
        boolean timeToWarningIsDefault = !this.getTimerToWarning().getParamTimeProperties().isReference() && this.getTimerToWarning().getParamTime().getMilliseconds() == 0L;
        return warningTimeIsDefault && timeToWarningIsDefault;
    }

    public void setTimeToWarning(TimeValueProperties timeToWarning) {
        this.getTimerToWarning().setParamTimeProperties(timeToWarning);
    }

    public void setWarningTime(TimeValueProperties warningTime) {
        this.getWarningTimer().setParamTimeProperties(warningTime);
    }

    public Timer getHelpTimer() {
        if (this.fHelpTimer == null) {
            this.fHelpTimer = new Timer();
        }
        return this.fHelpTimer;
    }

    public void setHelpTimer(TimeUnit time) {
        this.getHelpTimer().setParamTime(time);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fTimerToWarning);
        dw.writeStorable(this.fWarningTimer);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fTimerToWarning = (Timer)dr.readStorable();
        this.fWarningTimer = (Timer)dr.readStorable();
    }
}

