/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.Date;

public class ClockParameter
extends ProtectionParameter
implements ParameterSetListener {
    static final long serialVersionUID = 3399891661912307306L;
    private int clockSerializedDataVersion = 1;
    protected CamParameter[] fCam;
    protected Calendar fLastSwitchTime;
    private boolean fPulse = false;
    protected Calendar fCurrentTime;

    public ClockParameter() {
        this.fCurrentTime = Calendar.getInstance(Language.getLocale());
        this.fLastSwitchTime = Calendar.getInstance(Language.getLocale());
    }

    public ClockParameter(Block block) {
        super(block);
        CamParameter[] cp = new CamParameter[]{new CamParameter(block), new CamParameter(block), new CamParameter(block)};
        this.fCam = cp;
        for (int i = 0; i < this.getCamCount(); ++i) {
            this.getCam(i).addParameterSetListener(this);
        }
        this.fCurrentTime = Calendar.getInstance(Language.getLocale());
        this.fLastSwitchTime = Calendar.getInstance(Language.getLocale());
        this.fParameter = 6;
        this.fData = 2;
        this.fAllocatedTimer = 0;
    }

    public CamParameter getCam(int index) {
        return this.fCam[index];
    }

    public final int getCamCount() {
        return this.fCam.length;
    }

    public String getParameterText() {
        String CRLF = "\n";
        StringBuffer buffer = new StringBuffer(200);
        boolean oneProtection = this.getBlock().getWiringDiagram().getHardware().supports("clockOneProtection");
        String cam0 = this.getCam(0).getParameterText();
        String cam1 = this.getCam(1).getParameterText();
        String cam2 = this.getCam(2).getParameterText();
        if (oneProtection) {
            buffer.append(this.getProtectionSign());
            buffer.append("\n");
        }
        buffer.append(cam0).append("\n").append(cam1).append("\n").append(cam2);
        if (this.getBlock().getHardware().supports("pulseClock")) {
            buffer.append("\nPulse=").append(this.fPulse ? "Y" : "N");
        }
        return buffer.toString();
    }

    public boolean getValue() {
        this.fCurrentTime.setTime(new Date(this.fInterpreter.getCurrentSimulationClockTime()));
        this.fLastSwitchTime.set(0, 0, 0, 0, 0, 0);
        boolean state = false;
        for (int i = 0; i < this.fCam.length; ++i) {
            this.fCam[i].setPulseMode(this.fPulse);
            int rw = this.fCam[i].getValue(this.fCurrentTime, this.fLastSwitchTime);
            if (rw == 1) {
                state = true;
                if (this.fPulse) break;
            }
            if (rw != 2) continue;
            state = false;
        }
        return state;
    }

    public void parameterSet(Parameter parameter, String newValue) {
        this.setProtection(this.getCommonProtection());
        this.fireParameterSetEvent();
    }

    public boolean getCommonProtection() {
        boolean protection = false;
        int count = this.getCamCount();
        for (int i = 0; i < count; ++i) {
            CamParameter cam = this.getCam(i);
            if (cam.getOnTime().isInactive() && cam.getOffTime().isInactive()) continue;
            protection = cam.getProtection();
            break;
        }
        return protection;
    }

    public void read(StorableInput dr) throws IOException {
        int i;
        super.read(dr);
        int count = dr.readInt();
        if (count > 0) {
            this.fCam = new CamParameter[count];
            for (i = 0; i < count; ++i) {
                this.fCam[i] = (CamParameter)dr.readStorable();
            }
        }
        for (i = 0; i < this.getCamCount(); ++i) {
            this.getCam(i).addParameterSetListener(this);
        }
        this.fPulse = dr.readBoolean();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.fRemanence != null) {
            this.fRemanence.setParameter(this);
        }
        for (int i = 0; i < this.getCamCount(); ++i) {
            this.getCam(i).addParameterSetListener(this);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fCam.length);
        for (int i = 0; i < this.fCam.length; ++i) {
            dw.writeStorable(this.fCam[i]);
        }
        dw.writeBoolean(this.fPulse);
    }

    public boolean compareTo(BlockParameter other, DifferenceTableModel differences) {
        boolean result = super.compareTo(other, differences);
        if (this.getClass() == other.getClass()) {
            int size = this.getCamCount();
            for (int i = 0; i < size; ++i) {
                CamParameter cam1 = this.getCam(i);
                CamParameter cam2 = ((ClockParameter)other).getCam(i);
                if (cam1.getProtection() == cam2.getProtection()) continue;
                String[] str = new String[]{new StringBuffer().append(this.getBlock().getNumberString()).append(" - ").append(Language.getString("compare.protection", "Protection")).append(" ").append(Language.getString("dialog.parameter.cam", "Cam")).append(i + 1).toString(), cam1.getProtectionSign(), cam2.getProtectionSign()};
                Object[] o = new Object[]{this.getBlock(), other.getBlock()};
                differences.add(str, o);
                result = false;
            }
        }
        return result;
    }

    public Mode getCam0Mode() {
        return this.getCam(0).getModeObject();
    }

    public void setCam0Mode(Mode newMode) {
        this.getCam(0).setLogoMode(newMode.getLogoMode());
    }

    public Mode getCam1Mode() {
        return this.getCam(1).getModeObject();
    }

    public void setCam1Mode(Mode newMode) {
        this.getCam(1).setLogoMode(newMode.getLogoMode());
    }

    public Mode getCam2Mode() {
        return this.getCam(2).getModeObject();
    }

    public void setCam2Mode(Mode newMode) {
        this.getCam(2).setLogoMode(newMode.getLogoMode());
    }

    public ClockHours getCam0On() {
        return this.getCam(0).getOnTime();
    }

    public void setCam0On(ClockHours newClockHours) {
        this.getCam(0).setOnTime(newClockHours);
    }

    public ClockHours getCam1On() {
        return this.getCam(1).getOnTime();
    }

    public void setCam1On(ClockHours newClockHours) {
        this.getCam(1).setOnTime(newClockHours);
    }

    public ClockHours getCam2On() {
        return this.getCam(2).getOnTime();
    }

    public void setCam2On(ClockHours newClockHours) {
        this.getCam(2).setOnTime(newClockHours);
    }

    public ClockHours getCam0Off() {
        return this.getCam(0).getOffTime();
    }

    public void setCam0Off(ClockHours newClockHours) {
        this.getCam(0).setOffTime(newClockHours);
    }

    public ClockHours getCam1Off() {
        return this.getCam(1).getOffTime();
    }

    public void setCam1Off(ClockHours newClockHours) {
        this.getCam(1).setOffTime(newClockHours);
    }

    public ClockHours getCam2Off() {
        return this.getCam(2).getOffTime();
    }

    public void setCam2Off(ClockHours newClockHours) {
        this.getCam(2).setOffTime(newClockHours);
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        for (int i = 0; i < this.getCamCount(); ++i) {
            this.getCam(i).init(interpreter, forceReset);
        }
    }

    public boolean getPulse() {
        return this.fPulse;
    }

    public void setPulse(boolean pulse) {
        this.fPulse = pulse;
    }
}

