/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.ModeFriday;
import DE.siemens.ad.logo.model.ModeMonday;
import DE.siemens.ad.logo.model.ModeMondayToFriday;
import DE.siemens.ad.logo.model.ModeMondayToSaturday;
import DE.siemens.ad.logo.model.ModeMondayToSunday;
import DE.siemens.ad.logo.model.ModeSaturday;
import DE.siemens.ad.logo.model.ModeSaturdayAndSunday;
import DE.siemens.ad.logo.model.ModeSunday;
import DE.siemens.ad.logo.model.ModeThursday;
import DE.siemens.ad.logo.model.ModeTuesday;
import DE.siemens.ad.logo.model.ModeUniversal;
import DE.siemens.ad.logo.model.ModeWednesday;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.Language;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class CamParameter
extends ProtectionParameter {
    static final long serialVersionUID = 7095981018047213888L;
    private int camParameterSerializedDataVersion = 2;
    public static final int NONE = 0;
    public static final int ON = 1;
    public static final int OFF = 2;
    protected ClockHours fOnTime;
    protected ClockHours fOffTime;
    protected boolean fOnTimeInactive;
    protected boolean fOffTimeInactive;
    protected int fCurrentMode;
    protected DateFormat fDateFormat = DateFormat.getDateTimeInstance(0, 2, Language.getLocale());
    private transient boolean fPulseMode;
    private transient boolean fPreState;
    protected Mode[] fAvailableModes = new Mode[]{new ModeMonday(), new ModeTuesday(), new ModeWednesday(), new ModeThursday(), new ModeFriday(), new ModeSaturday(), new ModeSunday(), new ModeMondayToFriday(), new ModeMondayToSaturday(), new ModeMondayToSunday(), new ModeSaturdayAndSunday(), new ModeUniversal()};
    public static final int MODE_UNIVERSAL = 11;

    public CamParameter() {
    }

    public CamParameter(Block block) {
        super(block);
        this.fOnTime = new ClockHours();
        this.fOnTime.setInactive(true);
        this.fOffTime = new ClockHours();
        this.fOffTime.setInactive(true);
        this.fCurrentMode = 11;
    }

    public Mode[] getAvailableModes() {
        return this.fAvailableModes;
    }

    public String calculateCurrentParameterText() {
        return this.fDateFormat.format(new Date(this.fInterpreter.getCurrentSimulationClockTime()));
    }

    public final int[] getDays() {
        Mode mode = this.getAvailableModes()[this.getMode()];
        return mode.getDays();
    }

    public int getLogoMode() {
        return this.getAvailableModes()[this.getMode()].getLogoMode();
    }

    public int getMode() {
        return this.fCurrentMode;
    }

    public Mode getModeObject() {
        return this.getAvailableModes()[this.getMode()];
    }

    public ClockHours getOffTime() {
        return this.fOffTime;
    }

    public ClockHours getOnTime() {
        return this.fOnTime;
    }

    public Vector getPanels() {
        return null;
    }

    public String getParameterText() {
        boolean oneProtection = this.getBlock().getWiringDiagram().getHardware().supports("clockOneProtection");
        String onTime = this.getOnTime().getParameterText();
        String offTime = this.getOffTime().getParameterText();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAvailableModes()[this.getMode()].getAbbreviation());
        if (!oneProtection) {
            buffer.append(this.getProtectionSign());
        }
        buffer.append("\n");
        buffer.append(onTime).append("\n");
        buffer.append(offTime);
        return buffer.toString();
    }

    public int getValue(Calendar currentTime, Calendar lastSwitchTime) {
        int value = this.fPulseMode ? this.calculatePulse(currentTime) : this.calculateValue(currentTime, lastSwitchTime);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return value;
    }

    protected int calculateValue(Calendar currentTime, Calendar lastSwitchTime) {
        int rw = 0;
        if (this.getLogoMode() != 0) {
            Calendar offSwitchTime;
            Calendar onSwitchTime;
            if (!this.getOnTime().isInactive() && !(onSwitchTime = this.fAvailableModes[this.fCurrentMode].getAbsoluteSwitchTime(this.fOnTime, currentTime)).before(lastSwitchTime)) {
                lastSwitchTime.setTime(onSwitchTime.getTime());
                rw = 1;
            }
            if (!this.getOffTime().isInactive() && !(offSwitchTime = this.fAvailableModes[this.fCurrentMode].getAbsoluteSwitchTime(this.fOffTime, currentTime)).before(lastSwitchTime)) {
                lastSwitchTime.setTime(offSwitchTime.getTime());
                rw = 2;
            }
        }
        return rw;
    }

    protected int calculatePulse(Calendar currentTime) {
        int rw = 0;
        if (this.getLogoMode() != 0) {
            if (!this.getOnTime().isInactive() && this.fAvailableModes[this.fCurrentMode].contains(currentTime.get(7)) && currentTime.get(11) == this.fOnTime.getHighValue() && currentTime.get(12) == this.fOnTime.getLowValue()) {
                if (!this.fPreState) {
                    rw = 1;
                    this.fPreState = true;
                }
            } else {
                this.fPreState = false;
            }
        }
        return rw;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOnTime = (ClockHours)dr.readStorable();
        this.fOffTime = (ClockHours)dr.readStorable();
        this.fCurrentMode = dr.readInt();
        this.fAvailableModes[this.fCurrentMode] = (Mode)dr.readStorable();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (11 > this.fAvailableModes.length - 1) {
            Mode[] newAvailableModes = new Mode[this.fAvailableModes.length + 1];
            for (int i = 0; i < this.fAvailableModes.length; ++i) {
                newAvailableModes[i] = this.fAvailableModes[i];
            }
            newAvailableModes[11] = new ModeUniversal();
            this.fAvailableModes = newAvailableModes;
        }
        if (this.camParameterSerializedDataVersion < 2) {
            this.camParameterSerializedDataVersion = 2;
            this.fOnTime.setInactive(this.fOnTimeInactive);
            this.fOffTime.setInactive(this.fOffTimeInactive);
        }
    }

    public void setLogoMode(int logoMode) {
        ((ModeUniversal)this.getAvailableModes()[11]).setLogoMode(logoMode);
        this.setMode(11);
    }

    public void setMode(int mode) {
        this.fCurrentMode = mode;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fOnTime);
        dw.writeStorable(this.fOffTime);
        dw.writeInt(this.fCurrentMode);
        dw.writeStorable(this.getModeObject());
    }

    public void setOffTime(ClockHours newOffTime) {
        this.fOffTime = newOffTime;
    }

    public void setOnTime(ClockHours newOnTime) {
        this.fOnTime = newOnTime;
    }

    public boolean supportsUserDefinedName() {
        return false;
    }

    public void setPulseMode(boolean newMode) {
        this.fPulseMode = newMode;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fPreState = false;
    }
}

