/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.BaseParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.MemoryUsageTable;
import DE.siemens.ad.logo.model.WiringDiagram;

public class BaseBlock
extends Block {
    static final long serialVersionUID = 6933228859750874100L;
    private int baseBlockSerializedDataVersion = 1;
    private transient BaseParameter fParameter = null;

    public BaseBlock() {
    }

    public BaseBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected int getDefaultOrder() {
        return 200;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = new int[HardwareFactory.getInstance().getResourceNames().length];
        result[0] = 1;
        MemoryUsageTable blockMemoryUsageTable = (MemoryUsageTable)hardware.getProperty("blockMemoryTable");
        result[14] = blockMemoryUsageTable != null ? blockMemoryUsageTable.getMemoryUsage(this.getClass()) : 0;
        if (this.isUserDefinedNameAvailable()) {
            result[15] = 1;
        }
        return result;
    }

    public int getNumberType() {
        return 0;
    }

    public int getOpcode(Hardware hw, int blockNr) throws IllegalArgumentException {
        return ((Logo)hw).getOpcodeGF(this.getName());
    }

    public String getType() {
        return "Base";
    }

    public boolean isLeftTerminal() {
        return false;
    }

    public boolean supportsUserDefinedName() {
        try {
            return this.getWiringDiagram().getHardware().supports("userBlockName");
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("block.supportsUserDefinedName(): Noch keine Hardware definiert");
        }
    }

    public BlockParameter getParameter() {
        if (this.fParameter == null) {
            this.fParameter = new BaseParameter(this);
        }
        return this.fParameter;
    }
}

