/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;

public class AnalogTriggerParameter
extends Analog
implements Storable {
    protected transient AnalogValueProperties fOffTriggerProperties;
    protected transient AnalogValueProperties fOnTriggerProperties;
    private AnalogOrBlockReference fOffTrigger = null;
    private AnalogOrBlockReference fOnTrigger = null;
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 2;
    protected static int MIN_LOW_TRIGGER = MIN_TRIGGER;
    protected static int MAX_LOW_TRIGGER = MAX_TRIGGER;
    protected int fLowTrigger = 0;
    private boolean f0BA4CalculationMethode = false;

    public AnalogTriggerParameter() {
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.fTrigger = this.getOn().getValue();
        this.fLowTrigger = this.getOff().getValue();
        this.serializedDataVersion = 2;
        s.defaultWriteObject();
    }

    public AnalogTriggerParameter(Block block) {
        super(block);
        this.fParameter = 4;
        this.fData = 2;
    }

    protected boolean calculateValue(double xInput) {
        boolean result = this.f0BA4CalculationMethode ? this.calculateValue0BA4(xInput) : this.calculateValue0BA3(xInput);
        this.calculateCurrentParameterText();
        return result;
    }

    protected boolean calculateValue0BA3(double xInput) {
        this.fXInput = xInput;
        this.fAmplifiedX = this.fMeasurement.getAmplifiedValue((int)this.fXInput);
        boolean READY = false;
        boolean ON = true;
        if (this.fState == 1) {
            if (this.fAmplifiedX <= this.getOffTrigger()) {
                this.fState = 0;
                return false;
            }
            return true;
        }
        if (this.fAmplifiedX > this.getOnTrigger()) {
            this.fState = 1;
            return true;
        }
        return false;
    }

    protected boolean calculateValue0BA4(double xInput) {
        this.fXInput = xInput;
        this.fAmplifiedX = this.fMeasurement.getAmplifiedValue((int)xInput);
        boolean ANALOG_LIMIT_OFF = false;
        boolean ANALOG_LIMIT_ON = true;
        int on = this.getOnTrigger();
        int off = this.getOffTrigger();
        boolean result = false;
        if (on >= off) {
            switch (this.fState) {
                case 0: {
                    if (this.fAmplifiedX <= on) break;
                    result = true;
                    this.fState = 1;
                    break;
                }
                case 1: {
                    if (this.fAmplifiedX <= off) {
                        this.fState = 0;
                        break;
                    }
                    result = true;
                }
            }
        } else if (this.fAmplifiedX >= on && this.fAmplifiedX < off) {
            result = true;
        }
        return result;
    }

    public String calculateCurrentParameterText() {
        String value = Double.toString(this.fAmplifiedX);
        value = Util.addTrailingSpaces(value, 8);
        return value;
    }

    public int getOnTrigger() {
        return this.getOn().getValue();
    }

    public int getOffTrigger() {
        return this.getOff().getValue();
    }

    public AnalogValueProperties getOnTriggerProperties() {
        return this.getOn().getAnalogValueProperties();
    }

    public AnalogOrBlockReference getOn() {
        if (this.fOnTrigger == null) {
            this.fOnTrigger = new AnalogOrBlockReference(this);
            this.fOnTriggerProperties = new AnalogValueProperties(MIN_LOW_TRIGGER, MAX_LOW_TRIGGER, 1, 0, 0, "error.dialog.invalidValue", "Invalid Value");
            this.fOnTriggerProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
            this.fOnTrigger.setAnalogValueProperties(this.fOnTriggerProperties);
            this.fOnTrigger.setIntValue(this.fTrigger);
        }
        this.fOnTrigger.setDecimalPlace(this.getDecimalPlace());
        return this.fOnTrigger;
    }

    public void setOnTriggerProperties(IntegerOrBlockReference onTriggerProperties) {
        this.fTrigger = onTriggerProperties.getValue();
        this.getOn().setValue(onTriggerProperties);
    }

    public void setOffTriggerProperties(IntegerOrBlockReference offTriggerProperties) {
        this.getOff().setValue(offTriggerProperties);
    }

    public AnalogValueProperties getOffTriggerProperties() {
        return this.getOff().getAnalogValueProperties();
    }

    public AnalogOrBlockReference getOff() {
        if (this.fOffTrigger == null) {
            this.fOffTrigger = new AnalogOrBlockReference(this);
            this.fOffTriggerProperties = new AnalogValueProperties(MIN_LOW_TRIGGER, MAX_LOW_TRIGGER, 1, 0, 0, "error.dialog.invalidValue", "Invalid Value");
            this.fOffTriggerProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
            this.fOffTrigger.setAnalogValueProperties(this.fOffTriggerProperties);
            this.fOffTrigger.setIntValue(this.fLowTrigger);
        }
        this.fOffTrigger.setDecimalPlace(this.getDecimalPlace());
        return this.fOffTrigger;
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer();
        result.append("Gain=").append(this.getGainString()).append(this.getProtectionSign()).append("\n").append("Offset=").append(this.getOffset()).append("\n").append("On=").append(this.getOn().getParameterText()).append("\n").append("Off=").append(this.getOff().getParameterText()).append("\n");
        if (this.isAnalogValueDecimalPlacesAvailable()) {
            result.append("Point=").append(this.getDecimalPlace());
        }
        return result.toString();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.f0BA4CalculationMethode = dr.readBoolean();
        this.fOnTrigger = (AnalogOrBlockReference)dr.readStorable();
        this.fOffTrigger = (AnalogOrBlockReference)dr.readStorable();
    }

    public void setOnTrigger(int value) {
        this.fTrigger = value;
        this.getOn().setIntValue(value);
    }

    public void setOnTriggerProperties(AnalogValueProperties value) {
        this.fTrigger = value.getCurrentValue();
        this.getOn().setAnalogValueProperties(value);
    }

    public void setOn(AnalogOrBlockReference value) {
        this.getOn().setValue(value);
    }

    public void setOff(AnalogOrBlockReference value) {
        this.getOff().setValue(value);
    }

    public void setOffTrigger(int value) {
        this.getOff().setIntValue(value);
    }

    public void setOffTriggerProperties(AnalogValueProperties value) {
        this.getOff().setAnalogValueProperties(value);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this.f0BA4CalculationMethode);
        dw.writeStorable(this.fOnTrigger);
        dw.writeStorable(this.fOffTrigger);
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        this.f0BA4CalculationMethode = newHardware.supports("0BA4AnalogCalculation") || newHardware.supports("0BA5AnalogCalculation");
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean available = super.isAvailable(hw, errorList);
        if ((this.getOn().isReference() || this.getOff().isReference()) && !hw.supports("AnalogTrigger_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hw.getLocalizedPath() + hw.getLocalizedName()), hw));
            available &= false;
        }
        return available;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fState = 0;
    }
}

