/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

public class AnalogComparatorParameter
extends Analog
implements Storable {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 3;
    private AnalogOrBlockReference fOffTrigger = null;
    private AnalogOrBlockReference fOnTrigger = null;
    private int fOff;
    private int fOn;
    private transient double fYInput = 0.0;
    private transient AnalogValueProperties fAmplifiedYProperties;
    private transient int fAmplifiedY;

    public AnalogComparatorParameter() {
    }

    public AnalogComparatorParameter(Block block) {
        super(block);
        this.fParameter = 3;
        this.fData = 4;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.serializedDataVersion < 2) {
            this.serializedDataVersion = 2;
            this.fOn = this.fTrigger;
            this.fOff = this.fTrigger;
        }
        if (this.serializedDataVersion < 3) {
            this.serializedDataVersion = 3;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.fOn = this.getOnTrigger().getValue();
        this.fOff = this.getOffTrigger().getValue();
        this.fTrigger = this.fOn;
        s.defaultWriteObject();
    }

    protected boolean calculateValue(double xInput, double yInput) {
        int curOff;
        this.fXInput = xInput;
        this.fYInput = yInput;
        this.fAmplifiedX = this.fMeasurement.getAmplifiedValue((int)xInput);
        this.fAmplifiedY = this.fMeasurement.getAmplifiedValue((int)yInput);
        double diff = this.fAmplifiedX - this.fAmplifiedY;
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        boolean result = false;
        boolean OFF = false;
        boolean ON = true;
        int curOn = this.getOnTrigger().getValue();
        if (curOn >= (curOff = this.getOffTrigger().getValue())) {
            switch (this.fState) {
                case 0: {
                    if (!(diff > (double)curOn)) break;
                    result = true;
                    this.fState = 1;
                    break;
                }
                case 1: {
                    if (diff <= (double)curOff) {
                        this.fState = 0;
                        break;
                    }
                    result = true;
                }
            }
        } else if (diff >= (double)curOn && diff < (double)curOff) {
            result = true;
        }
        return result;
    }

    public String calculateCurrentParameterText() {
        String value = Double.toString(this.fAmplifiedX - this.fAmplifiedY);
        try {
            value = Util.addTrailingSpaces(value, 8);
        }
        catch (Exception e) {
            return value;
        }
        return value;
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer();
        if (this.isOnOffAvailable()) {
            result.append("On     =").append(this.getOnTrigger().getParameterText()).append("\n").append("Off    =").append(this.getOffTrigger().getParameterText()).append("\n");
        } else {
            result.append("Trigger=").append(this.getOnTrigger().getParameterText()).append("\n");
        }
        result.append("Gain   =").append(this.getGainString()).append(this.getProtectionSign()).append("\n").append("Offset =").append(this.getOffset()).append("\n");
        if (this.isAnalogValueDecimalPlacesAvailable()) {
            result.append("Point=").append(this.getDecimalPlace());
        }
        return result.toString();
    }

    public AnalogValueProperties getAmplifiedYProperties() {
        if (this.fAmplifiedYProperties == null) {
            this.fAmplifiedYProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.fAmplifiedY, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedYProperties.setCurrentValue(this.fAmplifiedY);
        this.fAmplifiedYProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fAmplifiedYProperties;
    }

    public AnalogValueProperties getAmplifiedY() {
        if (this.fAmplifiedYProperties == null) {
            this.fAmplifiedYProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, (int)this.fYInput, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedYProperties.setCurrentValue(this.fAmplifiedY);
        return this.fAmplifiedYProperties;
    }

    public void setAmplifiedYProperties(IntValueProperties value) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setInput2(IntValueProperties) is not supported");
    }

    public AnalogValueProperties getOnProperties() {
        return this.getOnTrigger().getAnalogValueProperties();
    }

    public int getOn() {
        return this.getOnTrigger().getValue();
    }

    public AnalogOrBlockReference getOnTrigger() {
        if (this.fOnTrigger == null) {
            this.fOnTrigger = new AnalogOrBlockReference(this);
            AnalogValueProperties fOnProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, 0, 0, "error.dialog.invalidValue", "Invalid Value");
            fOnProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
            this.fOnTrigger.setAnalogValueProperties(fOnProperties);
            this.fOnTrigger.setIntValue(this.fOn);
        }
        this.fOnTrigger.setDecimalPlace(this.getDecimalPlace());
        return this.fOnTrigger;
    }

    public AnalogValueProperties getOffProperties() {
        return this.getOffTrigger().getAnalogValueProperties();
    }

    public int getOff() {
        return this.getOffTrigger().getValue();
    }

    public AnalogOrBlockReference getOffTrigger() {
        if (this.fOffTrigger == null) {
            this.fOffTrigger = new AnalogOrBlockReference(this);
            AnalogValueProperties fOffProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, 0, 0, "error.dialog.invalidValue", "Invalid Value");
            fOffProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
            this.fOffTrigger.setAnalogValueProperties(fOffProperties);
            this.fOffTrigger.setIntValue(this.fOff);
        }
        this.fOffTrigger.setDecimalPlace(this.getDecimalPlace());
        return this.fOffTrigger;
    }

    public void setOnProperties(AnalogValueProperties onProperties) {
        this.getOnTrigger().setAnalogValueProperties(onProperties);
    }

    public void setOnProperties(IntegerOrBlockReference value) {
        this.getOnTrigger().setValue(value);
    }

    public void setOn(int on) {
        this.getOnTrigger().setIntValue(on);
    }

    public void setOnTrigger(AnalogOrBlockReference value) {
        this.getOnTrigger().setValue(value);
    }

    public void setOffTrigger(AnalogOrBlockReference value) {
        this.getOffTrigger().setValue(value);
    }

    public void setOffProperties(AnalogValueProperties offProperties) {
        this.getOffTrigger().setAnalogValueProperties(offProperties);
    }

    public void setOffProperties(IntegerOrBlockReference value) {
        this.getOffTrigger().setValue(value);
    }

    public void setOff(int off) {
        this.getOffTrigger().setIntValue(off);
    }

    public AnalogValueProperties getCurrentDeltaProperties() {
        return new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.fAmplifiedX - this.fAmplifiedY, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
    }

    public boolean isOnOffAvailable() {
        WiringDiagram wiringDiagram = this.getBlock().getWiringDiagram();
        if (wiringDiagram != null) {
            return wiringDiagram.getHardware().supports("analogComparatorOnOff");
        }
        return false;
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean available = super.isAvailable(hw, errorList);
        if ((this.getOnTrigger().isReference() || this.getOffTrigger().isReference()) && !hw.supports("AnalogComparator_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hw.getLocalizedPath() + hw.getLocalizedName()), hw));
            available = false;
        }
        if (this.getOnTrigger().getValue() != this.getOffTrigger().getValue() && !hw.supports("analogComparatorOnOff")) {
            errorList.add(new ErrorInfo(this, "error.convert.analogComparator", hw));
            available = false;
        }
        return available;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOnTrigger = (AnalogOrBlockReference)dr.readStorable();
        this.fOffTrigger = (AnalogOrBlockReference)dr.readStorable();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fOnTrigger);
        dw.writeStorable(this.fOffTrigger);
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        this.getAmplifiedYProperties().setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
        this.getCurrentDeltaProperties().setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
    }
}

