/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.Util;

public class AmplifierParameter
extends Analog {
    static final long serialVersionUID = -2061765878891933939L;
    private double fAnalogValue;

    public AmplifierParameter() {
    }

    public AmplifierParameter(Block block) {
        super(block);
    }

    public double getAnalogValue(double analogInput) {
        this.fXInput = analogInput;
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fAnalogValue = this.getMeasurement().getAmplifiedValue((int)analogInput);
        return this.fAnalogValue;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append("Gain  =").append(this.getGainString()).append(this.getProtectionSign()).append("\nOffset=").append(this.getOffset()).append("\nPoint =").append(this.getDecimalPlace());
        return buffer.toString();
    }

    public String calculateCurrentParameterText() {
        String value = Double.toString(this.fAnalogValue);
        value = Util.addTrailingSpaces(value, 8);
        this.fireParameterUpdateEvent();
        return value;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fXInput = 0.0;
    }
}

