/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.dialog.wizard.ProgressInfo;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardModel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.update.ExtractingFilesModel;
import DE.siemens.ad.logo.dialog.wizard.update.ModuleInfo;
import DE.siemens.ad.logo.dialog.wizard.update.SelectModulesPanel;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateWizardModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoIOException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class SelectModulesModel
extends WizardPanelModel {
    protected SelectModulesPanel selectModulesPanel = new SelectModulesPanel(this);
    protected ProgressInfo progressInfo;
    public static final String UPDATE_TEMP = "/updateTemp/";
    public static final String CANT_WRITE = "cantWrite";

    public SelectModulesModel(WizardModel wizardModel) {
        super(wizardModel);
        this.nextPanelModel = new ExtractingFilesModel(wizardModel);
    }

    public ProgressInfo getProgressInfo() {
        this.progressInfo = new ProgressInfo();
        Enumeration e = ((UpdateWizardModel)this.wizardModel).getSelectedModules().elements();
        int overallSize = 0;
        while (e.hasMoreElements()) {
            ModuleInfo modulInfo = (ModuleInfo)e.nextElement();
            overallSize += modulInfo.getSize();
        }
        this.progressInfo.setTitle(Language.getString("wizard.update.selectModulesPanel.transferringFiles", "Transferring files"));
        this.progressInfo.setMin(0);
        this.progressInfo.setMax(overallSize);
        return this.progressInfo;
    }

    public WizardInputPanel getWizardInputPanel() {
        return this.selectModulesPanel;
    }

    public void loadFieldContents() {
    }

    public Object process() throws Exception {
        UpdateWizardModel updateWizardModel = (UpdateWizardModel)this.wizardModel;
        Properties props = System.getProperties();
        if (updateWizardModel.isUseProxy()) {
            props.setProperty("http.proxy.host", updateWizardModel.getProxyHost());
            props.setProperty("http.proxy.port", updateWizardModel.getProxyPort());
        } else {
            props.setProperty("http.proxy.host", "");
            props.setProperty("http.proxy.port", "");
        }
        File destinationPath = new File(Global.PATHBASE + UPDATE_TEMP);
        try {
            destinationPath.mkdirs();
        }
        catch (Exception e) {
            throw new LogoIOException("general IOException", e.getMessage(), destinationPath);
        }
        int transferredData = 0;
        try {
            Enumeration e = updateWizardModel.getSelectedModules().elements();
            while (e.hasMoreElements()) {
                ModuleInfo moduleInfo = (ModuleInfo)e.nextElement();
                URL sourceURL = new URL(updateWizardModel.getURL() + "/" + moduleInfo.getFilename());
                BufferedInputStream bis = new BufferedInputStream(sourceURL.openStream());
                File destinationFile = new File(destinationPath.getPath() + "/" + moduleInfo.getFilename());
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(destinationFile);
                }
                catch (IOException ioe) {
                    throw new LogoIOException(CANT_WRITE, "Can't write:\n" + destinationFile.getPath(), destinationFile);
                }
                byte[] data = new byte[8192];
                int readBytes = 0;
                this.progressInfo.setNote(Language.getString("wizard.update.selectModulesPanel.copying", "copying") + " " + moduleInfo.getFilename());
                while ((readBytes = bis.read(data)) != -1) {
                    fos.write(data, 0, readBytes);
                    this.progressInfo.setCurrent(transferredData += readBytes);
                }
                moduleInfo.setLocalSourceDirectory(destinationPath.getAbsolutePath());
                fos.close();
                bis.close();
            }
        }
        catch (Exception e) {
            return e;
        }
        return Boolean.TRUE;
    }
}

