/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.dialog.wizard.ProgressInfo;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardModel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.update.InternetUpdatePropertiesPanel;
import DE.siemens.ad.logo.dialog.wizard.update.SelectModulesModel;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateWizardModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class InternetUpdatePropertiesModel
extends WizardPanelModel {
    protected InternetUpdatePropertiesPanel internetUpdatePropertiesPanel;
    public ProgressInfo progressInfo;
    protected String URL = "";
    protected String proxyHost = "";
    protected String proxyPort = "";
    protected boolean useProxy = false;
    public static final String NO_UPDATES_FOUND = "no_updates_found";

    public InternetUpdatePropertiesModel(WizardModel wizardModel) {
        super(wizardModel);
        this.loadData();
        this.internetUpdatePropertiesPanel = new InternetUpdatePropertiesPanel(this);
        this.nextPanelModel = new SelectModulesModel(wizardModel);
    }

    public ProgressInfo getProgressInfo() {
        this.progressInfo = new ProgressInfo();
        this.progressInfo.setMin(0);
        this.progressInfo.setMax(1);
        this.progressInfo.setTitle("Fortschritt");
        return this.progressInfo;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getURL() {
        return this.URL;
    }

    public WizardInputPanel getWizardInputPanel() {
        return this.internetUpdatePropertiesPanel;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void loadData() {
        LogoProperties props = LogoProperties.instance();
        this.proxyHost = props.getProperty("update.internet.proxyHost", "");
        this.proxyPort = props.getProperty("update.internet.proxyPort", "");
        this.URL = props.getProperty("update.internet.server.url", "");
        String useProxyString = props.getProperty("update.internet.useProxy", "false");
        if (useProxyString != null) {
            this.useProxy = Boolean.getBoolean(useProxyString);
        }
    }

    public Object process() throws Exception {
        Properties props = System.getProperties();
        if (this.isUseProxy()) {
            props.setProperty("http.proxyHost", this.getProxyHost());
            props.setProperty("http.proxyPort", this.getProxyPort());
        } else {
            props.setProperty("http.proxyHost", "");
            props.setProperty("http.proxyPort", "");
        }
        BufferedReader br = null;
        URL url = new URL(this.getURL() + "/catalog.dat");
        this.progressInfo.setNote(Language.getString("wizard.update.internetUpdatePropertiesPanel.connecting", "Connecting..."));
        URLConnection conn = url.openConnection();
        br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        this.progressInfo.setNote(Language.getString("wizard.update.internetUpdatePropertiesPanel.retrieving", "Retrieving information..."));
        String s = null;
        StringBuffer catalogFile = new StringBuffer();
        while ((s = br.readLine()) != null) {
            catalogFile.append(s);
            catalogFile.append("\n");
        }
        String catalogURL = conn.getURL().toString();
        br.close();
        ((UpdateWizardModel)this.wizardModel).setCatalogFile(catalogFile.toString());
        ((UpdateWizardModel)this.wizardModel).parseCatalogFile();
        UpdateWizardModel uwm = (UpdateWizardModel)this.wizardModel;
        uwm.setURL(catalogURL.substring(0, catalogURL.length() - "/catalog.dat".length()));
        uwm.setUseProxy(this.useProxy);
        uwm.setProxyHost(this.proxyHost);
        uwm.setProxyPort(this.proxyPort);
        if (((UpdateWizardModel)this.wizardModel).getAvailableModules() == null || ((UpdateWizardModel)this.wizardModel).getAvailableModules().isEmpty()) {
            throw new Exception(NO_UPDATES_FOUND);
        }
        ((UpdateWizardModel)this.wizardModel).setFinishable(false);
        return Boolean.TRUE;
    }

    public void setProxyHost(String newProxyHost) {
        this.proxyHost = newProxyHost;
    }

    public void setProxyPort(String newProxyPort) {
        this.proxyPort = newProxyPort;
    }

    public void setURL(String newURL) {
        this.URL = newURL;
    }

    public void setUseProxy(boolean newUseProxy) {
        this.useProxy = newUseProxy;
    }

    public void storeData() {
        LogoProperties props = LogoProperties.instance();
        props.setProperty("update.internet.proxyHost", this.getProxyHost());
        props.setProperty("update.internet.proxyPort", this.getProxyPort());
        props.setProperty("update.internet.server.url", this.getURL());
        props.setProperty("update.internet.useProxy", this.isUseProxy() + "");
        props.saveProperties();
    }
}

