/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.modem;

import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.modem.SetLocalModemCommandModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoModemSetting;
import DE.siemens.ad.pdraw.app.ModemManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetLocalModemCommandPanel
extends WizardInputPanel {
    private SetLocalModemCommandModel model;
    private JPanel modemSettingPanel;
    private JLabel resetLabel;
    private JLabel disableEchoLabel;
    private JLabel dialToneLabel;
    private JLabel enableSYncModeLabel;
    private JLabel additionalLabel;
    private JTextField resetText;
    private JTextField disableEchoText;
    private JTextField dialToneText;
    private JTextField enableSYncModeText;
    private JTextField additionalText;
    private JCheckBox useDefault;
    private Hashtable atCommand;
    private JTextField modemNameField;
    private JButton saveConfig;
    private JPanel savePanel;

    public Icon getIcon() {
        return null;
    }

    public SetLocalModemCommandPanel(String modemName, WizardPanelModel panelModel) {
        super(panelModel);
        this.model = (SetLocalModemCommandModel)panelModel;
        this.initialize(modemName);
    }

    private void initialize(String modemName) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.getCommandSettingPanel(modemName), constraints);
    }

    private JPanel getCommandSettingPanel(String modemName) {
        if (this.modemSettingPanel == null) {
            this.modemSettingPanel = new JPanel();
            this.modemSettingPanel.setLayout(new GridBagLayout());
            this.modemNameField = new JTextField(10);
            this.modemNameField.setText(modemName);
            this.resetLabel = new JLabel();
            this.resetText = new JTextField();
            this.disableEchoLabel = new JLabel();
            this.disableEchoText = new JTextField();
            this.dialToneLabel = new JLabel();
            this.dialToneText = new JTextField();
            this.enableSYncModeLabel = new JLabel();
            this.enableSYncModeText = new JTextField();
            this.additionalLabel = new JLabel();
            this.additionalText = new JTextField();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(10, 4, 7, 4);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.modemSettingPanel.add((Component)new JLabel(Language.getString("wizard.modem.setRemoteModemCommandPanel.modemName", "Modem name")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.modemSettingPanel.add((Component)this.modemNameField, constraints);
            constraints.insets = new Insets(0, 4, 7, 4);
            constraints.gridx = 0;
            constraints.gridy = 2;
            this.modemSettingPanel.add((Component)this.resetLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 2;
            this.modemSettingPanel.add((Component)this.resetText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 3;
            this.modemSettingPanel.add((Component)this.disableEchoLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 3;
            this.modemSettingPanel.add((Component)this.disableEchoText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 4;
            this.modemSettingPanel.add((Component)this.dialToneLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 4;
            this.modemSettingPanel.add((Component)this.dialToneText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 5;
            this.modemSettingPanel.add((Component)this.enableSYncModeLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 5;
            this.modemSettingPanel.add((Component)this.enableSYncModeText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 6;
            this.modemSettingPanel.add((Component)this.additionalLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 6;
            this.modemSettingPanel.add((Component)this.additionalText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 7;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.gridwidth = 2;
            constraints.anchor = 13;
            this.modemSettingPanel.add((Component)this.getSavePanel(), constraints);
            constraints.insets = new Insets(0, 4, 7, 4);
            constraints.gridwidth = 1;
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.gridy = 1;
            this.modemSettingPanel.add((Component)this.getCheckBox(), constraints);
            if (this.modemNameField.getText().equals("")) {
                this.modemNameField.setEditable(true);
                this.useDefault.setSelected(true);
                this.setDefaultSetting();
            } else {
                this.modemNameField.setEditable(false);
                this.useDefault.setSelected(false);
                this.setDefinedSetting();
            }
        }
        return this.modemSettingPanel;
    }

    private JPanel getSavePanel() {
        if (this.savePanel == null) {
            this.savePanel = new JPanel(new FlowLayout(2));
            this.saveConfig = new JButton(Language.getString("wizard.modem.setLocalModemCommandPanel.saveConfig", "Save Configuration"));
            this.saveConfig.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SetLocalModemCommandPanel.this.checkModemName()) {
                        if (SetLocalModemCommandPanel.this.saveConfiguration()) {
                            SetLocalModemCommandPanel.this.modemNameField.setEditable(false);
                            new LogoError(null, "wizard.modem.saveConfiguration.success", "Save successfully.", 1).display();
                        } else {
                            new LogoError(null, "wizard.modem.saveConfiguration.failed", "Save failed", 0).display();
                        }
                    }
                }
            });
            this.savePanel.add(this.saveConfig);
        }
        return this.savePanel;
    }

    private JCheckBox getCheckBox() {
        if (this.useDefault == null) {
            this.useDefault = new JCheckBox(Language.getString("dialog.parameter.message.menu.setMessageDefaultLabel", "Default"));
            this.useDefault.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SetLocalModemCommandPanel.this.useDefault.isSelected()) {
                        SetLocalModemCommandPanel.this.setDefaultSetting();
                    } else {
                        SetLocalModemCommandPanel.this.setDefinedSetting();
                    }
                }
            });
        }
        return this.useDefault;
    }

    public void setLabels() {
        this.title = Language.getString("wizard.modem.setLocalModemCommandPanel.configCommand", "Configure local modem command");
        this.resetLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.reset", "Reset modem factory setting"));
        this.disableEchoLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.disableEcho", "Disable echo"));
        this.dialToneLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.dialTone", "Dial without dial tone detection"));
        this.enableSYncModeLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.enableSYncMode", "Enable synchronous mode"));
        this.additionalLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.additional", "Additional (separated by blank)"));
        this.useDefault.setText(Language.getString("dialog.parameter.message.menu.setMessageDefaultLabel", "Default"));
    }

    private void setDefaultSetting() {
        this.setSettingEditable(false);
        this.resetText.setText("&F");
        this.disableEchoText.setText("E0");
        this.dialToneText.setText("X3");
        this.enableSYncModeText.setText("\\N0");
        this.additionalText.setText("");
    }

    private void setDefinedSetting() {
        this.setSettingEditable(true);
        LogoModemSetting modemSetting = LogoModemSetting.getInstance();
        this.atCommand = modemSetting.getAtSetting(true, this.modemNameField.getText());
        if (this.atCommand.get("reset") != null) {
            this.resetText.setText(this.atCommand.get("reset").toString());
        }
        if (this.atCommand.get("disableEcho") != null) {
            this.disableEchoText.setText(this.atCommand.get("disableEcho").toString());
        }
        if (this.atCommand.get("dialTone") != null) {
            this.dialToneText.setText(this.atCommand.get("dialTone").toString());
        }
        if (this.atCommand.get("enableSYncMode") != null) {
            this.enableSYncModeText.setText(this.atCommand.get("enableSYncMode").toString());
        }
        if (this.atCommand.get("additional") != null) {
            this.additionalText.setText(this.atCommand.get("additional").toString());
        }
    }

    private void setSettingEditable(boolean editable) {
        this.resetText.setEditable(editable);
        this.disableEchoText.setEditable(editable);
        this.dialToneText.setEditable(editable);
        this.enableSYncModeText.setEditable(editable);
        this.additionalText.setEditable(editable);
    }

    private boolean saveConfiguration() {
        boolean sucess = false;
        this.atCommand = new Hashtable();
        this.atCommand.put("reset", this.resetText.getText());
        this.atCommand.put("disableEcho", this.disableEchoText.getText());
        this.atCommand.put("dialTone", this.dialToneText.getText());
        this.atCommand.put("enableSYncMode", this.enableSYncModeText.getText());
        this.atCommand.put("additional", this.additionalText.getText());
        LogoModemSetting modemSetting = LogoModemSetting.getInstance();
        sucess = this.modemNameField.isEditable() ? modemSetting.addNewModem(true, this.modemNameField.getText(), this.atCommand) : modemSetting.modifyModemSetting(true, this.modemNameField.getText(), this.atCommand);
        return sucess;
    }

    private boolean checkModemName() {
        if (this.modemNameField.isEditable() && this.modemNameField.getText().equals("")) {
            new LogoError(this, "wizard.modem.setRemoteModemCommandPanel.noModemNameError", "You must enter a modem name", 0).display();
            return false;
        }
        if (this.modemNameField.isEditable() && !LogoModemSetting.getInstance().checkModemName(true, this.modemNameField.getText())) {
            new LogoError(this, "wizard.modem.setRemoteModemCommandPanel.modemNameExist", "The modem name has already existed.", 0).display();
            return false;
        }
        return true;
    }

    public String getHelpIdString() {
        return "extras.setLocalModemCommand";
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        this.atCommand = new Hashtable();
        this.atCommand.put("reset", this.resetText.getText());
        this.atCommand.put("disableEcho", this.disableEchoText.getText());
        this.atCommand.put("dialTone", this.dialToneText.getText());
        this.atCommand.put("enableSYncMode", this.enableSYncModeText.getText());
        this.atCommand.put("additional", this.additionalText.getText());
        ModemManager.setAtCommand(this.atCommand);
    }
}

