/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.modem;

import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.modem.SelectLocalConfigurationModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoModemSetting;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SelectLocalConfigurationPanel
extends WizardInputPanel {
    private JPanel newConfigurationPanel;
    private JLabel remindInfoLabel;
    private JComboBox modemType;
    private JButton deleModemButton;
    private JPanel modemTypePanel;
    private JRadioButton existingConfiguration;
    private JRadioButton newConfiguration;
    private SelectLocalConfigurationModel model;

    public Icon getIcon() {
        return Global.getIcon("SelectLocalConfiguration.gif");
    }

    public void setLabels() {
        this.title = Language.getString("wizard.modem.selectLocalConfigurationPanel.title", "Select local configuration");
    }

    public SelectLocalConfigurationPanel(WizardPanelModel panelModel) {
        super(panelModel);
        this.model = (SelectLocalConfigurationModel)panelModel;
        this.initialize();
    }

    private void initialize() {
        JLabel image = new JLabel(this.getIcon());
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.fill = 2;
        constraint.anchor = 18;
        constraint.gridheight = 1;
        constraint.gridwidth = 1;
        constraint.gridx = 0;
        constraint.gridy = 0;
        this.add((Component)image, constraint);
        constraint.gridx = 0;
        constraint.gridy = 1;
        this.add((Component)new JPanel(), constraint);
        constraint.insets = new Insets(0, 5, 0, 0);
        constraint.gridx = 0;
        constraint.gridy = 2;
        this.add((Component)this.getRemindInfoLabel(), constraint);
        constraint.gridx = 0;
        constraint.gridy = 3;
        this.add((Component)new JPanel(), constraint);
        constraint.insets = new Insets(0, 10, 0, 0);
        constraint.gridx = 0;
        constraint.gridy = 5;
        this.add((Component)this.getNewConfigurationPanel(), constraint);
        constraint.gridx = 0;
        constraint.gridy = 4;
        constraint.insets = new Insets(4, 10, 0, 0);
        this.add((Component)this.getModemTypePanel(), constraint);
        constraint.gridx = 0;
        constraint.gridy = 6;
        constraint.weightx = 1.0;
        constraint.weighty = 1.0;
        this.add((Component)new JPanel(), constraint);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.existingConfiguration);
        bg.add(this.newConfiguration);
    }

    private JLabel getRemindInfoLabel() {
        if (this.remindInfoLabel == null) {
            this.remindInfoLabel = new JLabel(Language.getString("wizard.modem.selectRemoteConfigurationPanel.remindInfo", "Select an existing configuration or create a new configuration."));
        }
        return this.remindInfoLabel;
    }

    private JPanel getModemTypePanel() {
        if (this.modemTypePanel == null) {
            this.modemTypePanel = new JPanel(new FlowLayout(0));
            this.modemType = new JComboBox();
            this.existingConfiguration = new JRadioButton(Language.getString("wizard.modem.selectRemoteConfigurationPanel.existModem", "Existing configuration"));
            this.modemTypePanel.add(this.existingConfiguration);
            this.modemTypePanel.add(this.modemType);
            this.modemTypePanel.add(this.getDeleteModemButton());
        }
        this.modemType.setModel(new DefaultComboBoxModel<Object>(LogoModemSetting.getInstance().getModemType(true).toArray()));
        this.setButtonEditable();
        return this.modemTypePanel;
    }

    private JPanel getNewConfigurationPanel() {
        if (this.newConfigurationPanel == null) {
            this.newConfigurationPanel = new JPanel(new FlowLayout(0));
            this.newConfiguration = new JRadioButton(Language.getString("wizard.modem.selectRemoteConfigurationPanel.newModem", "Create new configuration"));
            this.newConfigurationPanel.add(this.newConfiguration);
        }
        return this.newConfigurationPanel;
    }

    private JButton getDeleteModemButton() {
        if (this.deleModemButton == null) {
            this.deleModemButton = new JButton(Language.getString("wizard.modem.selectRemoteConfigurationPanel.deleteModem", "Delete"));
            this.deleModemButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    LogoModemSetting.getInstance().deleteModem(true, SelectLocalConfigurationPanel.this.modemType.getSelectedItem().toString());
                    SelectLocalConfigurationPanel.this.modemType.removeItem(SelectLocalConfigurationPanel.this.modemType.getSelectedItem());
                    SelectLocalConfigurationPanel.this.setButtonEditable();
                }
            });
        }
        return this.deleModemButton;
    }

    private void setButtonEditable() {
        if (this.modemType.getItemCount() == 0) {
            this.existingConfiguration.setEnabled(false);
            this.newConfiguration.setSelected(true);
            this.getDeleteModemButton().setEnabled(false);
            this.modemType.setEnabled(false);
        } else {
            this.modemType.setEnabled(true);
            this.existingConfiguration.setEnabled(true);
            this.existingConfiguration.setSelected(true);
            this.getDeleteModemButton().setEnabled(true);
        }
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        if (this.existingConfiguration.isSelected()) {
            this.model.setModemName(this.modemType.getSelectedItem().toString());
        } else {
            this.model.setModemName("");
        }
    }

    public String getHelpIdString() {
        return "extras.selectLocalConfiguration";
    }

    public void refreshData() {
        this.modemType.setModel(new DefaultComboBoxModel<Object>(LogoModemSetting.getInstance().getModemType(true).toArray()));
        this.setButtonEditable();
    }
}

