/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard;

import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.wizard.AbstractWizardHeaderPanel;
import DE.siemens.ad.logo.dialog.wizard.AbstractWizardProgressPanel;
import DE.siemens.ad.logo.dialog.wizard.DefaultHeaderPanel;
import DE.siemens.ad.logo.dialog.wizard.DefaultWizardProgressPanel;
import DE.siemens.ad.logo.dialog.wizard.ProgressInfo;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardModel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class WizardDialog
extends SplittedDlg
implements ActionListener {
    protected JButton previousButton;
    protected JButton nextButton;
    protected JButton finishButton;
    protected JButton cancelButton;
    protected WizardModel wizardModel;
    protected AbstractWizardHeaderPanel headerPanel;
    protected AbstractWizardProgressPanel progressPanel;
    protected SwingWorker worker;
    public boolean workerRunning = false;
    protected JPanel inputPanelContainer;
    protected JPanel progressPanelContainer;
    protected JPanel headerPanelContainer;
    protected WizardInputPanel inputPanel;
    protected Hashtable savedEnabledInformation = new Hashtable();

    private WizardDialog(JFrame parent) {
        super(parent);
    }

    private WizardDialog(JDialog parent) {
        super(parent);
    }

    public static WizardDialog createWizardDialog(Window parent, boolean modal) {
        WizardDialog wizardDialog = null;
        if (parent instanceof JDialog) {
            wizardDialog = new WizardDialog((JDialog)parent);
        } else if (parent instanceof JFrame) {
            wizardDialog = new WizardDialog((JFrame)parent);
        } else {
            throw new IllegalArgumentException("Parent of a WizardDialog must be a JDialog or JFrame.");
        }
        wizardDialog.setModal(modal);
        wizardDialog.initComponents();
        return wizardDialog;
    }

    private void initComponents() {
        this.headerPanel = new DefaultHeaderPanel();
        this.progressPanel = new DefaultWizardProgressPanel();
        this.getInputPane().setLayout(new BorderLayout());
        this.inputPanelContainer = new JPanel(new BorderLayout());
        this.getInputPane().add((Component)this.inputPanelContainer, "Center");
        this.headerPanelContainer = new JPanel(new BorderLayout());
        this.headerPanelContainer.add(this.headerPanel);
        this.getInputPane().add((Component)this.headerPanelContainer, "North");
        this.progressPanelContainer = new JPanel(new BorderLayout());
        this.getInputPane().add((Component)this.progressPanelContainer, "South");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setText(Language.getString("wizard.cancel", "Cancel"));
        this.previousButton = new JButton("< Previous");
        this.previousButton.setText("< " + Language.getString("wizard.previous", "Previous"));
        this.nextButton = new JButton("Next >");
        this.nextButton.setText(Language.getString("wizard.next", "Next") + " >");
        this.finishButton = new JButton("Finish");
        this.finishButton.setText(Language.getString("wizard.finish", "Finish"));
        this.getControlPane().setLayout(new FlowLayout(2));
        this.getControlPane().add(this.previousButton);
        this.getControlPane().add(this.nextButton);
        this.getControlPane().add(this.finishButton);
        this.getControlPane().add(this.cancelButton);
        this.previousButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.nextButton);
        this.setResizable(true);
        this.setSize(450, 300);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.previousButton) {
            this.previousButtonPressed();
        }
        if (event.getSource() == this.nextButton) {
            this.nextButtonPressed();
        }
        if (event.getSource() == this.finishButton) {
            this.finishButtonPressed();
        }
        if (event.getSource() == this.cancelButton) {
            this.cancelButtonPressed();
        }
    }

    public void cancelButtonPressed() {
        if (this.workerRunning) {
            this.processingInterrupted();
        } else {
            this.setVisible(false);
        }
    }

    protected void disableComponentTree(Component comp) {
        this.savedEnabledInformation.put(comp, new Boolean(comp.isEnabled()));
        comp.setEnabled(false);
        if (comp instanceof Container) {
            Component[] components = ((Container)comp).getComponents();
            for (int i = 0; i < components.length; ++i) {
                this.disableComponentTree(components[i]);
            }
        }
    }

    public void enableComponentTree() {
        if (this.savedEnabledInformation == null || this.savedEnabledInformation.isEmpty()) {
            return;
        }
        Enumeration keyEnumeration = this.savedEnabledInformation.keys();
        Object key = null;
        while (keyEnumeration.hasMoreElements()) {
            key = keyEnumeration.nextElement();
            ((Component)key).setEnabled((Boolean)this.savedEnabledInformation.get(key));
        }
        this.savedEnabledInformation = new Hashtable();
    }

    public void finishButtonPressed() {
        WizardInputPanel currentInputPanel = this.wizardModel.getCurrentPanelModel().getWizardInputPanel();
        if (!currentInputPanel.checkFieldContents()) {
            return;
        }
        this.process();
        this.dispose();
        this.wizardModel.finish();
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 415);
    }

    public void nextButtonPressed() {
        WizardInputPanel currentInputPanel = this.wizardModel.getCurrentPanelModel().getWizardInputPanel();
        if (!currentInputPanel.checkFieldContents()) {
            return;
        }
        currentInputPanel.storeFieldContents();
        this.process();
    }

    public void previousButtonPressed() {
        this.wizardModel.previous();
        this.showCurrentInputPanel();
    }

    public void process() {
        this.setPreviousEnabled(false);
        this.setNextEnabled(false);
        this.setCancelEnabled(true);
        this.setFinishEnabled(false);
        ProgressInfo progressInfo = this.wizardModel.getCurrentPanelModel().getProgressInfo();
        if (progressInfo != null) {
            this.progressPanelContainer.setVisible(true);
            this.progressPanel.setProgressInfo(progressInfo);
            this.validate();
        }
        this.worker = new SwingWorker(){

            public Object construct() {
                try {
                    return WizardDialog.this.wizardModel.getCurrentPanelModel().process();
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                WizardDialog.this.processingFinished(this.get());
            }
        };
        this.disableComponentTree(this.inputPanel);
        this.workerRunning = true;
        this.worker.start();
    }

    public void processingFinished(Object o) {
        this.enableComponentTree();
        this.workerRunning = false;
        this.progressPanelContainer.removeAll();
        this.repaint();
        if (o instanceof Exception) {
            this.inputPanel.handleProcessException((Exception)o);
        } else {
            this.inputPanel.processingFinished();
            if (this.wizardModel.next() == null) {
                return;
            }
        }
        this.showCurrentInputPanel();
    }

    public void processingInterrupted() {
        this.worker.interrupt();
        this.workerRunning = false;
        this.enableComponentTree();
        this.progressPanelContainer.removeAll();
        this.validate();
        this.repaint();
        this.showCurrentInputPanel();
    }

    public void setCancelEnabled(boolean newValue) {
        this.cancelButton.setEnabled(newValue);
    }

    public void setFinishEnabled(boolean newValue) {
        this.finishButton.setEnabled(newValue);
    }

    public void setNextEnabled(boolean newValue) {
        this.nextButton.setEnabled(newValue);
    }

    public void setPreviousEnabled(boolean newValue) {
        this.previousButton.setEnabled(newValue);
    }

    public void setWizardModel(WizardModel wizardModel) {
        this.wizardModel = wizardModel;
    }

    public void showCurrentInputPanel() {
        WizardPanelModel panelModel = this.wizardModel.getCurrentPanelModel();
        this.inputPanel = panelModel.getWizardInputPanel();
        this.setTitle(this.wizardModel.getTitle() + " - " + Language.getString("wizard.step", "wizard.step") + " " + (this.wizardModel.getCurrentPanelModelIndex() + 1));
        this.inputPanel.setLabels();
        this.inputPanel.loadFieldContents();
        this.inputPanelContainer.removeAll();
        this.inputPanelContainer.add(this.inputPanel);
        this.headerPanel.setHeader(this.inputPanel.getTitle());
        this.progressPanelContainer.removeAll();
        this.progressPanel = this.inputPanel.getProgressPanel();
        this.progressPanelContainer.add(this.progressPanel);
        this.progressPanelContainer.setVisible(false);
        this.setPreviousEnabled(this.wizardModel.canPrevious());
        this.setNextEnabled(this.wizardModel.canNext());
        this.setFinishEnabled(this.wizardModel.canFinish());
        this.setCancelEnabled(this.wizardModel.canCancel());
        this.getRootPane().setDefaultButton(this.nextButton);
        this.invalidate();
        this.repaint();
    }

    public void showWizardDialog() {
        this.showCurrentInputPanel();
        this.setVisible(true);
    }

    public void setFinishButtonText(String text) {
        this.finishButton.setText(text);
    }

    public WizardInputPanel getInputPanel() {
        return this.inputPanel;
    }
}

