/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard;

import DE.siemens.ad.logo.dialog.wizard.WizardProgressListener;
import java.util.Enumeration;
import java.util.Vector;

public class ProgressInfo {
    protected int fMinimum;
    protected int fMaximum;
    protected int fCurrent;
    protected String fTitle;
    protected String fNote;
    protected Vector progressListeners = new Vector();
    private long fStartTime;

    public void addProgressListener(WizardProgressListener listener) {
        if (!this.progressListeners.contains(listener)) {
            this.progressListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProgressEvent() {
        Vector copy = null;
        ProgressInfo progressInfo = this;
        synchronized (progressInfo) {
            copy = (Vector)this.progressListeners.clone();
        }
        Enumeration e = copy.elements();
        while (e.hasMoreElements()) {
            ((WizardProgressListener)e.nextElement()).setProgress(this, this);
        }
    }

    public int getCurrent() {
        return this.fCurrent;
    }

    public int getMax() {
        return this.fMaximum;
    }

    public int getMin() {
        return this.fMinimum;
    }

    public void inc() {
        this.setCurrent(this.fCurrent + 1);
    }

    public void removeProgressListener(WizardProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public void setCurrent(int newCurrentValue) {
        if (this.fCurrent == 0) {
            this.fStartTime = System.currentTimeMillis();
        }
        this.fCurrent = newCurrentValue;
        this.fireProgressEvent();
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.fStartTime;
    }

    public void setMax(int newMaxValue) {
        this.fMaximum = newMaxValue;
    }

    public void setMin(int newMinValue) {
        this.fMinimum = newMinValue;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setNote(String text) {
        this.fNote = text;
        this.fireProgressEvent();
    }

    public String getNote() {
        return this.fNote;
    }

    public String getTitle() {
        return this.fTitle;
    }
}

