/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.TimeUnitListCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.ParameterItemDisplayCellEditor;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TimeValuePropertiesCellEditor
extends ParameterItemDisplayCellEditor {
    protected JPanel fEditorComponent = new JPanel(){

        public void requestFocus() {
            TimeValuePropertiesCellEditor.this.fHighSpinner.requestFocus();
        }
    };
    protected EditableNumericSpinner fHighSpinner;
    protected EditableNumericSpinner fLowSpinner;
    protected JComboBox fTimeUnitComboBox;
    protected TimeValueProperties fTimeValueProperties;

    public TimeValuePropertiesCellEditor() {
        this.fEditorComponent.setFocusCycleRoot(true);
        this.fEditorComponent.setLayout(new BoxLayout(this.fEditorComponent, 0));
        this.fHighSpinner = new EditableNumericSpinner();
        this.fHighSpinner.setMaximumSize(new Dimension(200, 25));
        this.fHighSpinner.setColumns(2);
        this.fEditorComponent.add(this.fHighSpinner);
        this.fLowSpinner = new EditableNumericSpinner();
        this.fLowSpinner.setMaximumSize(new Dimension(200, 25));
        this.fLowSpinner.setColumns(2);
        this.fEditorComponent.add(this.fLowSpinner);
        this.fTimeUnitComboBox = new JComboBox();
        this.fTimeUnitComboBox.setMaximumSize(new Dimension(200, 25));
        this.fTimeUnitComboBox.setRenderer(new TimeUnitListCellRenderer(true));
        this.fTimeUnitComboBox.addItemListener(new TimeUnitSelectionListener());
        this.fEditorComponent.add(this.fTimeUnitComboBox);
    }

    public Component getDisplayCellEditorComponent(LogoDisplay logoDisplay, Object displayElement, boolean isSelected, int row, int column) {
        Object parameterItemValue;
        super.getDisplayCellEditorComponent(logoDisplay, displayElement, isSelected, row, column);
        if (this.fParameterItem != null && (parameterItemValue = ((ParameterItem)displayElement).getValue()) instanceof TimeValueProperties) {
            this.fTimeValueProperties = (TimeValueProperties)parameterItemValue;
            if (this.fTimeValueProperties.isReference()) {
                return null;
            }
            this.fLowSpinner.setProperties(this.fTimeValueProperties.getCurrentValue().getLow());
            this.fHighSpinner.setProperties(this.fTimeValueProperties.getCurrentValue().getHigh());
            TimeUnit[] timeUnits = this.fTimeValueProperties.getAvailableTimeUnits();
            DefaultComboBoxModel<TimeUnit> comboBoxModel = new DefaultComboBoxModel<TimeUnit>(timeUnits);
            this.fTimeUnitComboBox.setModel(comboBoxModel);
            for (int i = 0; i < timeUnits.length; ++i) {
                if (!timeUnits[i].getUnitAbbreviation().equals(this.fTimeValueProperties.getCurrentValue().getUnitAbbreviation())) continue;
                this.fTimeUnitComboBox.setSelectedIndex(i);
            }
        }
        return this.fEditorComponent;
    }

    public Object getCellEditorValue() {
        return this.fParameterItem;
    }

    public boolean stopCellEditing() {
        if (!this.fLowSpinner.checkValue(true) || !this.fHighSpinner.checkValue(true)) {
            return false;
        }
        TimeUnit timeUnit = (TimeUnit)((TimeUnit)this.fTimeUnitComboBox.getSelectedItem()).clone();
        timeUnit.setTime(this.fHighSpinner.getValue(), this.fLowSpinner.getValue());
        this.fTimeValueProperties.setCurrentValue(timeUnit);
        this.fParameterItem.setValue(this.fTimeValueProperties);
        this.fParameterItem.getParameter().fireParameterSetEvent();
        this.fireEditingStopped();
        return true;
    }

    private void setSpinnerBounds() {
        TimeUnit timeUnit = (TimeUnit)this.fTimeUnitComboBox.getSelectedItem();
        if (timeUnit != null) {
            this.fLowSpinner.setPropertiesWithoutCurrent(timeUnit.getLow());
            this.fHighSpinner.setPropertiesWithoutCurrent(timeUnit.getHigh());
        }
    }

    protected class TimeUnitSelectionListener
    implements ItemListener {
        protected TimeUnitSelectionListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            TimeValuePropertiesCellEditor.this.setSpinnerBounds();
        }
    }
}

