/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelListener;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.ReadOnlyDisplayModel;
import DE.siemens.ad.logo.model.MessageParameter;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public class TickerDisplayModel
extends ReadOnlyDisplayModel
implements MessageDisplayModel,
MutiCharSetDisplayModel {
    private int[] fDeltas;
    private int fTickerTimes = 0;
    private transient long[] fTickerDelay;
    MessageParameterDisplayModelRTF fModel = null;
    private Timer fTickerTimer;
    private Timer fAnalogFilterTimer;

    public TickerDisplayModel(MessageParameter messageParameter, int charSetID) {
        this.fModel = new MessageParameterDisplayModelRTF(messageParameter, charSetID);
        this.fDeltas = new int[this.fModel.getDisplayDimension().height];
        this.fTickerDelay = new long[this.fDeltas.length];
    }

    public Dimension getDisplayDimension() {
        Dimension ret = new Dimension(this.fModel.getDisplayDimension());
        ret.width = this.getScreenSize();
        return ret;
    }

    private int getScreenSize() {
        return this.fModel.getDisplayDimension().width / 2;
    }

    private Point getRealPoing(Point location) {
        Point ret = new Point(location);
        ret.x += this.fDeltas[location.y];
        return ret;
    }

    public Rectangle getElementBounds(Point location) {
        Point newPoint = this.getRealPoing(location);
        if (newPoint.x < 0 || newPoint.y < 0) {
            System.err.println("getElementBounds(): Error location");
            return new Rectangle();
        }
        Rectangle ret = this.fModel.getElementBounds(newPoint);
        ret.x -= newPoint.x - location.x;
        if (ret.x + ret.width <= 0) {
            System.err.println("TickerDisplayModel: Error element bound;");
            ret.x = 1 - ret.width;
        }
        return ret;
    }

    public DisplayElement getElementAt(Point location) {
        return this.fModel.getElementAt(this.getRealPoing(location));
    }

    public void resetTicker() {
        for (int i = 0; i < this.fDeltas.length; ++i) {
            this.fDeltas[i] = 0;
        }
        this.fTickerTimes = 0;
    }

    private void ticker() {
        ++this.fTickerTimes;
        for (int i = 0; i < this.fDeltas.length; ++i) {
            if (!this.isTickerLine(i)) continue;
            if (this.isTickerByChar()) {
                if (this.isScreenStart(i) && this.fTickerDelay[i] == 0L) {
                    this.fTickerDelay[i] = System.currentTimeMillis();
                    continue;
                }
                if (System.currentTimeMillis() - this.fTickerDelay[i] <= 2000L) continue;
                this.stepChar(i);
                this.fTickerDelay[i] = 0L;
                continue;
            }
            if (this.fTickerTimes < 10) continue;
            this.stepToNextScreen(i);
        }
        if (this.fTickerTimes >= 10) {
            this.fTickerTimes = 0;
        }
    }

    private boolean isScreenStart(int lineNum) {
        return this.fDeltas[lineNum] == this.getScreenSize() || this.fDeltas[lineNum] == 0;
    }

    private void stepChar(int lineNum) {
        int stepLength = 0;
        stepLength = this.fModel.isBiWidthCharacterset() ? 2 : 1;
        int n = lineNum;
        this.fDeltas[n] = this.fDeltas[n] + stepLength;
        if (this.fDeltas[lineNum] > this.getScreenSize()) {
            this.fDeltas[lineNum] = 0;
        }
    }

    private void stepToNextScreen(int lineNum) {
        this.fDeltas[lineNum] = this.fDeltas[lineNum] == 0 ? this.getScreenSize() : 0;
    }

    private MessageParameter.MessageText getMessageText() {
        return this.fModel.getMessageParameter().getMessageRTF(this.fModel.getCharSetID());
    }

    private boolean isTickerLine(int line) {
        if (this.getMessageText() != null) {
            return this.getMessageText().getMessageLineRTF()[line].isTickerLine();
        }
        return false;
    }

    private boolean isTickerByChar() {
        if (this.getMessageText() != null) {
            return this.getMessageText().getTickerType() == 0;
        }
        return false;
    }

    public String getErrorInsertString() {
        return this.fModel.getErrorInsertString();
    }

    public Hashtable getSpecialCharactersTable() {
        return this.fModel.getSpecialCharactersTable();
    }

    public void addAsParameterSetListener(MessageParameter msgParam) {
        this.fModel.addAsParameterSetListener(msgParam);
    }

    public void removeAsParameterSetListener(MessageParameter msgParam) {
        this.fModel.removeAsParameterSetListener(msgParam);
    }

    public void addDisplayModelListener(DisplayModelListener displayModelListener) {
        this.fModel.addDisplayModelListener(displayModelListener);
    }

    public void removeDisplayModelListener(DisplayModelListener displayModelListener) {
        this.fModel.removeDisplayModelListener(displayModelListener);
    }

    public boolean isCellEditable(Point location) {
        DisplayElement displayElement = this.getElementAt(location);
        if (displayElement == null) {
            return false;
        }
        return displayElement.isEditable();
    }

    public int getCharSet() {
        return this.fModel.getCharSet();
    }

    public boolean isBiWidthCharacterset() {
        return this.fModel.isBiWidthCharacterset();
    }

    public void initTimers() {
        if (this.fTickerTimer == null) {
            this.initTickerTimer();
        }
        if (this.fAnalogFilterTimer == null) {
            this.initAnalogFilterTimer();
        }
    }

    public void cancleTimers() {
        if (this.fTickerTimer != null) {
            this.fTickerTimer.cancel();
            this.fTickerTimer = null;
        }
        if (this.fAnalogFilterTimer != null) {
            this.fAnalogFilterTimer.cancel();
            this.fAnalogFilterTimer = null;
        }
    }

    private void initTickerTimer() {
        this.resetTicker();
        this.fTickerTimer = new Timer();
        this.fTickerTimer.schedule(new TimerTask(){

            public void run() {
                TickerDisplayModel.this.ticker();
            }
        }, 0L, (long)this.getTickerInterval());
    }

    private int getTickerInterval() {
        int scale = 100;
        return this.fModel.getMessageParameter().getBlock().getWiringDiagram().getMessageGlobalInfo().getTickerInterval() * 100;
    }

    private void initAnalogFilterTimer() {
        this.fAnalogFilterTimer = new Timer();
        this.fAnalogFilterTimer.schedule(new TimerTask(){

            public void run() {
                for (int i = 0; i < TickerDisplayModel.this.getDisplayDimension().width; ++i) {
                    for (int j = 0; j < TickerDisplayModel.this.getDisplayDimension().height; ++j) {
                        DisplayElement disp = TickerDisplayModel.this.getElementAt(new Point(i, j));
                        if (!(disp instanceof AIDisplayElement)) continue;
                        ((AIDisplayElement)disp).updateFilter();
                    }
                }
            }
        }, 0L, (long)this.getAnalogFilterTime());
    }

    private int getAnalogFilterTime() {
        int scale = 100;
        int ret = this.fModel.getMessageParameter().getBlock().getWiringDiagram().getMessageGlobalInfo().getAnalogRefreshInterval() * 100;
        if (ret == 0) {
            System.err.println("Error analog filter time");
            ret = 100;
        }
        return ret;
    }
}

