/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.util.Util;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class NestedCellsDisplayCellRenderer
extends JComponent
implements DisplayCellRenderer {
    protected DisplayCellRenderer fDisplayCellRenderer;
    protected LogoDisplay fLogoDisplay;
    protected CellRendererPane fCellRendererPane;
    protected String fText;
    protected boolean fSelected;
    protected Border fNoFocusBorder = new EmptyBorder(0, 0, 0, 0);

    public NestedCellsDisplayCellRenderer(DisplayCellRenderer cellRenderer) {
        this.fDisplayCellRenderer = cellRenderer;
        this.fCellRendererPane = new CellRendererPane();
    }

    public Component getDisplayCellRendererComponent(LogoDisplay display, Object value, boolean selected, boolean hasFocus, int row, int column) {
        this.fText = Util.addTrailingSpaces(value.toString(), ((DisplayElement)value).getWidth());
        this.fSelected = selected;
        this.fLogoDisplay = display;
        if (hasFocus) {
            this.setBorder(display.getFocusBorder());
        } else {
            this.setBorder(this.fNoFocusBorder);
        }
        return this;
    }

    public DisplayCellRenderer getDisplayCellRenderer() {
        return this.fDisplayCellRenderer;
    }

    public void setDisplayCellRenderer(DisplayCellRenderer displayCellRenderer) {
        this.fDisplayCellRenderer = displayCellRenderer;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        String text = this.fText;
        for (int c = 0; c < text.length(); ++c) {
            if (this.fDisplayCellRenderer instanceof DefaultDisplayCellRenderer) {
                ((DefaultDisplayCellRenderer)this.fDisplayCellRenderer).setDefaultBackground(this.fLogoDisplay.getSimulationColor());
            }
            Component subCellRendererComponent = this.fDisplayCellRenderer.getDisplayCellRendererComponent(this.fLogoDisplay, Character.toString(text.charAt(c)), this.fSelected, false, 0, c);
            int x = (this.fLogoDisplay.getInterCellSpacing().width + this.fLogoDisplay.getCellDimension().width) * c;
            int y = 0;
            int w = this.fLogoDisplay.getCellDimension().width;
            int h = this.getHeight();
            this.fCellRendererPane.paintComponent(g, subCellRendererComponent, this.fLogoDisplay, x, y, w, h);
        }
    }
}

