/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.MessageResource;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLineRTF;
import java.io.IOException;

public class IONameDisplayElement
implements DisplayElement,
MessageResource {
    protected boolean fEditable;
    protected int fType;
    protected int fBlockNumber;
    protected int fWidth;
    protected int fHeigth;
    protected int fNameID = -1;
    protected WiringDiagram fWD;
    protected int[][] nameBytes;
    protected int fCharSet;

    public IONameDisplayElement() {
    }

    public IONameDisplayElement(WiringDiagram wd, int nameID, int type, int blockNumber) {
        this.fWD = wd;
        this.fNameID = nameID;
        this.fType = type;
        this.fBlockNumber = blockNumber;
        this.fEditable = true;
        this.fWidth = 8;
        this.fHeigth = 1;
        this.nameBytes = new int[2][];
        this.nameBytes[0] = new int[8];
        this.nameBytes[1] = new int[8];
    }

    public String getStringValue() {
        Block block = this.getBlock();
        if (block instanceof InputBlock) {
            return this.getName(((InputSimulationParameter)block.getSimulationParameter()).getBinaryValue() ? 1 : 0);
        }
        if (block instanceof OutputBlock) {
            return this.getName(block.getBinaryValue() ? 1 : 0);
        }
        return "unknown";
    }

    public String getName(int index) {
        StringBuffer nameBuffer = new StringBuffer(8);
        if (MessageGlobalInfo.isBiWidthCharSet(this.fCharSet)) {
            int i = 0;
            while (i < 8) {
                int curByte = this.nameBytes[index][i];
                int nextByte = -1;
                if (i != 7) {
                    nextByte = this.nameBytes[index][i + 1];
                }
                if (curByte <= 127) {
                    nameBuffer.append(MessageLineRTF.getOneByteString(curByte, this.fCharSet));
                    ++i;
                    continue;
                }
                if (nextByte == -1) {
                    nameBuffer.append("?");
                    ++i;
                    continue;
                }
                nameBuffer.append(MessageLineRTF.getTwoBytesString(curByte, nextByte, this.fCharSet));
                i += 2;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                int curByte = this.nameBytes[index][i];
                nameBuffer.append(MessageLineRTF.getOneByteString(curByte, this.fCharSet));
            }
        }
        return nameBuffer.toString();
    }

    public int[] getNameBytes(int index, int charSet) {
        if (charSet == this.fCharSet) {
            return this.nameBytes[index];
        }
        System.out.println("Error IO displayElement, wrong charset.");
        return this.nameBytes[index];
    }

    public void setNameByte(int index, int[] bytes) {
        System.arraycopy(bytes, 0, this.nameBytes[index], 0, Math.min(bytes.length, this.nameBytes[index].length));
    }

    public void setCharSet(int charSet) {
        this.fCharSet = charSet;
    }

    public int getCharSet() {
        return this.fCharSet;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeigth;
    }

    public String toString() {
        return "IOname" + this.fNameID;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void setEditable(boolean editable) {
        this.fEditable = editable;
    }

    public int getID() {
        return this.fNameID;
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int newType) {
        if (newType == 6 || newType == 7) {
            this.fType = newType;
        }
    }

    public int getNumber() {
        return this.fBlockNumber;
    }

    public void setNumber(int blockNumber) {
        if (blockNumber > 0) {
            this.fBlockNumber = blockNumber;
        }
    }

    public Block getBlock() {
        try {
            return this.fWD.getBlockByNumberExt(this.fType, this.fBlockNumber);
        }
        catch (Exception e) {
            System.out.print("error occur in name display element, block missing");
            return null;
        }
    }

    public void read(StorableInput dr) throws IOException {
        this.fNameID = dr.readInt();
        this.fType = dr.readInt();
        this.fBlockNumber = dr.readInt();
        this.fEditable = dr.readBoolean();
        this.fWidth = dr.readInt();
        this.fHeigth = dr.readInt();
        this.nameBytes = new int[2][];
        this.nameBytes[0] = new int[8];
        this.nameBytes[1] = new int[8];
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.getID());
        dw.writeInt(this.getType());
        dw.writeInt(this.getNumber());
        dw.writeBoolean(this.isEditable());
        dw.writeInt(this.fWidth);
        dw.writeInt(this.fHeigth);
    }

    public void setID(int nameID) {
        this.fNameID = nameID;
    }
}

