/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.DisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.util.Global;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class IONameDetailsDisplayCellRenderer
extends JPanel
implements DisplayCellRenderer {
    private static final long serialVersionUID = 1L;
    protected Map fIcons;
    protected JLabel fIconLabel;
    protected JLabel fBlockNumber;
    protected JLabel fStatusName0;
    protected JLabel fStatusName1;
    protected Font fDefaultFont;
    protected Border fNoFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public IONameDetailsDisplayCellRenderer() {
        this.setLayout(new BorderLayout());
        this.fIconLabel = new JLabel();
        this.fBlockNumber = new JLabel();
        this.add((Component)this.fBlockNumber, "Center");
        Box centerPanel = new Box(1);
        this.add((Component)centerPanel, "East");
        this.fStatusName0 = new JLabel();
        centerPanel.add(this.fStatusName0);
        this.fStatusName1 = new JLabel();
        centerPanel.add(this.fStatusName1);
        this.fDefaultFont = this.fStatusName1.getFont();
        this.fIcons = new Hashtable(10);
    }

    public Component getDisplayCellRendererComponent(LogoDisplay display, Object element, boolean isSelected, boolean hasFocus, int row, int column) {
        if (element instanceof IONameDisplayElement) {
            IONameDisplayElement nameDisp = (IONameDisplayElement)element;
            Block block = nameDisp.getBlock();
            Icon icon = (Icon)this.fIcons.get(nameDisp);
            if (icon == null) {
                icon = Global.getIcon(block.getIconName());
                this.fIcons.put(nameDisp, icon);
            }
            this.fIconLabel.setIcon(icon);
            this.setNumberLableText(this.fBlockNumber, this.getTypeString(nameDisp.getType()) + nameDisp.getNumber());
            this.setNameLableText(this.fStatusName0, "0:" + nameDisp.getName(0));
            this.setNameLableText(this.fStatusName1, "1:" + nameDisp.getName(1));
            this.setBackground(new Color(192, 192, 192));
            if (isSelected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
            }
            if (hasFocus) {
                this.setBorder(display.getFocusBorder());
            } else {
                this.setBorder(this.fNoFocusBorder);
            }
            this.setOpaque(true);
            this.invalidate();
        }
        return this;
    }

    private String getTypeString(int type) {
        if (type == 6) {
            return "I";
        }
        if (type == 7) {
            return "Q";
        }
        return "?";
    }

    private void setNameLableText(JLabel lable, String text) {
        Font font = lable.getFont();
        lable.setFont(new Font(font.getName(), font.getStyle(), 9));
        if (lable.getFont().canDisplayUpTo(text) != -1) {
            lable.setFont(this.fDefaultFont);
        }
        lable.setText(text);
    }

    private void setNumberLableText(JLabel lable, String text) {
        Font font = lable.getFont();
        lable.setFont(new Font(font.getName(), 1, 12));
        if (lable.getFont().canDisplayUpTo(text) != -1) {
            lable.setFont(this.fDefaultFont);
        }
        lable.setText(text);
    }
}

