/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.ParameterItemDisplayCellEditor;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ClockHoursCellEditor
extends ParameterItemDisplayCellEditor {
    protected ClockHours fClockHours;
    protected EditableNumericSpinner fHighSpinner;
    protected EditableNumericSpinner fLowSpinner;
    protected JPanel fEditorComponent = new JPanel(){

        public void requestFocus() {
            ClockHoursCellEditor.this.fHighSpinner.requestFocus();
        }
    };
    protected JCheckBox fInactiveCheckbox;

    public ClockHoursCellEditor() {
        this.fEditorComponent.setFocusCycleRoot(true);
        this.fEditorComponent.setLayout(new BoxLayout(this.fEditorComponent, 0));
        this.fInactiveCheckbox = new JCheckBox();
        this.fInactiveCheckbox.setToolTipText(Language.getString("dialog.parameter.cam.inactive", "inactive"));
        this.fEditorComponent.add(this.fInactiveCheckbox);
        this.fInactiveCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClockHoursCellEditor.this.enableDisableTimeInputFields();
            }
        });
        this.fHighSpinner = new EditableNumericSpinner();
        this.fHighSpinner.setToolTipText(Language.getString("dialog.timeParameter.hours", "hours"));
        this.fHighSpinner.setMaximumSize(new Dimension(200, 25));
        this.fHighSpinner.setColumns(2);
        this.fEditorComponent.add(this.fHighSpinner);
        this.fLowSpinner = new EditableNumericSpinner();
        this.fLowSpinner.setToolTipText(Language.getString("dialog.timeParameter.minutes", "minutes"));
        this.fLowSpinner.setMaximumSize(new Dimension(200, 25));
        this.fLowSpinner.setColumns(2);
        this.fEditorComponent.add(this.fLowSpinner);
    }

    private void enableDisableTimeInputFields() {
        this.fHighSpinner.setEnabled(!this.fInactiveCheckbox.isSelected());
        this.fLowSpinner.setEnabled(!this.fInactiveCheckbox.isSelected());
    }

    public Component getDisplayCellEditorComponent(LogoDisplay display, Object displayElement, boolean isSelected, int row, int column) {
        Object parameterItemValue;
        super.getDisplayCellEditorComponent(display, display, isSelected, row, column);
        if (this.fParameterItem != null && (parameterItemValue = ((ParameterItem)displayElement).getValue()) instanceof ClockHours) {
            this.fClockHours = (ClockHours)parameterItemValue;
            this.fHighSpinner.setProperties(this.fClockHours.getHigh());
            this.fLowSpinner.setProperties(this.fClockHours.getLow());
            this.fInactiveCheckbox.setSelected(this.fClockHours.isInactive());
            this.enableDisableTimeInputFields();
        }
        return this.fEditorComponent;
    }

    public Object getCellEditorValue() {
        return this.fParameterItem;
    }

    public boolean stopCellEditing() {
        if (!this.fHighSpinner.checkValue(false) || !this.fLowSpinner.checkValue(false)) {
            return false;
        }
        this.fClockHours.setTime(this.fHighSpinner.getValue(), this.fLowSpinner.getValue());
        this.fClockHours.setInactive(this.fInactiveCheckbox.isSelected());
        this.fParameterItem.getParameter().fireParameterSetEvent();
        this.fireEditingStopped();
        return true;
    }
}

