/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import java.io.IOException;

public class AIDisplayElement
implements DisplayElement {
    private static final long serialVersionUID = -8060964366241272004L;
    protected int fNumber;
    protected boolean fEditable;
    protected WiringDiagram fWD;
    protected int fWidth;
    protected int fHeigth;
    protected String fFilterValue = "unkn";

    public AIDisplayElement() {
    }

    public AIDisplayElement(WiringDiagram wd, int AINumber) {
        this.fWD = wd;
        this.fNumber = AINumber;
        this.fEditable = true;
        this.fWidth = 4;
        this.fHeigth = 1;
    }

    public int getHeight() {
        return this.fHeigth;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void setEditable(boolean editable) {
        this.fEditable = editable;
    }

    public void setAINumber(int newOpcode) {
        this.fNumber = newOpcode;
    }

    public int getAINumber() {
        return this.fNumber;
    }

    public AnalogInputBlock getBlock() {
        try {
            return (AnalogInputBlock)this.fWD.getBlockByNumberExt(11, this.fNumber);
        }
        catch (Exception e) {
            System.out.print("error occur in AI display element, block missing");
            return null;
        }
    }

    public void updateFilter() {
        AnalogInputBlock block = this.getBlock();
        if (block instanceof AnalogInputBlock) {
            int value = (int)block.calculateAnalogValue();
            String tmp = String.valueOf(value);
            this.fFilterValue = "    ".substring(tmp.length()) + tmp;
        }
    }

    public String getStringValue() {
        return this.fFilterValue;
    }

    public void read(StorableInput dr) throws IOException {
        this.fNumber = dr.readInt();
        this.fEditable = dr.readBoolean();
        this.fWidth = dr.readInt();
        this.fHeigth = dr.readInt();
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.fNumber);
        dw.writeBoolean(this.fEditable);
        dw.writeInt(this.fWidth);
        dw.writeInt(this.fHeigth);
    }
}

