/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.util.Global;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class AIDetailsParameterDisplayCellRenderer
extends JPanel
implements DisplayCellRenderer {
    private static final long serialVersionUID = 1L;
    private boolean fExceptionAlreadyShown;
    protected Map fIcons;
    protected JLabel fIconLabel;
    protected JLabel fBlockNumberLabel;
    protected JLabel fParameterValueLabel;
    protected Border fNoFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public AIDetailsParameterDisplayCellRenderer() {
        this.setLayout(new BorderLayout());
        this.fIconLabel = new JLabel();
        this.add((Component)this.fIconLabel, "West");
        Box centerPanel = new Box(1);
        this.add((Component)centerPanel, "Center");
        this.fBlockNumberLabel = new JLabel();
        Font font = this.fBlockNumberLabel.getFont();
        this.fBlockNumberLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
        centerPanel.add(this.fBlockNumberLabel);
        this.fParameterValueLabel = new JLabel();
        font = this.fParameterValueLabel.getFont();
        this.fParameterValueLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        centerPanel.add(this.fParameterValueLabel);
        this.fIcons = new Hashtable(10);
    }

    public Component getDisplayCellRendererComponent(LogoDisplay display, Object element, boolean isSelected, boolean hasFocus, int row, int column) {
        if (element instanceof AIDisplayElement) {
            AIDisplayElement aiDisp = (AIDisplayElement)element;
            AnalogInputBlock block = aiDisp.getBlock();
            Icon icon = (Icon)this.fIcons.get(aiDisp);
            if (icon == null) {
                icon = Global.getIcon(block.getIconName());
                this.fIcons.put(aiDisp, icon);
            }
            this.fIconLabel.setIcon(icon);
            double value = block.calculateAnalogValue();
            String valueText = String.valueOf(value);
            String blockNumberText = block.getNumberString();
            this.fBlockNumberLabel.setText(blockNumberText);
            this.fParameterValueLabel.setText(valueText);
            this.setBackground(Color.gray);
            if (isSelected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
            }
            if (hasFocus) {
                this.setBorder(display.getFocusBorder());
            } else {
                this.setBorder(this.fNoFocusBorder);
            }
            this.setOpaque(true);
            this.invalidate();
        }
        return this;
    }
}

