/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.util.LogoError;
import javax.swing.JPasswordField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class PasswordFieldWithRestriction
extends JPasswordField {
    protected int maxLength;

    public PasswordFieldWithRestriction(int maxLength) {
        super(maxLength);
        this.maxLength = maxLength;
    }

    protected Document createDefaultModel() {
        return new PasswordDocument();
    }

    public boolean checkChanged() {
        return this.getPassword().length != 0;
    }

    protected boolean isValidString(String str) {
        if (str.length() > this.maxLength) {
            return false;
        }
        byte[] b = str.getBytes();
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 65 && b[i] <= 90) continue;
            new LogoError(this, "dialog.error.passwordField.wrongChar", "Wrong value! Only A...Z allowed.").display();
            return false;
        }
        return true;
    }

    public String getText() {
        return String.copyValueOf(this.getPassword());
    }

    protected class PasswordDocument
    extends PlainDocument {
        protected PasswordDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            str = str.toUpperCase();
            String currentString = this.getText(0, this.getLength());
            String tempString = currentString.substring(0, offs) + str + currentString.substring(offs);
            if (PasswordFieldWithRestriction.this.isValidString(tempString)) {
                super.insertString(offs, str, a);
            } else {
                PasswordFieldWithRestriction.this.getToolkit().beep();
            }
        }
    }
}

