/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.LengthRestrictedJTextField;
import DE.siemens.ad.logo.util.LogoError;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class PasswordField
extends LengthRestrictedJTextField {
    public PasswordField() {
        this.enableInputMethods(false);
    }

    public PasswordField(int cols) {
        super(cols);
        this.enableInputMethods(false);
    }

    protected Document createDefaultModel() {
        return new PasswordDocument();
    }

    public boolean isValidString(String str) {
        if (!super.isValidString(str)) {
            return false;
        }
        byte[] b = str.getBytes();
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 65 && b[i] <= 90) continue;
            new LogoError(this, "dialog.error.passwordField.wrongChar", "Wrong value! Only A...Z allowed.").display();
            return false;
        }
        return true;
    }

    public void paste() {
    }

    public void copy() {
    }

    public void cut() {
    }

    public class PasswordDocument
    extends LengthRestrictedJTextField.LengthRestrictedDocument {
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            str = str.toUpperCase();
            String currentString = this.getText(0, this.getLength());
            String tempString = currentString.substring(0, offs) + str + currentString.substring(offs);
            if (PasswordField.this.isValidString(tempString)) {
                super.insertString(offs, str, a);
            } else {
                PasswordField.this.getToolkit().beep();
            }
        }
    }
}

