/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.dialog.comp.MessageReceiptListener;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DetailsParameterDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditorListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayFocusEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayFocusListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayToolTipProvider;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelPlain;
import DE.siemens.ad.logo.dialog.comp.display.ParameterItemDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.ReadOnlyDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.SimulationDisplayCellEditorAllocator;
import DE.siemens.ad.logo.dialog.comp.display.TickerDisplayModel;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;

public class MessageDisplay
extends BorderJPanel {
    private JToggleButton fBtDetails;
    private JToggleButton fBtEditParameterItemValue;
    private LogoDisplay fLogoDisplay;
    private MessageParameter fMessageParameter;
    private JCheckBox fReceiptCheckbox = null;
    private JPanel fReceiptPanel = null;
    private ArrayList fMessageReceiptListener;
    private JPanel fDisplayContainer = null;
    private JComponent fButtonPanel;
    private DisplayModel fDisplayModel;
    private int fCharsetID;
    private static DisplayModel fNoMessageModel;
    private volatile boolean fIsRepainting = false;

    public MessageDisplay() {
        this.initialize();
        this.registerListners();
        this.fLogoDisplay.setFocusPosition(new Point(0, 0));
    }

    public void activateDeactivateEditButton() {
        if (this.fMessageParameter != null && this.fMessageParameter.getProtection()) {
            this.fBtEditParameterItemValue.setEnabled(false);
            return;
        }
        DisplayElement displayElement = this.fLogoDisplay.getModel().getElementAt(this.fLogoDisplay.getFocusPosition());
        if (displayElement instanceof ParameterItem && displayElement.isEditable()) {
            if (((ParameterItem)displayElement).getValue() instanceof ValueOrItemReference && ((ValueOrItemReference)((ParameterItem)displayElement).getValue()).isReference()) {
                this.fBtEditParameterItemValue.setEnabled(false);
                return;
            }
            this.fBtEditParameterItemValue.setEnabled(true);
        } else {
            this.fBtEditParameterItemValue.setEnabled(false);
        }
    }

    private void registerListners() {
        this.fBtDetails.addActionListener(new DetailsButtonHandler());
        this.fLogoDisplay.addDisplayFocusListener(new DisplayFocusListener(){

            public void displayFocusPositionChanged(DisplayFocusEvent displayFocusEvent) {
                MessageDisplay.this.activateDeactivateEditButton();
            }
        });
        this.fBtEditParameterItemValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Point focusPosition = MessageDisplay.this.fLogoDisplay.getFocusPosition();
                MessageDisplay.this.fLogoDisplay.editCellAt(focusPosition.y, focusPosition.x, new EventObject(MessageDisplay.this.fLogoDisplay));
            }
        });
        this.getReceiptCheckbox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MessageDisplay.this.fireMessageReceiptEvent();
            }
        });
        this.fLogoDisplay.addDisplayCellEditorListener(new DisplayCellEditorHandler());
    }

    public void activateUpdate() {
        if (this.getMessageManager().isRTFMessage()) {
            this.fDisplayModel = this.getMessageParameter().getMessageRTF(this.fCharsetID) != null ? this.getMessageManager().getDisplayModel(this.getMessageParameter(), this.fCharsetID) : this.getNoMessageModel();
            if (this.fDisplayModel instanceof TickerDisplayModel) {
                ((TickerDisplayModel)this.fDisplayModel).initTimers();
            }
        } else {
            this.fDisplayModel = new MessageParameterDisplayModelPlain(this.getMessageParameter());
        }
        this.getLogoDisplay().setModel(this.fDisplayModel);
    }

    private DisplayModel getNoMessageModel() {
        if (fNoMessageModel == null) {
            String noMsg = "No message  for current charset";
            fNoMessageModel = new ReadOnlyDisplayModel(new Dimension(12, 4), noMsg);
        }
        return fNoMessageModel;
    }

    private MessageManager getMessageManager() {
        return this.getMessageParameter().getBlock().getWiringDiagram().getMessageManager();
    }

    public void addMessageReceiptListener(MessageReceiptListener newMessageReceiptListener) {
        if (this.fMessageReceiptListener == null) {
            this.fMessageReceiptListener = new ArrayList(4);
        }
        if (!this.fMessageReceiptListener.contains(newMessageReceiptListener)) {
            this.fMessageReceiptListener.add(newMessageReceiptListener);
        }
    }

    public int compareTo(Object obj) {
        return Integer.valueOf(this.getName()).compareTo(Integer.valueOf(((MessageDisplay)obj).getName()));
    }

    public void deactivateUpdate() {
        if (this.fDisplayModel instanceof TickerDisplayModel) {
            ((TickerDisplayModel)this.fDisplayModel).cancleTimers();
        }
        this.getLogoDisplay().setModel(null);
        this.fDisplayModel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMessageReceiptEvent() {
        if (this.fIsRepainting) {
            return;
        }
        if (this.getReceiptCheckbox().isSelected() && this.fMessageReceiptListener != null) {
            ArrayList list;
            MessageDisplay messageDisplay = this;
            synchronized (messageDisplay) {
                list = (ArrayList)this.fMessageReceiptListener.clone();
            }
            Iterator e = list.iterator();
            while (e.hasNext()) {
                ((MessageReceiptListener)e.next()).messageReceipt(this);
            }
        }
    }

    private JPanel getDisplayContainer() {
        if (this.fDisplayContainer == null) {
            this.fDisplayContainer = new JPanel();
            this.fDisplayContainer.setName("DummyPanelWest");
            this.fDisplayContainer.setLayout(new BorderLayout());
            JPanel fFixSizePanel = new JPanel();
            fFixSizePanel.add(this.getLogoDisplay());
            this.fDisplayContainer.add((Component)new JScrollPane(fFixSizePanel), "Center");
            this.fDisplayContainer.add((Component)this.getButtonPanel(), "North");
        }
        return this.fDisplayContainer;
    }

    public JComponent getButtonPanel() {
        if (this.fButtonPanel == null) {
            this.fButtonPanel = new JToolBar();
            ((JToolBar)this.fButtonPanel).setFloatable(false);
            this.fBtDetails = new JToggleButton("Details");
            this.fButtonPanel.add(this.fBtDetails);
            this.fBtEditParameterItemValue = new JToggleButton(Global.getIcon("Editable.gif"));
            this.fButtonPanel.add(this.fBtEditParameterItemValue);
        }
        return this.fButtonPanel;
    }

    public LogoDisplay getLogoDisplay() {
        if (this.fLogoDisplay == null) {
            this.fLogoDisplay = new LogoDisplay();
            this.fLogoDisplay.setDynamicCellDimensionEnabled(false);
            this.fLogoDisplay.setSimulationMode(true);
            this.fLogoDisplay.setCellRenderer(ParameterItem.class, new ParameterItemDisplayCellRenderer());
            this.fLogoDisplay.setCellRenderer(BarDisplayElement.class, new BarDisplayCellRenderer());
            this.fLogoDisplay.setCellRenderer(IONameDisplayElement.class, new IONameDisplayCellRenderer());
            this.fLogoDisplay.setCellRenderer(AIDisplayElement.class, new AIDisplayCellRenderer());
            try {
                SimulationDisplayCellEditorAllocator editorAllocator = new SimulationDisplayCellEditorAllocator();
                this.fLogoDisplay.setDisplayCellEditorAllocator(editorAllocator);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fLogoDisplay.setToolTipProvider(new SimulationDisplayToolTipProvider());
        }
        return this.fLogoDisplay;
    }

    public MessageParameter getMessageParameter() {
        return this.fMessageParameter;
    }

    private JCheckBox getReceiptCheckbox() {
        if (this.fReceiptCheckbox == null) {
            try {
                this.fReceiptCheckbox = new JCheckBox();
                this.fReceiptCheckbox.setName("ReceiptCheckbox");
                this.fReceiptCheckbox.setText("Receipt");
                this.fReceiptCheckbox.setActionCommand("");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fReceiptCheckbox;
    }

    private JPanel getReceiptPanel() {
        if (this.fReceiptPanel == null) {
            this.fReceiptPanel = new JPanel(new BorderLayout());
            this.fReceiptPanel.add((Component)this.getReceiptCheckbox(), "West");
            this.fReceiptPanel.setPreferredSize(new Dimension(0, 24));
        }
        return this.fReceiptPanel;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        this.setName("MessageDisplay");
        this.setLayout(new BorderLayout());
        this.add((Component)this.getReceiptPanel(), "South");
        this.add((Component)this.getDisplayContainer(), "Center");
        this.setLabels();
    }

    private void resetTicker() {
        if (this.fDisplayModel instanceof TickerDisplayModel) {
            ((TickerDisplayModel)this.fDisplayModel).resetTicker();
        }
    }

    public boolean isReceiptVisible() {
        return this.getReceiptCheckbox().isVisible();
    }

    public void removeMessageReceiptListener(MessageReceiptListener messageReceiptListener) {
        this.fMessageReceiptListener.remove(messageReceiptListener);
    }

    public void setReceipt(boolean state) {
        if (this.fMessageParameter.isReceipt()) {
            this.getReceiptCheckbox().setSelected(state);
        }
    }

    public void setEnabled(boolean status) {
        super.setEnabled(status);
        this.resetTicker();
    }

    public void setLabels() {
        this.setTitle(Language.getString("dialog.parameter.message.messageBorder", "Display"));
        this.getReceiptCheckbox().setText(Language.getString("dialog.messageDisplay.receipt", "Receipt"));
        this.fBtDetails.setText(Language.getString("dialog.parameter.message.details", "Details"));
    }

    public void setMessageParameter(MessageParameter newMessageParameter, int charsetID) {
        this.deactivateUpdate();
        this.fMessageParameter = newMessageParameter;
        this.fCharsetID = charsetID % 2;
        this.activateUpdate();
        this.getReceiptCheckbox().setVisible(this.fMessageParameter.isReceipt());
        if (this.fMessageParameter != null) {
            this.getLogoDisplay().setProtectionMode(this.fMessageParameter.getProtection());
        } else {
            System.err.println("Protection mode set failed.");
        }
    }

    public void updateReceiptStatus() {
        boolean fEnabled;
        boolean fSelected = this.fMessageParameter.isReceiptDone();
        boolean bl = fEnabled = !fSelected;
        if (fSelected != this.getReceiptCheckbox().isSelected()) {
            this.fIsRepainting = true;
            this.getReceiptCheckbox().setSelected(fSelected);
            this.fIsRepainting = false;
        }
        if (fEnabled != this.getReceiptCheckbox().isEnabled()) {
            this.getReceiptCheckbox().setEnabled(fEnabled);
        }
    }

    public void setReceiptEnabled(boolean value) {
        this.getReceiptCheckbox().setEnabled(value);
    }

    public void setReceiptVisible(boolean value) {
        this.getReceiptCheckbox().setVisible(value);
        this.getReceiptCheckbox().setEnabled(false);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.getMessageParameter().toString());
        return str.delete(7, 16).toString();
    }

    protected class SimulationDisplayToolTipProvider
    implements DisplayToolTipProvider {
        protected SimulationDisplayToolTipProvider() {
        }

        public String getToolTipText(LogoDisplay display, DisplayElement displayElement) {
            if (displayElement instanceof ParameterItem) {
                ParameterItem parameterItem = (ParameterItem)displayElement;
                BlockParameter parameter = parameterItem.getParameter();
                boolean editable = parameterItem.isEditable() && !MessageDisplay.this.fMessageParameter.getProtection();
                StringBuffer tooltip = new StringBuffer("<html><b>");
                tooltip.append(parameter.getBlock().getNumberString()).append(" " + parameterItem.getLocalisedName()).append("</b>");
                if (parameterItem.getParameterValueType() == 1) {
                    String actualUrlString = this.getClass().getResource("/DE/siemens/ad/logo/images/Refresh.gif").toString();
                    tooltip.append("<img src=\"").append(actualUrlString).append("\" alt=\"actual value\">");
                }
                if (editable && parameter instanceof ProtectionParameter && ((ProtectionParameter)parameter).getProtection()) {
                    editable = false;
                }
                if (editable) {
                    String cutUrlString = this.getClass().getResource("/DE/siemens/ad/logo/images/Editable.gif").toString();
                    tooltip.append("<img src=\"").append(cutUrlString).append("\" alt=\"editable\">");
                    tooltip.append("<br>(").append(Language.getString("dialog.messageDisplay.tooltip.doubleClickToEdit", "Doubleclick to edit")).append(")");
                }
                tooltip.append("<p>");
                tooltip.append(Language.getString("dialog.messageDisplay.tooltip.useRightMouse", "Use right mouse button!"));
                return tooltip.append("</html>").toString();
            }
            return null;
        }
    }

    protected class DetailsButtonHandler
    implements ActionListener {
        protected DetailsButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MessageDisplay.this.fBtDetails.isSelected()) {
                MessageDisplay.this.getLogoDisplay().setCellRenderer(ParameterItem.class, new DetailsParameterDisplayCellRenderer());
            } else {
                MessageDisplay.this.getLogoDisplay().setCellRenderer(ParameterItem.class, new ParameterItemDisplayCellRenderer());
            }
            MessageDisplay.this.getLogoDisplay().repaint();
        }
    }

    protected class DisplayCellEditorHandler
    implements DisplayCellEditorListener {
        protected DisplayCellEditorHandler() {
        }

        public void editingStarted(ChangeEvent e) {
            MessageDisplay.this.fBtEditParameterItemValue.setSelected(true);
        }

        public void editingCanceled(ChangeEvent e) {
            MessageDisplay.this.fBtEditParameterItemValue.setSelected(false);
        }

        public void editingStopped(ChangeEvent e) {
            MessageDisplay.this.fBtEditParameterItemValue.setSelected(false);
        }
    }
}

